/*
 * Decompiled with CFR 0.152.
 */
package fabric.common;

import fabric.common.util.OidKeyHashMap;
import fabric.lang.Object;
import fabric.lang.security.Label;
import fabric.lang.security.LabelUtil;
import fabric.lang.security.NodePrincipal;
import fabric.lang.security.Principal;
import fabric.worker.Store;
import fabric.worker.Worker;

public class AuthorizationUtil {
    private static final OidKeyHashMap<OidKeyHashMap<Void>> cachedReadAuthorizations = new OidKeyHashMap();
    private static final OidKeyHashMap<OidKeyHashMap<Void>> cachedWriteAuthorizations = new OidKeyHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkAuthorizationCache(OidKeyHashMap<OidKeyHashMap<Void>> cache, NodePrincipal principal, Store store, long labelOnum) {
        OidKeyHashMap<Void> submap;
        OidKeyHashMap<java.lang.Object> oidKeyHashMap = cache;
        synchronized (oidKeyHashMap) {
            submap = cache.get(store, labelOnum);
            if (submap == null) {
                return false;
            }
        }
        oidKeyHashMap = submap;
        synchronized (oidKeyHashMap) {
            return submap.containsKey((Object)principal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheAuthorization(OidKeyHashMap<OidKeyHashMap<Void>> cache, NodePrincipal principal, Store store, long labelOnum) {
        OidKeyHashMap<Void> submap;
        OidKeyHashMap<java.lang.Object> oidKeyHashMap = cache;
        synchronized (oidKeyHashMap) {
            submap = cache.get(store, labelOnum);
            if (submap == null) {
                submap = new OidKeyHashMap();
                cache.put(store, labelOnum, submap);
            }
        }
        oidKeyHashMap = submap;
        synchronized (oidKeyHashMap) {
            submap.put((Object)principal, null);
        }
    }

    public static boolean isReadPermitted(NodePrincipal principal, Store store, long labelOnum) {
        if (principal == Worker.getWorker().getPrincipal()) {
            return true;
        }
        if (AuthorizationUtil.checkAuthorizationCache(cachedReadAuthorizations, principal, store, labelOnum)) {
            return true;
        }
        Label._Proxy label = new Label._Proxy(store, labelOnum);
        boolean result = Worker.runInSubTransaction(new Worker.Code<Boolean>((Label)label, principal){
            final /* synthetic */ Label val$label;
            final /* synthetic */ NodePrincipal val$principal;
            {
                this.val$label = label;
                this.val$principal = nodePrincipal;
            }

            @Override
            public Boolean run() {
                return LabelUtil._Impl.isReadableBy((Label)this.val$label, (Principal)this.val$principal);
            }
        });
        if (result) {
            AuthorizationUtil.cacheAuthorization(cachedReadAuthorizations, principal, store, labelOnum);
        }
        return result;
    }

    public static boolean isWritePermitted(NodePrincipal principal, Store store, long labelOnum) {
        if (principal == Worker.getWorker().getPrincipal()) {
            return true;
        }
        if (AuthorizationUtil.checkAuthorizationCache(cachedWriteAuthorizations, principal, store, labelOnum)) {
            return true;
        }
        Label._Proxy label = new Label._Proxy(store, labelOnum);
        boolean result = Worker.runInSubTransaction(new Worker.Code<Boolean>((Label)label, principal){
            final /* synthetic */ Label val$label;
            final /* synthetic */ NodePrincipal val$principal;
            {
                this.val$label = label;
                this.val$principal = nodePrincipal;
            }

            @Override
            public Boolean run() {
                return LabelUtil._Impl.isWritableBy((Label)this.val$label, (Principal)this.val$principal);
            }
        });
        if (result) {
            AuthorizationUtil.cacheAuthorization(cachedWriteAuthorizations, principal, store, labelOnum);
        }
        return result;
    }
}

