/*
 * Decompiled with CFR 0.152.
 */
package fabric.common;

import fabric.common.FabricThread;
import fabric.common.Logging;
import fabric.common.MessageHandler;
import fabric.common.exceptions.InternalError;
import fabric.messages.Message;
import fabric.worker.transaction.TransactionManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.Pipe;
import java.util.Stack;
import java.util.logging.Level;

public abstract class AbstractMessageHandlerThread<Session extends SessionAttributes, MessageHandlerThread extends AbstractMessageHandlerThread<Session, MessageHandlerThread>>
extends FabricThread.AbstractImpl
implements MessageHandler {
    private final String threadName;
    private DataInputStream in;
    private DataOutputStream out;
    private Pipe.SourceChannel source;
    private Pipe.SinkChannel sink;
    protected final Pool<MessageHandlerThread> pool;
    protected Session session;
    private boolean recycle;
    private boolean readyToAssociate;

    protected AbstractMessageHandlerThread(String name, Pool<MessageHandlerThread> pool) {
        super(name + " -- initializing");
        this.threadName = name;
        this.pool = pool;
        this.recycle = false;
        this.readyToAssociate = false;
    }

    @Override
    public final synchronized void run() {
        while (!this.shuttingDown()) {
            Thread.currentThread().setName(this.threadName + " -- idle");
            this.readyToAssociate = true;
            this.notifyAll();
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                this.recycle = false;
                continue;
            }
            Thread.currentThread().setName(this.threadName + " -- active");
            try {
                this.run_();
            }
            catch (ClosedByInterruptException e) {
            }
            catch (EOFException e) {
            }
            catch (IOException e) {
                Logging.NETWORK_CONNECTION_LOGGER.log(Level.WARNING, "Connection closed prematurely", e);
            }
            if (!this.pool.handlerDone(this)) continue;
        }
        TransactionManager.getInstance().deregisterThread(this);
    }

    protected boolean shuttingDown() {
        return false;
    }

    private final void run_() throws IOException {
        try {
            while (true) {
                Message.receive(this.in, this.out, this);
            }
        }
        catch (ClosedByInterruptException e) {
            if (!this.recycle) {
                throw e;
            }
            this.recycle = false;
            return;
        }
    }

    public final Session getSession() {
        return this.session;
    }

    public final synchronized void associateSession(Session session) {
        while (!this.readyToAssociate) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        this.session = session;
        this.initPipes();
        this.readyToAssociate = false;
        this.notifyAll();
    }

    private void initPipes() {
        try {
            Pipe inbound = Pipe.open();
            this.sink = inbound.sink();
            Pipe.SourceChannel inboundSource = inbound.source();
            inboundSource.configureBlocking(true);
            this.in = new DataInputStream(new BufferedInputStream(Channels.newInputStream(inboundSource)));
            Pipe outbound = Pipe.open();
            this.source = outbound.source();
            Pipe.SinkChannel outboundSink = outbound.sink();
            outboundSink.configureBlocking(true);
            this.out = new DataOutputStream(new BufferedOutputStream(Channels.newOutputStream(outboundSink)));
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    public final void recycle() {
        this.recycle = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        this.session = null;
        try {
            this.in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.in = null;
        try {
            this.out.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.out = null;
        this.source = null;
        try {
            Pipe.SinkChannel e = this.sink;
            synchronized (e) {
                this.sink.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.sink = null;
    }

    public Pipe.SourceChannel source() {
        return this.source;
    }

    public Pipe.SinkChannel sink() {
        return this.sink;
    }

    public static final class Pool<MessageHandlerThread extends AbstractMessageHandlerThread<?, MessageHandlerThread>> {
        private final Stack<MessageHandlerThread> pool = new Stack();
        private final int maxSize;
        private final Factory<MessageHandlerThread> factory;
        private boolean destroyed;

        public Pool(int size, Factory<MessageHandlerThread> threadFactory) {
            this.maxSize = size;
            this.factory = threadFactory;
            this.destroyed = false;
        }

        public synchronized MessageHandlerThread get() {
            if (this.pool.isEmpty()) {
                return this.factory.createMessageHandler(this);
            }
            return (MessageHandlerThread)((AbstractMessageHandlerThread)this.pool.pop());
        }

        public synchronized boolean handlerDone(MessageHandlerThread handler) {
            ((AbstractMessageHandlerThread)handler).cleanup();
            if (this.pool.size() == this.maxSize) {
                return true;
            }
            if (!this.destroyed) {
                this.pool.push(handler);
            }
            return this.destroyed;
        }

        public synchronized void shutdown() {
            this.destroyed = true;
            while (!this.pool.empty()) {
                ((AbstractMessageHandlerThread)this.pool.pop()).interrupt();
            }
        }
    }

    protected static interface Factory<MessageHandlerThread extends AbstractMessageHandlerThread<?, MessageHandlerThread>> {
        public MessageHandlerThread createMessageHandler(Pool<MessageHandlerThread> var1);
    }

    public static abstract class SessionAttributes {
        public void endSession() {
        }
    }
}

