/*
 * Decompiled with CFR 0.152.
 */
package fabric.common;

import fabric.common.AbstractMessageHandlerThread;
import fabric.common.Options;
import fabric.common.exceptions.InternalError;
import fabric.common.exceptions.RuntimeFetchException;
import fabric.common.util.Pair;
import fabric.lang.security.NodePrincipal;
import fabric.net.ChannelMultiplexerThread;
import fabric.worker.RemoteStore;
import fabric.worker.Store;
import fabric.worker.Worker;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractConnectionHandler<Node, Session extends AbstractMessageHandlerThread.SessionAttributes, MessageHandlerThread extends AbstractMessageHandlerThread<Session, MessageHandlerThread>> {
    private boolean destroyed;
    private final AbstractMessageHandlerThread.Pool<MessageHandlerThread> threadPool;
    private final Set<ChannelMultiplexerThread> activeMuxThreads;

    protected AbstractConnectionHandler(int poolSize, AbstractMessageHandlerThread.Factory<MessageHandlerThread> handlerFactory) {
        this.threadPool = new AbstractMessageHandlerThread.Pool<MessageHandlerThread>(poolSize, handlerFactory);
        this.activeMuxThreads = new HashSet<ChannelMultiplexerThread>();
        this.destroyed = false;
    }

    protected abstract Node getNodeByName(String var1);

    protected Session newUnauthenticatedSession(Node node, String remoteNodeName) {
        return null;
    }

    protected abstract Session newAuthenticatedSession(Node var1, String var2, String var3, NodePrincipal var4);

    protected abstract void logAuthenticationFailure();

    protected abstract void logSession(SocketAddress var1, Session var2);

    protected abstract String getThreadName(SocketAddress var1, Session var2);

    public final void handle(final SocketChannel connection) {
        new Thread("Connection initializer"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AbstractMessageHandlerThread.SessionAttributes session = AbstractConnectionHandler.this.initializeConnection(connection);
                    if (session == null) {
                        AbstractConnectionHandler.this.logAuthenticationFailure();
                        connection.close();
                        return;
                    }
                    SocketAddress remote = connection.socket().getRemoteSocketAddress();
                    AbstractConnectionHandler.this.logSession(remote, session);
                    AbstractConnectionHandler abstractConnectionHandler = AbstractConnectionHandler.this;
                    synchronized (abstractConnectionHandler) {
                        if (AbstractConnectionHandler.this.destroyed) {
                            return;
                        }
                        ChannelMultiplexerThread mux = new ChannelMultiplexerThread(new CallbackHandler(AbstractConnectionHandler.this, session), AbstractConnectionHandler.this.getThreadName(remote, session), connection);
                        AbstractConnectionHandler.this.activeMuxThreads.add(mux);
                        mux.start();
                    }
                }
                catch (IOException e) {
                    throw new InternalError(e);
                }
            }
        }.start();
    }

    public final synchronized void shutdown() {
        this.destroyed = true;
        for (ChannelMultiplexerThread mux : this.activeMuxThreads) {
            mux.shutdown();
        }
        this.threadPool.shutdown();
    }

    private Session initializeConnection(SocketChannel connection) throws IOException {
        DataInputStream dataIn = new DataInputStream(connection.socket().getInputStream());
        OutputStream out = connection.socket().getOutputStream();
        String nodeName = dataIn.readUTF();
        Node node = this.getNodeByName(nodeName);
        if (node == null) {
            out.write(0);
            out.flush();
            return null;
        }
        out.write(1);
        out.flush();
        String remoteNodeName = dataIn.readUTF();
        return this.initializeSession(node, remoteNodeName, dataIn);
    }

    private Session initializeSession(Node node, String remoteNodeName, DataInput dataIn) throws IOException {
        boolean usingSSL = dataIn.readBoolean();
        if (!usingSSL) {
            return this.newUnauthenticatedSession(node, remoteNodeName);
        }
        String remoteNodePrincipalName = !Options.DEBUG_NO_SSL ? dataIn.readUTF() : dataIn.readUTF();
        NodePrincipal._Proxy remoteNodePrincipal = null;
        if (dataIn.readBoolean()) {
            String principalStoreName = dataIn.readUTF();
            RemoteStore principalStore = Worker.getWorker().getStore(principalStoreName);
            long principalOnum = dataIn.readLong();
            remoteNodePrincipal = new NodePrincipal._Proxy((Store)principalStore, principalOnum);
        }
        Pair<Boolean, NodePrincipal> authResult = this.authenticateRemote((NodePrincipal)remoteNodePrincipal, remoteNodePrincipalName);
        if (((Boolean)authResult.first).booleanValue()) {
            return this.newAuthenticatedSession(node, remoteNodeName, remoteNodePrincipalName, (NodePrincipal)authResult.second);
        }
        return null;
    }

    private Pair<Boolean, NodePrincipal> authenticateRemote(final NodePrincipal principal, final String name) {
        if (principal == null) {
            return new Pair<Boolean, Object>(true, null);
        }
        return Worker.runInTransactionUnauthenticated(new Worker.Code<Pair<Boolean, NodePrincipal>>(){

            @Override
            public Pair<Boolean, NodePrincipal> run() {
                boolean success = false;
                NodePrincipal authenticatedPrincipal = null;
                try {
                    if (principal.name().equals(name)) {
                        success = true;
                        authenticatedPrincipal = principal;
                    }
                }
                catch (ClassCastException e) {
                }
                catch (RuntimeFetchException e) {
                    success = true;
                }
                return new Pair<Boolean, Object>(success, authenticatedPrincipal);
            }
        });
    }

    private static final class CallbackHandler
    implements ChannelMultiplexerThread.CallbackHandler {
        private final Session session;
        private final List<MessageHandlerThread> handlers;
        final /* synthetic */ AbstractConnectionHandler this$0;

        public CallbackHandler(Session session) {
            this.this$0 = var1_1;
            this.session = session;
            this.handlers = new ArrayList();
        }

        @Override
        public void connectionClosed() {
            for (AbstractMessageHandlerThread handler : this.handlers) {
                handler.recycle();
            }
            this.handlers.clear();
        }

        @Override
        public void newStream(ChannelMultiplexerThread muxer, int streamID) {
            Object handler = this.this$0.threadPool.get();
            ((AbstractMessageHandlerThread)handler).associateSession(this.session);
            this.handlers.add(handler);
            try {
                muxer.registerChannels(streamID, ((AbstractMessageHandlerThread)handler).source(), ((AbstractMessageHandlerThread)handler).sink());
            }
            catch (IOException e) {
                throw new InternalError(e);
            }
        }

        @Override
        public void shutdown() {
            for (AbstractMessageHandlerThread handler : this.handlers) {
                handler.interrupt();
            }
            ((AbstractMessageHandlerThread.SessionAttributes)this.session).endSession();
        }
    }
}

