/*
 * Decompiled with CFR 0.152.
 */
package fabric.ast;

import fabric.ast.FabricCall;
import fabric.types.FabricTypeSystem;
import java.util.ArrayList;
import java.util.List;
import jif.ast.JifCall_c;
import jif.ast.JifUtil;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.LabeledType;
import jif.types.principal.Principal;
import polyglot.ast.Expr;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.types.PrimitiveType;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeChecker;

public class FabricCall_c
extends JifCall_c
implements FabricCall {
    protected Expr remoteWorker;
    protected Principal remoteWorkerPrincipal;

    public FabricCall_c(Position pos, Receiver target, Id name, List args) {
        this(pos, target, name, null, args);
    }

    public FabricCall_c(Position pos, Receiver target, Id name, Expr remoteWorker, List args) {
        super(pos, target, name, args);
        this.remoteWorker = remoteWorker;
    }

    protected FabricCall_c reconstruct(Receiver target, Id name, Expr remoteWorker, List arguments) {
        FabricCall_c n = (FabricCall_c)super.reconstruct(target, name, arguments);
        if (remoteWorker != this.remoteWorker) {
            n = (FabricCall_c)n.copy();
            n.remoteWorker = remoteWorker;
        }
        return n;
    }

    @Override
    public Expr remoteWorker() {
        return this.remoteWorker;
    }

    @Override
    public FabricCall remoteWorker(Expr remoteWorker) {
        if (remoteWorker == this.remoteWorker) {
            return this;
        }
        FabricCall_c n = (FabricCall_c)this.copy();
        n.remoteWorker = remoteWorker;
        return n;
    }

    public Node visitChildren(NodeVisitor v) {
        Receiver target = (Receiver)this.visitChild((Node)this.target, v);
        Id name = (Id)this.visitChild((Node)this.name, v);
        Expr remoteWorker = (Expr)this.visitChild((Node)this.remoteWorker, v);
        List arguments = this.visitList(this.arguments, v);
        return this.reconstruct(target, name, remoteWorker, arguments);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        FabricCall c = (FabricCall)super.typeCheck(tc);
        if (c.remoteWorker() != null) {
            ReferenceType rcvrType;
            FabricTypeSystem ts = (FabricTypeSystem)tc.typeSystem();
            JifContext context = (JifContext)tc.context();
            Type rcType = c.target().type();
            if (rcType instanceof LabeledType) {
                LabeledType lType = (LabeledType)rcType;
                rcvrType = lType.toReference();
            } else if (rcType instanceof ReferenceType) {
                rcvrType = (ReferenceType)rcType;
            } else {
                throw new InternalCompilerError("Stupid compiler");
            }
            ArrayList<PrimitiveType> argTypes = new ArrayList<PrimitiveType>(c.methodInstance().formalTypes().size() + 1);
            argTypes.add(ts.Principal());
            argTypes.addAll(c.methodInstance().formalTypes());
            if (rcvrType.methods(c.name() + "_remote", argTypes).isEmpty()) {
                throw new SemanticException("Illegal remote call \"" + c + "\", " + "because the dynamic label check might leak information." + "\nAlso, make sure the method you are trying to call is public and not static or abstract.", c.position());
            }
            return c.remoteWorkerPrincipal(JifUtil.exprToPrincipal((JifTypeSystem)ts, (Expr)c.remoteWorker(), (JifContext)context));
        }
        return c;
    }

    @Override
    public Principal remoteWorkerPrincipal() {
        return this.remoteWorkerPrincipal;
    }

    @Override
    public FabricCall remoteWorkerPrincipal(Principal p) {
        if (p == this.remoteWorkerPrincipal) {
            return this;
        }
        FabricCall_c n = (FabricCall_c)this.copy();
        n.remoteWorkerPrincipal = p;
        return n;
    }
}

