/*
 * Decompiled with CFR 0.152.
 */
package fabric.ast;

import fabric.ExtensionInfo;
import fabric.FabricOptions;
import fabric.types.FabricParsedClassType;
import fabric.types.FabricTypeSystem;
import java.util.List;
import jif.ast.JifClassDecl_c;
import jif.types.label.Label;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.FieldDecl;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.main.Report;
import polyglot.types.Flags;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.util.Position;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.TypeChecker;

public class ClassDecl_c
extends JifClassDecl_c {
    public ClassDecl_c(Position pos, Flags flags, Id name, List params, TypeNode superClass, List interfaces, List authority, ClassBody body) {
        super(pos, flags, name, params, superClass, interfaces, authority, body);
    }

    protected void setSuperClass(AmbiguityRemover ar, TypeNode superClass) throws SemanticException {
        FabricTypeSystem ts = (FabricTypeSystem)ar.typeSystem();
        String fullName = this.type.fullName();
        if (superClass != null || this.type.equals(ts.Object()) || this.type.equals(ts.FObject()) || fullName.equals(ts.Object().fullName()) || fullName.equals(ts.FObject().fullName())) {
            super.setSuperClass(ar, superClass);
        } else {
            if (Report.should_report((String)"types", (int)3)) {
                Report.report((int)3, (String)("setting superclass of " + this.type + " to " + ts.FObject()));
            }
            this.type.superType((Type)ts.FObject());
        }
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        ClassDecl cd = (ClassDecl)super.typeCheck(tc);
        FabricParsedClassType pct = (FabricParsedClassType)cd.type();
        Label defaultFieldLabel = pct.defaultFieldLabel();
        FabricTypeSystem ts = (FabricTypeSystem)tc.typeSystem();
        if (!ts.isFabricClass((Type)pct)) {
            return cd;
        }
        for (ClassMember cm : cd.body().members()) {
            FieldDecl fd;
            if (!(cm instanceof FieldDecl) || (fd = (FieldDecl)cm).flags().isStatic()) continue;
            FabricOptions opts = (FabricOptions)((ExtensionInfo)tc.job().extensionInfo()).getOptions();
            boolean sigMode = opts.signatureMode();
            Type ft = fd.type().type();
            Label fl = ts.labelOfType(ft);
            if (!ts.isFabricClass(ft) || ts.equals((TypeObject)defaultFieldLabel, (TypeObject)fl) || sigMode) continue;
            throw new SemanticException("The field " + fd.fieldInstance() + " has a different label than " + "the default field label " + defaultFieldLabel + "of the class " + pct + ".", fd.position());
        }
        return cd;
    }
}

