/*
 * Decompiled with CFR 0.152.
 */
package fabric;

import fabric.ExtensionInfo;
import fabric.FabricOptions;
import fabric.ast.FabricNodeFactory;
import fabric.types.FabricTypeSystem;
import fabric.visit.ExplicitSuperclassAdder;
import fabric.visit.FabricExceptionChecker;
import fabric.visit.FabricToFabilRewriter;
import fabric.visit.FabricTypeBuilder;
import fabric.visit.PrincipalCastAdder;
import fabric.visit.RemoteCallWrapperAdder;
import fabric.visit.RemoteCallWrapperUpdater;
import fabric.visit.ThisLabelChecker;
import java.util.ArrayList;
import java.util.Collection;
import jif.JifScheduler;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.frontend.CyclicDependencyException;
import polyglot.frontend.JLExtensionInfo;
import polyglot.frontend.Job;
import polyglot.frontend.Scheduler;
import polyglot.frontend.Source;
import polyglot.frontend.goals.Disambiguated;
import polyglot.frontend.goals.Goal;
import polyglot.frontend.goals.Serialized;
import polyglot.frontend.goals.VisitorGoal;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.visit.NodeVisitor;

public class FabricScheduler
extends JifScheduler {
    protected fabil.ExtensionInfo filext;
    protected ExtensionInfo fabext;

    public FabricScheduler(ExtensionInfo fabext, fabil.ExtensionInfo filext) {
        super((jif.ExtensionInfo)fabext, (JLExtensionInfo)filext);
        this.fabext = fabext;
        this.filext = filext;
    }

    public Job addJob(Source source, Node ast) {
        Job j = super.addJob(source, ast);
        if ("Object.fab".equals(source.name())) {
            this.objectJob = j;
        }
        return j;
    }

    public Job addJob(Source source) {
        Job j = super.addJob(source);
        if ("Object.fab".equals(source.name())) {
            this.objectJob = j;
        }
        return j;
    }

    public Goal ExplicitSuperclassesAdded(Job job) {
        FabricTypeSystem ts = this.fabext.typeSystem();
        FabricNodeFactory nf = this.fabext.nodeFactory();
        Goal g = this.internGoal((Goal)new VisitorGoal(job, (NodeVisitor)new ExplicitSuperclassAdder(ts, (NodeFactory)nf)));
        try {
            this.addPrerequisiteDependency(g, this.Parsed(job));
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError((Throwable)e);
        }
        return g;
    }

    public Goal RemoteCallWrappersAdded(Job job) {
        FabricTypeSystem ts = this.fabext.typeSystem();
        FabricNodeFactory nf = this.fabext.nodeFactory();
        Goal g = this.internGoal((Goal)new VisitorGoal(job, new RemoteCallWrapperAdder(job, ts, nf)){

            public Collection<Goal> prerequisiteGoals(Scheduler s) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabricScheduler.this.Parsed(this.job));
                return l;
            }
        });
        return g;
    }

    public Goal TypesInitialized(Job job) {
        FabricOptions opts = (FabricOptions)job.extensionInfo().getOptions();
        FabricTypeSystem ts = this.fabext.typeSystem();
        FabricNodeFactory nf = this.fabext.nodeFactory();
        Goal g = this.internGoal((Goal)new VisitorGoal(job, (NodeVisitor)new FabricTypeBuilder(job, (TypeSystem)ts, (NodeFactory)nf)));
        try {
            this.addPrerequisiteDependency(g, this.Parsed(job));
            this.addPrerequisiteDependency(g, this.ExplicitSuperclassesAdded(job));
            if (!opts.signatureMode()) {
                this.addPrerequisiteDependency(g, this.RemoteCallWrappersAdded(job));
            } else {
                this.addPrerequisiteDependency(g, this.Parsed(job));
            }
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError((Throwable)e);
        }
        return g;
    }

    public Goal RemoteCallWrappersUpdated(Job job) {
        FabricTypeSystem ts = this.fabext.typeSystem();
        FabricNodeFactory nf = this.fabext.nodeFactory();
        Goal g = this.internGoal((Goal)new VisitorGoal(job, new RemoteCallWrapperUpdater(job, ts, nf)){

            public Collection<Goal> prerequisiteGoals(Scheduler s) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabricScheduler.this.Disambiguated(this.job));
                return l;
            }
        });
        return g;
    }

    public Goal DisambiguationAfterWrappers(Job job) {
        TypeSystem ts = job.extensionInfo().typeSystem();
        NodeFactory nf = job.extensionInfo().nodeFactory();
        Goal g = this.internGoal((Goal)new Disambiguated(job, ts, nf){

            public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabricScheduler.this.RemoteCallWrappersUpdated(this.job));
                return l;
            }
        });
        return g;
    }

    public Goal TypeChecked(Job job) {
        FabricOptions opts = (FabricOptions)job.extensionInfo().getOptions();
        Goal g = super.TypeChecked(job);
        try {
            if (!opts.signatureMode()) {
                this.addPrerequisiteDependency(g, this.DisambiguationAfterWrappers(job));
            } else {
                this.addPrerequisiteDependency(g, this.Disambiguated(job));
            }
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError((Throwable)e);
        }
        return g;
    }

    public Goal ThisLabelChecked(Job job) {
        FabricTypeSystem ts = this.fabext.typeSystem();
        FabricNodeFactory nf = this.fabext.nodeFactory();
        Goal g = this.internGoal((Goal)new VisitorGoal(job, (NodeVisitor)new ThisLabelChecker(job, ts, nf)){

            public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(scheduler.TypeChecked(this.job));
                l.add(scheduler.ExceptionsChecked(this.job));
                return l;
            }
        });
        return g;
    }

    public Goal Serialized(Job job) {
        FabricOptions opts = (FabricOptions)job.extensionInfo().getOptions();
        Goal g = null;
        if (!opts.signatureMode()) {
            g = super.Serialized(job);
            try {
                g.addPrerequisiteGoal(this.ThisLabelChecked(job), (Scheduler)this);
            }
            catch (CyclicDependencyException e) {
                e.printStackTrace();
            }
        } else {
            g = this.internGoal((Goal)new Serialized(job){

                public Collection prerequisiteGoals(Scheduler scheduler) {
                    ArrayList<Goal> l = new ArrayList<Goal>();
                    l.add(FabricScheduler.this.ThisLabelChecked(this.job));
                    return l;
                }
            });
        }
        return g;
    }

    public Goal PrincipalCastsAdded(Job job) {
        FabricTypeSystem ts = this.fabext.typeSystem();
        FabricNodeFactory nf = this.fabext.nodeFactory();
        Goal g = this.internGoal((Goal)new VisitorGoal(job, (NodeVisitor)new PrincipalCastAdder(job, (TypeSystem)ts, (NodeFactory)nf)){

            public Collection prerequisiteGoals(Scheduler scheduler) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabricScheduler.this.Serialized(this.job));
                return l;
            }
        });
        return g;
    }

    public Goal FabricToFabilRewritten(Job job) {
        FabricTypeSystem ts = this.fabext.typeSystem();
        FabricNodeFactory nf = this.fabext.nodeFactory();
        Goal g = this.internGoal((Goal)new VisitorGoal(job, (NodeVisitor)new FabricToFabilRewriter(job, ts, nf, this.filext)));
        try {
            this.addPrerequisiteDependency(g, this.Serialized(job));
            this.addPrerequisiteDependency(g, this.PrincipalCastsAdded(job));
            if (this.objectJob != null && job != this.objectJob) {
                this.addPrerequisiteDependency(g, this.FabricToFabilRewritten(this.objectJob));
            }
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError((Throwable)e);
        }
        return g;
    }

    public Goal ExceptionsChecked(Job job) {
        TypeSystem ts = this.extInfo.typeSystem();
        NodeFactory nf = this.extInfo.nodeFactory();
        Goal g = this.internGoal((Goal)new VisitorGoal(job, (NodeVisitor)new FabricExceptionChecker(job, ts, nf)){

            public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(scheduler.TypeChecked(this.job));
                l.add(scheduler.ReachabilityChecked(this.job));
                FabricScheduler s = (FabricScheduler)scheduler;
                l.add(s.NotNullChecker(this.job));
                l.add(s.PreciseClassChecker(this.job));
                l.add(s.IntegerBoundsChecker(this.job));
                l.addAll(super.prerequisiteGoals(scheduler));
                return l;
            }
        });
        return g;
    }

    public boolean runToCompletion() {
        if (super.runToCompletion()) {
            for (Job job : this.filext.scheduler().jobs()) {
                this.filext.scheduler().addGoal(this.filext.getCompileGoal(job));
            }
            return this.filext.scheduler().runToCompletion();
        }
        return false;
    }
}

