/*
 * Decompiled with CFR 0.152.
 */
package fabil.visit;

import fabil.ast.Atomic;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import polyglot.ast.Block;
import polyglot.ast.For;
import polyglot.ast.Formal;
import polyglot.ast.Local;
import polyglot.ast.LocalAssign;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.ProcedureDecl;
import polyglot.ast.Stmt;
import polyglot.types.LocalInstance;
import polyglot.visit.NodeVisitor;

public class UpdatedVariableFinder
extends NodeVisitor {
    protected Set<LocalInstance> declared = new HashSet<LocalInstance>();
    protected Set<LocalInstance> updated = new HashSet<LocalInstance>();

    public NodeVisitor enter(Node n) {
        if (n instanceof ProcedureDecl) {
            UpdatedVariableFinder v = (UpdatedVariableFinder)((Object)this.copy());
            v.declared = new HashSet<LocalInstance>();
            v.updated = new HashSet<LocalInstance>();
            ProcedureDecl pd = (ProcedureDecl)n;
            for (Formal f : pd.formals()) {
                v.declared.add(f.localInstance());
            }
            return v;
        }
        if (n instanceof Block) {
            UpdatedVariableFinder v = (UpdatedVariableFinder)((Object)this.copy());
            v.declared = new HashSet<LocalInstance>();
            v.declared.addAll(this.declared);
            Block b = (Block)n;
            for (Stmt s : b.statements()) {
                if (!(s instanceof LocalDecl)) continue;
                LocalDecl ld = (LocalDecl)s;
                v.declared.add(ld.localInstance());
            }
            return v;
        }
        if (n instanceof For) {
            UpdatedVariableFinder v = (UpdatedVariableFinder)((Object)this.copy());
            v.declared = new HashSet<LocalInstance>();
            v.declared.addAll(this.declared);
            For f = (For)n;
            for (Stmt s : f.inits()) {
                if (!(s instanceof LocalDecl)) continue;
                LocalDecl ld = (LocalDecl)s;
                v.declared.add(ld.localInstance());
            }
            return v;
        }
        return this;
    }

    public Node leave(Node old, Node n, NodeVisitor v) {
        if (n instanceof LocalAssign) {
            Local l = (Local)((LocalAssign)n).left();
            this.updated.add(l.localInstance());
        } else if (n instanceof Atomic) {
            Atomic a = (Atomic)n;
            ArrayList<LocalInstance> updatedLocals = new ArrayList<LocalInstance>();
            for (LocalInstance li : this.updated) {
                if (!this.declared.contains(li)) continue;
                updatedLocals.add(li);
            }
            return a.updatedLocals(updatedLocals);
        }
        return n;
    }
}

