/*
 * Decompiled with CFR 0.152.
 */
package fabil.visit;

import fabil.ast.Atomic;
import fabil.extension.CallExt_c;
import fabil.extension.FieldAssignExt_c;
import fabil.extension.FieldExt_c;
import fabil.extension.UnaryExt_c;
import fabil.types.FabILTypeSystem;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.Call;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldAssign;
import polyglot.ast.Local;
import polyglot.ast.LocalAssign;
import polyglot.ast.New;
import polyglot.ast.NewArray;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.Term;
import polyglot.ast.Unary;
import polyglot.frontend.Job;
import polyglot.types.LocalInstance;
import polyglot.types.TypeSystem;
import polyglot.visit.DataFlow;
import polyglot.visit.FlowGraph;

public class ReadWriteChecker
extends DataFlow {
    private final FabILTypeSystem ts;

    public ReadWriteChecker(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf, true);
        this.ts = (FabILTypeSystem)ts;
    }

    protected DataFlow.Item createInitialItem(FlowGraph graph, Term node, boolean entry) {
        if (node instanceof ConstructorDecl) {
            return DataFlowItem.BOTTOM_C;
        }
        return DataFlowItem.BOTTOM;
    }

    protected DataFlow.Item confluence(List items, Term node, boolean entry, FlowGraph graph) {
        DataFlowItem out = null;
        for (Object o : items) {
            DataFlowItem in = (DataFlowItem)((Object)o);
            if (in == DataFlowItem.BOTTOM) {
                return in;
            }
            if (out == null) {
                out = new DataFlowItem(in);
                continue;
            }
            out.meet(in);
        }
        return out;
    }

    protected Map flow(DataFlow.Item in, FlowGraph graph, Term n, boolean entry, Set edgeKeys) {
        DataFlowItem out = (DataFlowItem)in;
        if (entry) {
            if (n instanceof Atomic) {
                out = this.atomic(out);
            }
        } else {
            Expr e;
            Unary u;
            FieldAssign a;
            if (n instanceof Field) {
                Field f = (Field)n;
                out = this.flowField(out, f, false);
            }
            if (n instanceof Call) {
                Call c = (Call)n;
                out = this.flowCall(out, c);
            }
            if (n instanceof FieldAssign) {
                a = (FieldAssign)n;
                Field f = (Field)a.left();
                out = this.flowField(out, f, true);
            }
            if (n instanceof Unary && this.isIncDec(u = (Unary)n) && (e = u.expr()) instanceof Field) {
                Field f = (Field)e;
                out = this.flowField(out, f);
            }
            if (n instanceof LocalAssign) {
                a = (LocalAssign)n;
                Local l = (Local)a.left();
                Expr e2 = a.right();
                out = e2 instanceof Local ? this.copy(out, l, (Local)e2) : (this.isThis((Node)e2) ? this.copy(out, l, null) : (this.isNew((Node)e2) ? this.alloc(out, l) : this.kill(out, l)));
            }
            if (n instanceof ConstructorCall) {
                out = DataFlowItem.BOTTOM_C;
            }
        }
        return ReadWriteChecker.itemToMap((DataFlow.Item)out, (Set)edgeKeys);
    }

    private boolean isThis(Node n) {
        if (n instanceof Special) {
            return ((Special)n).qualifier() == null;
        }
        return false;
    }

    private boolean isNew(Node n) {
        return n instanceof New || n instanceof NewArray;
    }

    private boolean isIncDec(Unary n) {
        Unary.Operator o = n.operator();
        return o == Unary.POST_DEC || o == Unary.POST_INC || o == Unary.PRE_DEC || o == Unary.PRE_INC;
    }

    private DataFlowItem flowField(DataFlowItem in, Field f, boolean write) {
        DataFlowItem out = in;
        Receiver e = f.target();
        if (!f.fieldInstance().flags().isStatic()) {
            if (e instanceof Local) {
                Local l = (Local)e;
                out = new DataFlowItem(in);
                if (write) {
                    out.write(l.localInstance());
                } else {
                    out.read(l.localInstance());
                }
            } else if (this.isThis((Node)e)) {
                out = new DataFlowItem(in);
                if (write) {
                    out.write(null);
                } else {
                    out.read(null);
                }
            }
        }
        return out;
    }

    private DataFlowItem flowField(DataFlowItem in, Field f) {
        DataFlowItem out = in;
        Receiver e = f.target();
        if (!f.fieldInstance().flags().isStatic()) {
            if (e instanceof Local) {
                Local l = (Local)e;
                out = new DataFlowItem(in);
                out.all(l.localInstance());
            } else if (this.isThis((Node)e)) {
                out = new DataFlowItem(in);
                out.all(null);
            }
        }
        return out;
    }

    private DataFlowItem flowCall(DataFlowItem in, Call c) {
        DataFlowItem out = in;
        Receiver e = c.target();
        if (!c.methodInstance().flags().isStatic() && e instanceof Local) {
            Local l = (Local)e;
            out = new DataFlowItem(in);
            out.reside(l.localInstance());
        }
        return out;
    }

    private DataFlowItem kill(DataFlowItem in, Local l) {
        DataFlowItem out = new DataFlowItem(in);
        out.kill(l.localInstance());
        return out;
    }

    private DataFlowItem copy(DataFlowItem in, Local to, Local from) {
        DataFlowItem out = new DataFlowItem(in);
        out.copy(to.localInstance(), from == null ? null : from.localInstance(), in);
        return out;
    }

    private DataFlowItem alloc(DataFlowItem in, Local l) {
        DataFlowItem out = new DataFlowItem(in);
        LocalInstance li = l.localInstance();
        out.alloc(li);
        return out;
    }

    private DataFlowItem atomic(DataFlowItem in) {
        DataFlowItem out = new DataFlowItem(in);
        out.atomic();
        return out;
    }

    protected void check(FlowGraph graph, Term n, boolean entry, DataFlow.Item inItem, Map outItems) {
        DataFlowItem in = (DataFlowItem)inItem;
        if (!entry) {
            Field f;
            Receiver r;
            Unary u;
            Call c;
            FieldAssign a;
            Field f2;
            Receiver e;
            Local l;
            Field f3;
            Receiver e2;
            if (n instanceof Field && this.ts.isPureFabricType((e2 = (f3 = (Field)n).target()).type()) && !f3.fieldInstance().flags().isStatic()) {
                if (e2 instanceof Local) {
                    l = (Local)e2;
                    ((FieldExt_c)f3.ext()).accessState(in.state(l.localInstance()));
                } else if (this.isThis((Node)e2)) {
                    ((FieldExt_c)f3.ext()).accessState(in.state(null));
                }
            }
            if (n instanceof FieldAssign && this.ts.isPureFabricType((e = (f2 = (Field)(a = (FieldAssign)n).left()).target()).type()) && !f2.fieldInstance().flags().isStatic()) {
                if (e instanceof Local) {
                    Local l2 = (Local)e;
                    ((FieldAssignExt_c)a.ext()).accessState(in.state(l2.localInstance()));
                } else if (this.isThis((Node)e)) {
                    ((FieldAssignExt_c)a.ext()).accessState(in.state(null));
                }
            }
            if (n instanceof Call && this.ts.isPureFabricType((e2 = (c = (Call)n).target()).type()) && !c.methodInstance().flags().isStatic() && e2 instanceof Local) {
                l = (Local)e2;
                ((CallExt_c)c.ext()).accessState(in.state(l.localInstance()));
            }
            if (n instanceof Unary && this.isIncDec(u = (Unary)n) && (e2 = u.expr()) instanceof Field && this.ts.isPureFabricType((r = (f = (Field)e2).target()).type()) && !f.fieldInstance().flags().isStatic()) {
                if (r instanceof Local) {
                    Local l3 = (Local)r;
                    ((UnaryExt_c)u.ext()).accessState(in.state(l3.localInstance()));
                } else if (this.isThis((Node)r)) {
                    ((UnaryExt_c)u.ext()).accessState(in.state(null));
                }
            }
        }
    }

    protected static class DataFlowItem
    extends DataFlow.Item {
        public static final DataFlowItem BOTTOM = new DataFlowItem();
        public static final DataFlowItem BOTTOM_C = new DataFlowItem(true);
        private final Set<LocalInstance> resident;
        public final Set<LocalInstance> read;
        public final Set<LocalInstance> written;

        private DataFlowItem() {
            this.resident = Collections.singleton(null);
            this.read = Collections.emptySet();
            this.written = Collections.emptySet();
        }

        private DataFlowItem(boolean ctor) {
            this.resident = Collections.singleton(null);
            this.read = Collections.singleton(null);
            this.written = Collections.singleton(null);
        }

        public DataFlowItem(DataFlowItem i) {
            this.resident = new HashSet<LocalInstance>(i.resident);
            this.read = new HashSet<LocalInstance>(i.read);
            this.written = new HashSet<LocalInstance>(i.written);
        }

        public DataFlowItem meet(DataFlowItem i) {
            this.resident.retainAll(i.resident);
            this.read.retainAll(i.read);
            this.written.retainAll(i.written);
            return this;
        }

        public DataFlowItem reside(LocalInstance l) {
            this.resident.add(l);
            return this;
        }

        public DataFlowItem read(LocalInstance l) {
            this.resident.add(l);
            this.read.add(l);
            return this;
        }

        public DataFlowItem write(LocalInstance l) {
            this.resident.add(l);
            this.written.add(l);
            return this;
        }

        public DataFlowItem alloc(LocalInstance l) {
            this.kill(l);
            this.read.add(l);
            this.written.add(l);
            return this;
        }

        public DataFlowItem all(LocalInstance l) {
            this.resident.add(l);
            this.read.add(l);
            this.written.add(l);
            return this;
        }

        public DataFlowItem copy(LocalInstance to, LocalInstance from, DataFlowItem in) {
            this.kill(to);
            if (in.read.contains(from)) {
                this.read.add(to);
            }
            if (in.written.contains(from)) {
                this.written.add(to);
            }
            return this;
        }

        public DataFlowItem kill(LocalInstance l) {
            this.resident.remove(l);
            this.read.remove(l);
            this.written.remove(l);
            return this;
        }

        public DataFlowItem atomic() {
            this.written.clear();
            return this;
        }

        public State state(LocalInstance l) {
            return new State(this.resident.contains(l), this.read.contains(l), this.written.contains(l));
        }

        public boolean equals(Object i) {
            if (i instanceof DataFlowItem) {
                DataFlowItem o = (DataFlowItem)((Object)i);
                return ((Object)this.resident).equals(o.resident) && ((Object)this.read).equals(o.read) && ((Object)this.written).equals(o.written);
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.resident).hashCode() ^ ((Object)this.read).hashCode() ^ ((Object)this.written).hashCode();
        }
    }

    public static class State {
        private final boolean resident;
        private final boolean read;
        private final boolean written;

        public State(boolean resident, boolean read, boolean written) {
            this.resident = resident;
            this.read = read;
            this.written = written;
        }

        public boolean resident() {
            return this.resident;
        }

        public boolean read() {
            return this.read;
        }

        public boolean written() {
            return this.written;
        }

        public boolean all() {
            return this.read && this.written;
        }
    }
}

