/*
 * Decompiled with CFR 0.152.
 */
package fabil.visit;

import fabil.ExtensionInfo;
import fabil.ast.FabILNodeFactory;
import fabil.extension.FabILExt;
import fabil.types.FabILTypeSystem;
import fabil.visit.ReadWriteChecker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import polyglot.ast.Block;
import polyglot.ast.CodeDecl;
import polyglot.ast.ConstructorCall;
import polyglot.ast.Local;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.Stmt;
import polyglot.qq.QQ;
import polyglot.types.ArrayType;
import polyglot.types.ClassType;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.Type;
import polyglot.visit.NodeVisitor;

public class ProxyRewriter
extends NodeVisitor {
    protected QQ qq;
    protected FabILNodeFactory nf;
    protected FabILTypeSystem ts;
    private final Stack<Map<LocalInstance, String>> shadowStack = new Stack();
    private boolean inConstructorCall;

    public ProxyRewriter(ExtensionInfo extInfo) {
        this.qq = new QQ((polyglot.frontend.ExtensionInfo)extInfo);
        this.nf = extInfo.nodeFactory();
        this.ts = extInfo.typeSystem();
    }

    public NodeVisitor enter(Node parent, Node n) {
        if (n instanceof CodeDecl) {
            this.shadowStack.push(new HashMap());
        }
        if (n instanceof ConstructorCall) {
            this.inConstructorCall = true;
        }
        return super.enter(parent, n);
    }

    public Node override(Node n) {
        return this.ext(n).rewriteProxiesOverride(this);
    }

    public Node leave(Node old, Node n, NodeVisitor v) {
        if ((n = this.ext(n).rewriteProxies(this)) instanceof CodeDecl) {
            n = this.produceShadowDecls((CodeDecl)n);
            this.shadowStack.pop();
        }
        if (n instanceof ConstructorCall) {
            this.inConstructorCall = false;
        }
        return n;
    }

    private FabILExt ext(Node n) {
        return (FabILExt)n.ext();
    }

    public QQ qq() {
        return this.qq;
    }

    public FabILNodeFactory nodeFactory() {
        return this.nf;
    }

    public FabILTypeSystem typeSystem() {
        return this.ts;
    }

    public static Flags toPublic(Flags flags) {
        return flags.clearPrivate().clearProtected().Public();
    }

    public static Flags toPrivate(Flags flags) {
        return flags.clearPublic().clearProtected().Private();
    }

    public static Flags toFinal(Flags flags) {
        return flags.clearAbstract().clearInterface().Final();
    }

    public static Flags toInterface(Flags flags) {
        return flags.clearAbstract().clearFinal().clearPrivate().Interface();
    }

    public String getShadow(LocalInstance l) {
        if (l == null) {
            throw new NullPointerException();
        }
        Map<LocalInstance, String> shadows = this.shadowStack.peek();
        String s = shadows.get(l);
        if (s == null) {
            s = l.name() + "$impl$" + shadows.size();
            shadows.put(l, s);
        }
        return s;
    }

    public Receiver replaceTarget(Receiver target, ReadWriteChecker.State accessState) {
        if (this.inConstructorCall) {
            return target;
        }
        String t = this.toImplType(target.type());
        Receiver shadow = target;
        if (target instanceof Local) {
            Local l = (Local)target;
            shadow = this.qq.parseExpr(this.getShadow(l.localInstance()));
        }
        target = !accessState.resident() ? this.qq.parseExpr("(%E = (" + t + ") %E.fetch())", (Object)shadow, target) : shadow;
        return target;
    }

    private CodeDecl produceShadowDecls(CodeDecl n) {
        int i;
        Map<LocalInstance, String> shadows = this.shadowStack.peek();
        if (shadows == null || shadows.size() == 0) {
            return n;
        }
        Block b = n.body();
        ArrayList<Stmt> l = new ArrayList<Stmt>(b.statements());
        for (i = 0; i < l.size() && l.get(i) instanceof ConstructorCall; ++i) {
        }
        l.addAll(i, this.shadowDecls());
        b = b.statements(l);
        n = (CodeDecl)n.body(b);
        return n;
    }

    private List<Stmt> shadowDecls() {
        Map<LocalInstance, String> shadows = this.shadowStack.peek();
        ArrayList<Stmt> l = new ArrayList<Stmt>(shadows.size());
        for (Map.Entry<LocalInstance, String> e : shadows.entrySet()) {
            LocalInstance li = e.getKey();
            String name = e.getValue();
            String t = this.toImplType(li.type());
            l.add(this.qq.parseStmt(t + " " + name + ";"));
        }
        return l;
    }

    private String toImplType(Type t) {
        if (t instanceof ArrayType) {
            ArrayType a = (ArrayType)t;
            return this.ts.fabricRuntimeArrayImplOf(a.base()).fullName();
        }
        ClassType c = (ClassType)t;
        if (c.flags().isInterface() || this.ts.WrappedJavaInlineable().isImplicitCastValid((Type)c)) {
            return c.fullName();
        }
        return c.fullName() + "._Impl";
    }
}

