/*
 * Decompiled with CFR 0.152.
 */
package fabil.visit;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.Assign;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.Expr;
import polyglot.ast.FieldAssign;
import polyglot.ast.FieldDecl;
import polyglot.ast.Id;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ast.Return;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.Flags;
import polyglot.types.MethodInstance;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.NodeVisitor;

public class Memoizer
extends NodeVisitor {
    protected Job job;
    protected NodeFactory nf;
    protected TypeSystem ts;
    protected List<ClassMember> addedMembers = null;
    protected String flagName = null;
    protected String valueName = null;
    private static int freshTid = 0;

    public Memoizer(Job job, TypeSystem ts, NodeFactory nf) {
        this.job = job;
        this.ts = ts;
        this.nf = nf;
    }

    public NodeVisitor enter(Node n) {
        MethodDecl md;
        MethodInstance mi;
        if (n instanceof ClassDecl) {
            ClassDecl cd = (ClassDecl)n;
            if (cd.name().equals("_Impl")) {
                Memoizer v = (Memoizer)((Object)this.copy());
                v.addedMembers = new ArrayList<ClassMember>();
                return v;
            }
        } else if (n instanceof MethodDecl && this.needsMemoization(mi = (md = (MethodDecl)n).methodInstance())) {
            Memoizer v = (Memoizer)((Object)this.copy());
            v.flagName = "$memFlag" + freshTid++;
            v.valueName = "$memValue" + freshTid++;
            return v;
        }
        return this;
    }

    public Node leave(Node old, Node n, NodeVisitor v) {
        Return ret;
        Memoizer mv = (Memoizer)v;
        if (n instanceof ClassDecl) {
            ClassDecl cd = (ClassDecl)n;
            if (mv.addedMembers != null && !mv.addedMembers.isEmpty()) {
                ArrayList<ClassMember> members = new ArrayList<ClassMember>();
                members.addAll(cd.body().members());
                members.addAll(mv.addedMembers);
                return cd.body(cd.body().members(members));
            }
        } else if (n instanceof MethodDecl) {
            MethodDecl md = (MethodDecl)n;
            MethodInstance mi = md.methodInstance();
            if (this.needsMemoization(mi)) {
                return mv.transform(md, mi);
            }
        } else if (n instanceof Return && (ret = (Return)n).expr() != null && this.valueName != null) {
            FieldAssign e = this.nf.FieldAssign(Position.compilerGenerated(), this.nf.Field(Position.compilerGenerated(), (Receiver)this.nf.This(Position.compilerGenerated()), this.nf.Id(Position.compilerGenerated(), this.valueName)), Assign.ASSIGN, ret.expr());
            return ret.expr((Expr)e);
        }
        return n;
    }

    protected MethodDecl transform(MethodDecl md, MethodInstance mi) {
        Id flagId = this.nf.Id(Position.compilerGenerated(), this.flagName);
        Id valueId = this.nf.Id(Position.compilerGenerated(), this.valueName);
        FieldDecl flagDecl = this.nf.FieldDecl(Position.compilerGenerated(), Flags.PRIVATE.Transient(), (TypeNode)this.nf.CanonicalTypeNode(Position.compilerGenerated(), (Type)this.ts.Boolean()), flagId, (Expr)this.nf.BooleanLit(Position.compilerGenerated(), false));
        this.addedMembers.add((ClassMember)flagDecl);
        FieldDecl valueDecl = this.nf.FieldDecl(Position.compilerGenerated(), Flags.PRIVATE.Transient(), (TypeNode)this.nf.CanonicalTypeNode(Position.compilerGenerated(), mi.returnType()), valueId);
        this.addedMembers.add((ClassMember)valueDecl);
        ArrayList<Object> stmts = new ArrayList<Object>();
        stmts.add(this.nf.If(Position.compilerGenerated(), (Expr)this.nf.Field(Position.compilerGenerated(), (Receiver)this.nf.This(Position.compilerGenerated()), flagId), (Stmt)this.nf.Return(Position.compilerGenerated(), (Expr)this.nf.Field(Position.compilerGenerated(), (Receiver)this.nf.This(Position.compilerGenerated()), valueId))));
        stmts.add(this.nf.Eval(Position.compilerGenerated(), (Expr)this.nf.FieldAssign(Position.compilerGenerated(), this.nf.Field(Position.compilerGenerated(), (Receiver)this.nf.This(Position.compilerGenerated()), flagId), Assign.ASSIGN, (Expr)this.nf.BooleanLit(Position.compilerGenerated(), true))));
        stmts.addAll(md.body().statements());
        return (MethodDecl)md.body(this.nf.Block(md.body().position(), stmts));
    }

    protected boolean needsMemoization(MethodInstance mi) {
        if (this.addedMembers == null || mi == null) {
            return false;
        }
        ClassType ct = (ClassType)mi.container();
        return mi.name().equals("hashCode") && mi.formalTypes().isEmpty() && ct.fullName().equals("fabric.lang.security.PairLabel");
    }
}

