/*
 * Decompiled with CFR 0.152.
 */
package fabil.visit;

import fabil.ast.FabILNodeFactory;
import fabil.types.FabILTypeSystem;
import fabil.types.FabricArrayType;
import java.util.Collections;
import polyglot.ast.ArrayAccess;
import polyglot.ast.Assign;
import polyglot.ast.Call;
import polyglot.ast.Cast;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ast.TypeNode;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.Flags;
import polyglot.types.MethodInstance;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.NodeVisitor;

public class InlineableWrapper
extends AscriptionVisitor {
    protected FabILNodeFactory nf;
    protected FabILTypeSystem ts;

    public InlineableWrapper(Job job, FabILTypeSystem ts, FabILNodeFactory nf) {
        super(job, (TypeSystem)ts, (NodeFactory)nf);
        this.nf = nf;
        this.ts = ts;
    }

    protected Node leaveCall(Node parent, Node old, Node n, NodeVisitor v) throws SemanticException {
        if (parent instanceof Assign && ((Assign)parent).left() == old) {
            return n;
        }
        if (parent instanceof ArrayAccess && ((ArrayAccess)parent).array() == old) {
            return n;
        }
        return super.leaveCall(parent, old, n, v);
    }

    public Expr ascribe(Expr e, Type toType) {
        boolean isFabricArrayAccess;
        Position CG = Position.compilerGenerated();
        Type fromType = e.type();
        if (!fromType.isReference() || !toType.isReference()) {
            return e;
        }
        boolean toInlineable = false;
        boolean toFabric = false;
        boolean toJava = false;
        boolean fromInlineable = false;
        boolean fromFabric = false;
        boolean fromJava = false;
        if (this.ts.isJavaInlineable(toType)) {
            toInlineable = true;
        } else if (this.ts.isFabricReference(toType)) {
            toFabric = true;
        } else {
            toJava = true;
        }
        boolean bl = isFabricArrayAccess = e instanceof ArrayAccess && ((ArrayAccess)e).array().type() instanceof FabricArrayType;
        if (this.ts.isJavaInlineable(fromType) && !isFabricArrayAccess) {
            fromInlineable = true;
        } else if (this.ts.isFabricReference(fromType)) {
            fromFabric = true;
        } else {
            fromJava = true;
        }
        if (toInlineable == fromInlineable && toFabric == fromFabric && toJava == fromJava) {
            return e;
        }
        if (fromInlineable && toJava || fromJava && toInlineable) {
            return e;
        }
        ClassType wrappedJavaInlineable = this.ts.WrappedJavaInlineable();
        if (toFabric) {
            Call call = this.nf.Call(CG, (Receiver)this.nf.CanonicalTypeNode(CG, (Type)wrappedJavaInlineable), this.nf.Id(CG, "$wrap"), e);
            call = (Call)call.type((Type)wrappedJavaInlineable);
            MethodInstance mi = this.ts.methodInstance(CG, (ReferenceType)wrappedJavaInlineable, Flags.PUBLIC.set(Flags.STATIC).set(Flags.FINAL), (Type)wrappedJavaInlineable, "$wrap", Collections.singletonList(this.ts.Object()), Collections.emptyList());
            call = (Call)call.type(toType);
            return call.methodInstance(mi);
        }
        Call call = this.nf.Call(CG, (Receiver)this.nf.CanonicalTypeNode(CG, (Type)wrappedJavaInlineable), this.nf.Id(CG, "$unwrap"), e);
        call = (Call)call.type((Type)this.ts.Object());
        MethodInstance mi = this.ts.methodInstance(CG, (ReferenceType)wrappedJavaInlineable, Flags.PUBLIC.set(Flags.STATIC).set(Flags.FINAL), (Type)this.ts.Object(), "$unwrap", Collections.singletonList(this.ts.FObject()), Collections.emptyList());
        Cast result = this.nf.Cast(CG, (TypeNode)this.nf.CanonicalTypeNode(CG, toType), (Expr)call.methodInstance(mi));
        result = (Cast)result.type(toType);
        return result;
    }
}

