/*
 * Decompiled with CFR 0.152.
 */
package fabil.visit;

import fabil.FabILOptions;
import fabil.types.FabILTypeSystem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import polyglot.ast.Node;
import polyglot.ast.SourceCollection;
import polyglot.ast.SourceFile;
import polyglot.ast.Typed;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.visit.NodeVisitor;

public class ClassReferencesCollector
extends NodeVisitor {
    private static final String[] GENERATED_CLASSES = new String[]{"", "$_Proxy", "$_Impl", "$_Static", "$_Static$_Proxy", "$_Static$_Impl"};
    private static final String[] ALWAYS_REQUIRED_CLASSES = new String[]{"fabric.net.UnreachableNodeException", "java.lang.Cloneable", "java.lang.Object"};
    private static final String PROPERTIES_EXTENSION = ".fabproperties";
    private FabILTypeSystem ts;
    private Job job;
    private Set<String> classes;
    private Map<String, Set<String>> nestedClasses;

    public ClassReferencesCollector(Job job, TypeSystem ts) {
        this.job = job;
        this.ts = (FabILTypeSystem)ts;
        this.classes = new HashSet<String>(Arrays.asList(ALWAYS_REQUIRED_CLASSES));
        this.nestedClasses = new HashMap<String, Set<String>>();
    }

    public void finish() {
        FabILOptions opts = (FabILOptions)this.job.extensionInfo().getOptions();
        if (opts.dumpDependencies()) {
            this.writeDependencies();
        }
    }

    private void writeDependencies() {
        Node ast = this.job.ast();
        if (ast instanceof SourceFile) {
            SourceFile sfn = (SourceFile)ast;
            this.writeDependencies(sfn);
        } else if (ast instanceof SourceCollection) {
            SourceCollection sc = (SourceCollection)ast;
            List sources = sc.sources();
            for (SourceFile sfn : sources) {
                this.writeDependencies(sfn);
            }
        } else {
            throw new InternalCompilerError("AST root must be a SourceFile; found a " + ast.getClass().getName());
        }
    }

    private void writeDependencies(SourceFile sfn) {
        String pkg = null;
        if (sfn.package_() != null) {
            pkg = sfn.package_().package_().fullName();
        }
        File of = this.job.extensionInfo().targetFactory().outputFile(pkg, sfn.source());
        String tlClass = of.getName();
        tlClass = tlClass.substring(0, tlClass.length() - 5);
        if (pkg != null) {
            tlClass = pkg + "." + tlClass;
        }
        Set<String> nested = this.nestedClasses.get(tlClass);
        String basePath = of.getAbsolutePath();
        basePath = basePath.substring(0, basePath.length() - 5);
        for (String classSuffix : GENERATED_CLASSES) {
            StringBuilder path = new StringBuilder();
            path.append(basePath).append(classSuffix).append(".class").append(PROPERTIES_EXTENSION);
            this.writeDependencies(new File(path.toString()));
        }
        if (nested != null) {
            for (String nestedClass : nested) {
                StringBuilder path = new StringBuilder();
                if (of.getParent() != null) {
                    path.append(of.getParent()).append(File.separatorChar);
                }
                path.append(nestedClass).append(".class").append(PROPERTIES_EXTENSION);
                this.writeDependencies(new File(path.toString()));
            }
        }
    }

    private void writeDependencies(File f) {
        StringBuilder deps = new StringBuilder();
        for (String cls : this.classes) {
            deps.append(cls).append(",");
        }
        String result = deps.substring(0, deps.length() - 1);
        Properties p = new Properties();
        p.setProperty("dependencies", result);
        try {
            f.getParentFile().mkdirs();
            FileOutputStream fs = new FileOutputStream(f);
            p.store(fs, null);
            fs.close();
        }
        catch (IOException e) {
            this.job.compiler().errorQueue().enqueue(2, "I/O error while writing dependencies: " + e.getMessage());
        }
    }

    public Node leave(Node old, Node n, NodeVisitor v) {
        if (!(n instanceof Typed)) {
            return n;
        }
        Typed typeNode = (Typed)n;
        Type type = typeNode.type();
        if (type != null && type.isClass()) {
            ClassType ct = (ClassType)type;
            String typeName = type.toString();
            Set<String> nested = null;
            if (ct.isNested()) {
                typeName = ct.name();
                while (ct.outer() != null) {
                    ct = ct.outer();
                    typeName = ct.name() + "$" + typeName;
                }
                nested = this.nestedClasses.get(ct.fullName());
                if (nested == null) {
                    nested = new HashSet<String>();
                    this.nestedClasses.put(ct.fullName(), nested);
                }
            }
            if (type.descendsFrom((Type)this.ts.FObject()) || type.equals(this.ts.FObject())) {
                for (String classSuffix : GENERATED_CLASSES) {
                    this.classes.add(typeName + classSuffix);
                    if (nested == null) continue;
                    nested.add(typeName + classSuffix);
                }
            } else {
                this.classes.add(typeName);
                if (nested != null) {
                    nested.add(typeName);
                }
            }
        }
        return n;
    }
}

