/*
 * Decompiled with CFR 0.152.
 */
package fabil.visit;

import fabil.ast.AbortStmt;
import fabil.ast.Atomic;
import fabil.ast.RetryStmt;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.frontend.Job;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.visit.ErrorHandlingVisitor;
import polyglot.visit.NodeVisitor;

public class AbortRetryChecker
extends ErrorHandlingVisitor {
    protected boolean inAtomic = false;
    protected boolean hasAbort = false;

    public AbortRetryChecker(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    protected NodeVisitor enterCall(Node n) {
        if (n instanceof Atomic) {
            AbortRetryChecker v = (AbortRetryChecker)((Object)this.copy());
            v.inAtomic = true;
            return v;
        }
        return this;
    }

    protected Node leaveCall(Node n) throws SemanticException {
        if (n instanceof AbortStmt) {
            if (!this.inAtomic) {
                throw new SemanticException("Abort is not statically enclosed in an atomic block.", n.position());
            }
            this.hasAbort = true;
        } else if (n instanceof RetryStmt) {
            if (!this.inAtomic) {
                throw new SemanticException("Retry is not statically enclosed in an atomic block.", n.position());
            }
        } else if (n instanceof Atomic) {
            Atomic atomic = (Atomic)n;
            if (this.hasAbort) {
                return atomic.mayAbort(true);
            }
            this.hasAbort = false;
        }
        return n;
    }
}

