/*
 * Decompiled with CFR 0.152.
 */
package fabil.types;

import fabil.types.FabILFlags;
import fabil.types.FabILImportTable;
import fabil.types.FabILParsedClassType_c;
import fabil.types.FabILTypeSystem;
import fabil.types.FabricArrayType;
import fabil.types.FabricArrayType_c;
import fabil.types.JavaArrayType_c;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import polyglot.ast.TypeNode;
import polyglot.frontend.Source;
import polyglot.types.ArrayType;
import polyglot.types.CachingResolver;
import polyglot.types.ClassType;
import polyglot.types.DeserializedClassInitializer;
import polyglot.types.Flags;
import polyglot.types.ImportTable;
import polyglot.types.LazyClassInitializer;
import polyglot.types.LazyInitializer;
import polyglot.types.LoadedClassResolver;
import polyglot.types.MethodInstance;
import polyglot.types.Package;
import polyglot.types.ParsedClassType;
import polyglot.types.ReferenceType;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem_c;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class FabILTypeSystem_c
extends TypeSystem_c
implements FabILTypeSystem {
    private CachingResolver runtimeClassResolver;
    private Map<Type, FabricArrayType> fabricArrayTypeCache = new HashMap<Type, FabricArrayType>();

    @Override
    public ClassType TransactionManager() {
        return this.load("fabric.worker.transaction.TransactionManager");
    }

    @Override
    public ClassType FObject() {
        return this.load("fabric.lang.Object");
    }

    @Override
    public ClassType JavaInlineable() {
        return this.load("fabric.lang.JavaInlineable");
    }

    @Override
    public ClassType WrappedJavaInlineable() {
        return this.load("fabric.lang.WrappedJavaInlineable");
    }

    @Override
    public ClassType AbortException() {
        return this.load("fabric.worker.AbortException");
    }

    @Override
    public ClassType FabricThread() {
        return this.load("fabric.common.FabricThread");
    }

    @Override
    public ClassType Thread() {
        return this.load("java.lang.Thread");
    }

    @Override
    public ClassType RemoteWorker() {
        return this.load("fabric.worker.remote.RemoteWorker");
    }

    @Override
    public ClassType RemoteCallException() {
        return this.load("fabric.worker.remote.RemoteCallException");
    }

    @Override
    public ClassType Worker() {
        return this.load("fabric.worker.Worker");
    }

    @Override
    public ClassType Principal() {
        return this.load("fabric.lang.security.Principal");
    }

    @Override
    public ClassType DelegatingPrincipal() {
        return this.load("fabric.lang.security.DelegatingPrincipal");
    }

    @Override
    public Type Store() {
        return this.load("fabric.worker.Store");
    }

    @Override
    public Type Label() {
        return this.load("fabric.lang.security.Label");
    }

    @Override
    public ClassType InternalError() {
        return this.load("java.lang.InternalError");
    }

    public ParsedClassType createClassType(LazyClassInitializer init, Source fromSource) {
        return new FabILParsedClassType_c(this, init, fromSource);
    }

    public List defaultPackageImports() {
        ArrayList<String> result = new ArrayList<String>(6);
        result.add("fabric.lang");
        result.add("fabric.lang.security");
        result.add("fabric.worker");
        result.add("fabric.worker.remote");
        result.addAll(super.defaultPackageImports());
        return result;
    }

    protected List<MethodInstance> findAcceptableMethods(ReferenceType container, String name, List argTypes, ClassType currClass) throws SemanticException {
        List result = super.findAcceptableMethods(container, name, argTypes, currClass);
        if (this.isJavaInlineable((Type)container)) {
            for (MethodInstance mi : this.FObject().methods()) {
                result.remove(mi);
            }
        }
        return result;
    }

    @Override
    public ClassType fabricRuntimeArrayOf(Type type) {
        if (type.isReference()) {
            return this.loadRuntime("fabric.lang.arrays.ObjectArray");
        }
        return this.loadRuntime("fabric.lang.arrays." + type.toString() + "Array");
    }

    @Override
    public ClassType fabricRuntimeArrayImplOf(Type type) {
        if (type.isReference()) {
            return this.loadRuntime("fabric.lang.arrays.ObjectArray._Impl");
        }
        return this.loadRuntime("fabric.lang.arrays." + type.toString() + "Array._Impl");
    }

    @Override
    public ClassType toFabricRuntimeArray(ArrayType type) {
        return this.fabricRuntimeArrayOf(type.base());
    }

    @Override
    public FabricArrayType fabricArrayOf(Type type, int dims) {
        return this.fabricArrayOf(type.position(), type, dims);
    }

    public FabricArrayType fabricArrayOf(Position pos, Type type, int dims) {
        if (dims > 1) {
            return this.fabricArrayOf(pos, (Type)this.fabricArrayOf(pos, type, dims - 1));
        }
        if (dims == 1) {
            return this.fabricArrayOf(pos, type);
        }
        throw new InternalCompilerError("Must call fabricArrayOf(type, dims) with dims > 0");
    }

    @Override
    public FabricArrayType fabricArrayOf(Type type) {
        return this.fabricArrayOf(type.position(), type);
    }

    @Override
    public FabricArrayType fabricArrayOf(Position pos, Type type) {
        this.assert_((TypeObject)type);
        return this.fabricArrayType(pos, type);
    }

    protected FabricArrayType fabricArrayType(Position pos, Type type) {
        FabricArrayType t = this.fabricArrayTypeCache.get(type);
        if (t == null) {
            t = this.createFabricArrayType(pos, type);
            this.fabricArrayTypeCache.put(type, t);
        }
        return t;
    }

    protected FabricArrayType createFabricArrayType(Position pos, Type type) {
        return new FabricArrayType_c(this, pos, type);
    }

    protected ArrayType createArrayType(Position pos, Type type) {
        return new JavaArrayType_c(this, pos, type);
    }

    public ImportTable importTable(Package pkg) {
        return new FabILImportTable(this, pkg);
    }

    public ImportTable importTable(String sourceName, Package pkg) {
        return new FabILImportTable(this, pkg, sourceName);
    }

    public Flags legalMethodFlags() {
        return super.legalMethodFlags().set(FabILFlags.ATOMIC);
    }

    public Flags legalConstructorFlags() {
        return super.legalConstructorFlags();
    }

    @Override
    public boolean isFabricType(Type type) {
        if (type.isPrimitive()) {
            return true;
        }
        return this.isFabricReference(type);
    }

    @Override
    public boolean isFabricType(TypeNode type) {
        return this.isFabricType(type.type());
    }

    @Override
    public boolean isThread(Type type) {
        return this.isSubtype(type, (Type)this.Thread());
    }

    @Override
    public boolean isThread(TypeNode type) {
        return this.isThread(type.type());
    }

    @Override
    public boolean isPureFabricType(Type type) {
        return this.isFabricType(type) && !this.isJavaInlineable(type);
    }

    @Override
    public boolean isPureFabricType(TypeNode type) {
        return this.isPureFabricType(type.type());
    }

    @Override
    public boolean isFabricReference(Type type) {
        return this.isFabricArray(type) || this.isFabricClass(type);
    }

    @Override
    public boolean isFabricReference(TypeNode type) {
        return this.isFabricReference(type.type());
    }

    @Override
    public boolean isFabricClass(ClassType type) {
        if (type.flags().contains(FabILFlags.NONFABRIC)) {
            return false;
        }
        if (!type.flags().isInterface()) {
            while (type != null) {
                if (this.typeEquals((Type)type, (Type)this.FObject())) {
                    return true;
                }
                type = (ClassType)type.superType();
            }
            return false;
        }
        return this.isSubtype((Type)type, (Type)this.FObject());
    }

    @Override
    public boolean isFabricClass(Type type) {
        return type.isClass() && this.isFabricClass(type.toClass());
    }

    @Override
    public boolean isFabricClass(TypeNode type) {
        return this.isFabricClass(type.type());
    }

    @Override
    public boolean isPrincipalClass(ClassType type) {
        return this.isSubtype((Type)type, (Type)this.Principal());
    }

    @Override
    public boolean isPrincipalClass(Type type) {
        return type.isClass() && this.isPrincipalClass(type.toClass());
    }

    @Override
    public boolean isPrincipalClass(TypeNode type) {
        return this.isPrincipalClass(type.type());
    }

    @Override
    public boolean isFabricArray(ArrayType type) {
        return type instanceof FabricArrayType;
    }

    @Override
    public boolean isFabricArray(Type type) {
        return type.isArray() && this.isFabricArray(type.toArray());
    }

    @Override
    public boolean isFabricArray(TypeNode type) {
        return this.isFabricArray(type.type());
    }

    @Override
    public boolean isJavaInlineable(Type type) {
        return this.isSubtype(type, (Type)this.JavaInlineable());
    }

    @Override
    public boolean isJavaInlineable(TypeNode type) {
        return this.isJavaInlineable(type.type());
    }

    @Override
    public boolean isCompiledByFabc(ClassType ct) {
        if (ct instanceof ParsedClassType) {
            ParsedClassType pct = (ParsedClassType)ct;
            if (pct.job() != null) {
                return true;
            }
            LazyInitializer init = pct.initializer();
            return init instanceof DeserializedClassInitializer;
        }
        return false;
    }

    @Override
    public void setRuntimeClassResolver(LoadedClassResolver lcr) {
        this.runtimeClassResolver = new CachingResolver((Resolver)lcr);
    }

    private ClassType loadRuntime(String name) {
        try {
            return (ClassType)this.forName((Resolver)this.runtimeClassResolver, name);
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Cannot find runtime class \"" + name + "\"; " + e.getMessage(), (Throwable)e);
        }
    }

    public Flags legalTopLevelClassFlags() {
        Flags f = super.legalTopLevelClassFlags();
        f = f.set(FabILFlags.NONFABRIC);
        return f;
    }

    public Flags legalInterfaceFlags() {
        Flags f = super.legalInterfaceFlags();
        f = f.set(FabILFlags.NONFABRIC);
        return f;
    }

    public String translateClass(Resolver c, ClassType t) {
        if (t.package_() != null && t.package_().equals(this.createPackage("fabric.lang.security"))) {
            return super.translateClass(null, t);
        }
        return super.translateClass(c, t);
    }
}

