/*
 * Decompiled with CFR 0.152.
 */
package fabil.frontend;

import fabil.ExtensionInfo;
import fabil.FabILOptions;
import fabil.ast.FabILNodeFactory;
import fabil.types.FabILTypeSystem;
import fabil.visit.AbortRetryChecker;
import fabil.visit.ArrayInitializerTypeFixer;
import fabil.visit.AtomicMethodRewriter;
import fabil.visit.AtomicRewriter;
import fabil.visit.ClassReferencesCollector;
import fabil.visit.ClassSerializer;
import fabil.visit.FabILTypeBuilder;
import fabil.visit.InlineableWrapper;
import fabil.visit.LabelAssigner;
import fabil.visit.LocationAssigner;
import fabil.visit.Memoizer;
import fabil.visit.PrincipalDelegator;
import fabil.visit.ProxyRewriter;
import fabil.visit.ReadWriteChecker;
import fabil.visit.RemoteCallRewriter;
import fabil.visit.SignatureCleaner;
import fabil.visit.StaticInitializerCollector;
import fabil.visit.StoreGetterRewriter;
import fabil.visit.ThreadRewriter;
import fabil.visit.UpdatedVariableFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import polyglot.ast.NodeFactory;
import polyglot.ast.TypeNode;
import polyglot.frontend.CyclicDependencyException;
import polyglot.frontend.JLScheduler;
import polyglot.frontend.Job;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.CodeGenerated;
import polyglot.frontend.goals.Goal;
import polyglot.frontend.goals.Serialized;
import polyglot.frontend.goals.TypeChecked;
import polyglot.frontend.goals.VisitorGoal;
import polyglot.main.Version;
import polyglot.types.TypeSystem;
import polyglot.util.ErrorQueue;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.ExpressionFlattener;
import polyglot.visit.InnerClassRemover;
import polyglot.visit.LocalClassRemover;
import polyglot.visit.LoopNormalizer;
import polyglot.visit.NodeVisitor;

public class FabILScheduler
extends JLScheduler {
    protected ExtensionInfo extInfo;

    public FabILScheduler(ExtensionInfo extInfo) {
        super((polyglot.frontend.ExtensionInfo)extInfo);
        this.extInfo = extInfo;
    }

    public Goal TypesInitialized(Job job) {
        FabILTypeSystem ts = this.extInfo.typeSystem();
        FabILNodeFactory nf = this.extInfo.nodeFactory();
        Goal g = this.internGoal((Goal)new VisitorGoal(job, (NodeVisitor)new FabILTypeBuilder(job, ts, nf)));
        try {
            this.addPrerequisiteDependency(g, this.Parsed(job));
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError((Throwable)e);
        }
        return g;
    }

    public Goal LoopsNormalized(Job job) {
        Goal g = this.internGoal((Goal)new VisitorGoal(job, (NodeVisitor)new LoopNormalizer(job, job.extensionInfo().typeSystem(), job.extensionInfo().nodeFactory())){

            public Collection<Goal> prerequisiteGoals(Scheduler s) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabILScheduler.this.TypeChecked(this.job));
                return l;
            }
        });
        return g;
    }

    public Goal ExpressionsFlattened(Job job) {
        Goal g = this.internGoal((Goal)new VisitorGoal(job, (NodeVisitor)new ExpressionFlattener(job, job.extensionInfo().typeSystem(), job.extensionInfo().nodeFactory())){

            public Collection<Goal> prerequisiteGoals(Scheduler s) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabILScheduler.this.LoopsNormalized(this.job));
                return l;
            }
        });
        return g;
    }

    public Goal CheckAbortRetry(Job job) {
        TypeSystem ts = job.extensionInfo().typeSystem();
        NodeFactory nf = job.extensionInfo().nodeFactory();
        Goal g = this.internGoal((Goal)new VisitorGoal(job, (NodeVisitor)new AbortRetryChecker(job, ts, nf)){

            public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabILScheduler.this.TypesInitialized(this.job));
                return l;
            }
        });
        return g;
    }

    public Goal TypeCheckedAfterFlatten(Job job) {
        TypeSystem ts = job.extensionInfo().typeSystem();
        NodeFactory nf = job.extensionInfo().nodeFactory();
        Goal g = this.internGoal((Goal)new TypeChecked(job, ts, nf){

            public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabILScheduler.this.ExpressionsFlattened(this.job));
                l.add(FabILScheduler.this.CheckAbortRetry(this.job));
                return l;
            }
        });
        return g;
    }

    public Goal ClassReferencesCollected(Job job) {
        FabILTypeSystem ts = this.extInfo.typeSystem();
        Goal g = this.internGoal((Goal)new VisitorGoal(job, new ClassReferencesCollector(job, ts)){

            public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabILScheduler.this.Memoized(this.job));
                return l;
            }
        });
        return g;
    }

    public Goal CollectStaticInitializers(Job job) {
        FabILNodeFactory nf = (FabILNodeFactory)job.extensionInfo().nodeFactory();
        FabILTypeSystem ts = (FabILTypeSystem)job.extensionInfo().typeSystem();
        Goal g = this.internGoal((Goal)new VisitorGoal(job, new StaticInitializerCollector(nf, ts)){

            public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabILScheduler.this.TypeChecked(this.job));
                if (FabILScheduler.this.extInfo.getFabILOptions().optLevel() > 0) {
                    l.add(FabILScheduler.this.TypeCheckedAfterFlatten(this.job));
                }
                return l;
            }
        });
        return g;
    }

    public Goal RewriteAtomicMethods(Job job) {
        Goal g = this.internGoal((Goal)new VisitorGoal(job, new AtomicMethodRewriter((ExtensionInfo)job.extensionInfo())){

            public Collection<Goal> prerequisiteGoals(Scheduler s) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabILScheduler.this.CollectStaticInitializers(this.job));
                return l;
            }
        });
        return g;
    }

    public Goal FindUpdatedVariables(Job job) {
        Goal g = this.internGoal((Goal)new VisitorGoal(job, new UpdatedVariableFinder()){

            public Collection<Goal> prerequisiteGoals(Scheduler s) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabILScheduler.this.RewriteAtomicMethods(this.job));
                return l;
            }
        });
        return g;
    }

    public Goal InnerClassesRemoved(Job job) {
        InnerClassRemover icr = new InnerClassRemover(job, this.extInfo.typeSystem(), this.extInfo.nodeFactory()){

            protected ContextVisitor localClassRemover() {
                return new LocalClassRemover(this.job, this.ts, this.nf){

                    protected TypeNode defaultSuperType(Position pos) {
                        return null;
                    }
                };
            }
        };
        Goal g = this.internGoal((Goal)new VisitorGoal(job, (NodeVisitor)icr){

            public Collection<Goal> prerequisiteGoals(Scheduler s) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabILScheduler.this.FindUpdatedVariables(this.job));
                l.add(FabILScheduler.this.RewriteAtomicMethods(this.job));
                return l;
            }
        });
        return g;
    }

    public Goal FixArrayInitializerTypes(Job job) {
        Goal g = this.internGoal((Goal)new VisitorGoal(job, (NodeVisitor)new ArrayInitializerTypeFixer(job, this.extInfo.typeSystem(), this.extInfo.nodeFactory())){

            public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabILScheduler.this.InnerClassesRemoved(this.job));
                return l;
            }
        });
        return g;
    }

    public Goal WrapInlineables(Job job) {
        Goal g = this.internGoal((Goal)new VisitorGoal(job, (NodeVisitor)new InlineableWrapper(job, this.extInfo.typeSystem(), this.extInfo.nodeFactory())){

            public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabILScheduler.this.ExceptionsChecked(this.job));
                l.add(FabILScheduler.this.ExitPathsChecked(this.job));
                l.add(FabILScheduler.this.InitializationsChecked(this.job));
                l.add(FabILScheduler.this.ConstructorCallsChecked(this.job));
                l.add(FabILScheduler.this.ForwardReferencesChecked(this.job));
                l.add(FabILScheduler.this.InnerClassesRemoved(this.job));
                l.add(FabILScheduler.this.FixArrayInitializerTypes(this.job));
                l.addAll(super.prerequisiteGoals(scheduler));
                return l;
            }
        });
        return g;
    }

    public Goal ReadWriteChecked(Job job) {
        Goal g = this.internGoal((Goal)new VisitorGoal(job, (NodeVisitor)new ReadWriteChecker(job, this.extInfo.typeSystem(), this.extInfo.nodeFactory())){

            public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabILScheduler.this.WrapInlineables(this.job));
                l.addAll(super.prerequisiteGoals(scheduler));
                return l;
            }
        });
        return g;
    }

    public Goal LabelsAssigned(Job job) {
        Goal g = this.internGoal((Goal)new VisitorGoal(job, (NodeVisitor)new LabelAssigner(job, this.extInfo)){

            public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabILScheduler.this.InnerClassesRemoved(this.job));
                l.addAll(super.prerequisiteGoals(scheduler));
                return l;
            }
        });
        return g;
    }

    public Goal LocationsAssigned(Job job) {
        Goal g = this.internGoal((Goal)new VisitorGoal(job, (NodeVisitor)new LocationAssigner(job, this.extInfo)){

            public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabILScheduler.this.InnerClassesRemoved(this.job));
                l.addAll(super.prerequisiteGoals(scheduler));
                return l;
            }
        });
        return g;
    }

    public Goal PrincipalsDelegated(Job job) {
        Goal g = this.internGoal((Goal)new VisitorGoal(job, new PrincipalDelegator(this.extInfo)){

            public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabILScheduler.this.RewriteStoreGetters(this.job));
                l.addAll(super.prerequisiteGoals(scheduler));
                return l;
            }
        });
        return g;
    }

    public Goal RewriteStoreGetters(Job job) {
        Goal g = this.internGoal((Goal)new VisitorGoal(job, new StoreGetterRewriter()){

            public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabILScheduler.this.LocationsAssigned(this.job));
                l.add(FabILScheduler.this.LabelsAssigned(this.job));
                return l;
            }
        });
        return g;
    }

    public Goal RewriteProxies(Job job) {
        Goal g = this.internGoal((Goal)new VisitorGoal(job, new ProxyRewriter(this.extInfo)){

            public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabILScheduler.this.WrapInlineables(this.job));
                l.add(FabILScheduler.this.RewriteStoreGetters(this.job));
                l.add(FabILScheduler.this.PrincipalsDelegated(this.job));
                if (FabILScheduler.this.extInfo.getFabILOptions().optLevel() > 0) {
                    l.add(FabILScheduler.this.ReadWriteChecked(this.job));
                }
                l.addAll(super.prerequisiteGoals(scheduler));
                return l;
            }
        });
        return g;
    }

    public Goal InstrumentThreads(Job job) {
        Goal g = this.internGoal((Goal)new VisitorGoal(job, new ThreadRewriter((ExtensionInfo)job.extensionInfo())){

            public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabILScheduler.this.RewriteProxies(this.job));
                return l;
            }
        });
        return g;
    }

    public Goal RewriteAtomic(Job job) {
        Goal g = this.internGoal((Goal)new VisitorGoal(job, new AtomicRewriter((ExtensionInfo)job.extensionInfo())){

            public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabILScheduler.this.RewriteProxies(this.job));
                return l;
            }
        });
        return g;
    }

    public Goal RewriteRemoteCalls(Job job) {
        Goal g = this.internGoal((Goal)new VisitorGoal(job, new RemoteCallRewriter((ExtensionInfo)job.extensionInfo())){

            public Collection<Goal> prerequisiteGoals(Scheduler s) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabILScheduler.this.RewriteAtomic(this.job));
                return l;
            }
        });
        return g;
    }

    public Goal Memoized(Job job) {
        FabILTypeSystem ts = this.extInfo.typeSystem();
        FabILNodeFactory nf = this.extInfo.nodeFactory();
        Goal g = this.internGoal((Goal)new VisitorGoal(job, new Memoizer(job, ts, nf)){

            public Collection<Goal> prerequisiteGoals(Scheduler s) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.add(FabILScheduler.this.RewriteProxies(this.job));
                return l;
            }
        });
        return g;
    }

    public Goal Serialized(Job job) {
        Goal g = this.internGoal((Goal)new Serialized(job){

            public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.addAll(super.prerequisiteGoals(scheduler));
                if (!((FabILOptions)FabILScheduler.this.extInfo.getOptions()).signatureMode()) {
                    l.add(FabILScheduler.this.RewriteProxies(this.job));
                    l.add(FabILScheduler.this.RewriteAtomic(this.job));
                    l.add(FabILScheduler.this.RewriteRemoteCalls(this.job));
                    l.add(FabILScheduler.this.Memoized(this.job));
                    l.add(FabILScheduler.this.InstrumentThreads(this.job));
                    l.add(FabILScheduler.this.ClassReferencesCollected(this.job));
                }
                return l;
            }

            protected polyglot.visit.ClassSerializer createSerializer(TypeSystem ts, NodeFactory nf, Date lastModified, ErrorQueue eq, Version version) {
                if (((FabILOptions)FabILScheduler.this.extInfo.getOptions()).signatureMode()) {
                    return super.createSerializer(ts, nf, lastModified, eq, version);
                }
                return new ClassSerializer(ts, nf, lastModified, eq, version);
            }
        });
        return g;
    }

    public Goal SignatureClean(Job job) {
        Goal g = this.internGoal((Goal)new VisitorGoal(job, new SignatureCleaner()){

            public Collection prerequisiteGoals(Scheduler scheduler) {
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.addAll(super.prerequisiteGoals(scheduler));
                l.add(FabILScheduler.this.Serialized(this.job));
                return l;
            }
        });
        return g;
    }

    public Goal CodeGenerated(Job job) {
        Goal g = this.internGoal((Goal)new CodeGenerated(job){

            public Collection prerequisiteGoals(Scheduler scheduler) {
                FabILOptions opts = (FabILOptions)this.job.extensionInfo().getOptions();
                if (!opts.signatureMode()) {
                    return super.prerequisiteGoals(scheduler);
                }
                ArrayList<Goal> l = new ArrayList<Goal>();
                l.addAll(super.prerequisiteGoals(scheduler));
                l.add(FabILScheduler.this.SignatureClean(this.job));
                return l;
            }
        });
        return g;
    }
}

