/*
 * Decompiled with CFR 0.152.
 */
package fabil.extension;

import fabil.ast.FabricArrayInit;
import fabil.ast.NewFabricArray;
import fabil.extension.AnnotatedExt_c;
import fabil.types.FabILTypeSystem;
import fabil.visit.ProxyRewriter;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.qq.QQ;
import polyglot.types.ClassType;
import polyglot.types.Type;
import polyglot.util.InternalCompilerError;

public class NewFabricArrayExt_c
extends AnnotatedExt_c {
    @Override
    public Expr rewriteProxiesImpl(ProxyRewriter pr) {
        QQ qq = pr.qq();
        NewFabricArray newArray = this.node();
        FabILTypeSystem ts = pr.typeSystem();
        if (!ts.isFabricArray(newArray.type())) {
            return newArray;
        }
        if (newArray.dims().size() > 1) {
            throw new InternalCompilerError("Multidimensional arrays not supported.");
        }
        if (newArray.dims().size() < 1) {
            throw new InternalCompilerError("Missing array dimension");
        }
        Expr size = (Expr)newArray.dims().get(0);
        Type baseType = newArray.type().toArray().base();
        ClassType arrayImplType = ts.fabricRuntimeArrayImplOf(baseType);
        ClassType arrayType = ts.fabricRuntimeArrayOf(baseType);
        String typeArg = "";
        if (baseType.isReference()) {
            typeArg = ts.isPureFabricType(baseType) ? baseType.toString() : "fabric.lang.Object";
            typeArg = typeArg + "._Proxy.class, ";
        }
        return qq.parseExpr("(%T) new %T(%E, %E, " + typeArg + "%E).$getProxy()", (Object)arrayType, (Object)arrayImplType, (Object)newArray.location(), (Object)newArray.label(), (Object)size);
    }

    @Override
    public Expr rewriteProxiesOverrideImpl(ProxyRewriter rewriter) {
        NewFabricArray newArray = this.node();
        FabILTypeSystem ts = rewriter.typeSystem();
        if (!ts.isFabricArray(newArray.type())) {
            return null;
        }
        if (newArray.init() != null) {
            FabricArrayInit init = newArray.init().location(newArray.location());
            newArray = newArray.init(init);
            return (Expr)newArray.visitChild((Node)init, rewriter);
        }
        return null;
    }

    @Override
    public NewFabricArray node() {
        return (NewFabricArray)super.node();
    }
}

