/*
 * Decompiled with CFR 0.152.
 */
package fabil.extension;

import fabil.ast.FabILNodeFactory;
import fabil.extension.ClassMemberExt;
import fabil.extension.ClassMemberExt_c;
import fabil.types.FabILFlags;
import fabil.types.FabILTypeSystem;
import fabil.visit.ProxyRewriter;
import fabil.visit.RemoteCallRewriter;
import fabil.visit.ThreadRewriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Call;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassLit;
import polyglot.ast.ClassMember;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.Ext;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.Initializer;
import polyglot.ast.Local;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.qq.QQ;
import polyglot.types.ClassType;
import polyglot.types.Flags;
import polyglot.types.MethodInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.PrimitiveType;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;

public class ClassDeclExt_c
extends ClassMemberExt_c {
    protected boolean shouldSerializeType = false;
    private static int freshTid = 0;

    public boolean shouldSerializeType() {
        return this.shouldSerializeType;
    }

    public ClassDeclExt_c shouldSerializeType(boolean shouldSerializeType) {
        ClassDeclExt_c result = (ClassDeclExt_c)this.copy();
        result.shouldSerializeType = shouldSerializeType;
        return result;
    }

    @Override
    public Node rewriteProxies(ProxyRewriter pr) {
        ClassDecl classDecl = this.node();
        classDecl = classDecl.flags(classDecl.flags().clear(FabILFlags.NONFABRIC));
        if (!pr.typeSystem().isFabricClass((ClassType)classDecl.type())) {
            return classDecl.ext((Ext)this.shouldSerializeType(true));
        }
        FabILNodeFactory nf = pr.nodeFactory();
        FabILTypeSystem ts = pr.typeSystem();
        if (classDecl.flags().isInterface()) {
            ArrayList<ClassDecl> members = new ArrayList<ClassDecl>(classDecl.body().members());
            members.add(this.makeProxy(pr, pr.typeSystem().FObject()));
            ArrayList<CanonicalTypeNode> interfaces = classDecl.interfaces();
            boolean needObject = true;
            for (TypeNode typeNode : interfaces) {
                if (!"fabric.lang.Object".equals(typeNode.toString())) continue;
                needObject = false;
                break;
            }
            if (needObject) {
                interfaces = new ArrayList<CanonicalTypeNode>(interfaces);
                interfaces.add(nf.CanonicalTypeNode(Position.compilerGenerated(), (Type)ts.FObject()));
            }
            return classDecl.body(classDecl.body().members(members)).interfaces(interfaces).ext((Ext)this.shouldSerializeType(true));
        }
        TypeNode superClass = classDecl.superClass();
        if (superClass == null) {
            superClass = nf.CanonicalTypeNode(Position.compilerGenerated(), (Type)ts.FObject());
        }
        ArrayList<TypeNode> interfaces = new ArrayList<TypeNode>(classDecl.interfaces());
        interfaces.add(superClass);
        ClassDecl result = classDecl.interfaces(interfaces);
        result = result.superClass(null);
        result = (ClassDecl)result.ext((Ext)this.shouldSerializeType(true));
        Flags flags = ProxyRewriter.toInterface(classDecl.flags());
        result = result.flags(flags);
        ClassBody classBody = classDecl.body();
        List oldMembers = classBody.members();
        ArrayList<Object> members = new ArrayList<Object>(oldMembers.size());
        for (ClassMember m : oldMembers) {
            FieldDecl f;
            Flags fieldFlags;
            members.addAll(this.ext(m).interfaceMember(pr, classDecl));
            if (!(m instanceof FieldDecl) || !(fieldFlags = (f = (FieldDecl)m).flags()).isStatic() || !fieldFlags.isFinal() || !fieldFlags.isPublic() || !f.name().startsWith("jlc$")) continue;
            members.add(m);
        }
        ClassType superType = (ClassType)superClass.type();
        members.add(this.makeProxy(pr, superType));
        members.add(this.makeImpl(pr, superType));
        members.addAll(this.makeStatic(pr, superType));
        return result.body(classBody.members(members));
    }

    private ClassDecl makeProxy(ProxyRewriter pr, ClassType superClass) {
        ClassDecl classDecl = this.node();
        ClassBody body = classDecl.body();
        List oldMembers = body.members();
        ArrayList<ClassMember> members = new ArrayList<ClassMember>(oldMembers.size());
        for (ClassMember m : oldMembers) {
            members.addAll(this.ext(m).proxyMember(pr, classDecl));
        }
        members.addAll(this.makeProxyMethods(pr, (ClassType)classDecl.type()));
        QQ qq = pr.qq();
        if (!classDecl.flags().isInterface()) {
            ClassMember implConstr = qq.parseMember("public _Proxy(" + classDecl.id() + "._Impl impl) {" + "super(impl); }");
            members.add(implConstr);
        }
        ClassMember oidConstr = qq.parseMember("public _Proxy(fabric.worker.Store store, long onum) {super(store, onum); }");
        members.add(oidConstr);
        ClassDecl result = qq.parseDecl("public static class _Proxy extends " + superClass.fullName() + "._Proxy implements %T {%LM}", (Object)classDecl.type(), members);
        return result.type(classDecl.type());
    }

    private List<ClassMember> makeProxyMethods(ProxyRewriter pr, ClassType ct) {
        String name;
        List methods;
        ClassType type;
        ArrayList<ClassMember> result = new ArrayList<ClassMember>();
        LinkedList<ClassType> toVisit = new LinkedList<ClassType>();
        HashSet<ClassType> visitedTypes = new HashSet<ClassType>();
        visitedTypes.add(pr.typeSystem().Object());
        visitedTypes.add(pr.typeSystem().FObject());
        HashMap translatedInstances = new HashMap();
        toVisit.add(ct.superType().toClass());
        while (!toVisit.isEmpty()) {
            type = (ClassType)toVisit.remove();
            if (visitedTypes.contains(type)) continue;
            visitedTypes.add(type);
            methods = type.methods();
            for (MethodInstance mi : methods) {
                if (mi.flags().isStatic()) continue;
                name = mi.name();
                HashSet<List> formalTypes = (HashSet<List>)translatedInstances.get(name);
                if (formalTypes == null) {
                    formalTypes = new HashSet<List>();
                    translatedInstances.put(name, formalTypes);
                }
                formalTypes.add(mi.formalTypes());
            }
        }
        toVisit.add(ct);
        while (!toVisit.isEmpty()) {
            type = (ClassType)toVisit.remove();
            if (visitedTypes.contains(type)) continue;
            visitedTypes.add(type);
            methods = type.methods();
            for (MethodInstance mi : methods) {
                name = mi.name();
                List types = mi.formalTypes();
                HashSet<List> formalTypes = (HashSet<List>)translatedInstances.get(name);
                if (formalTypes == null) {
                    formalTypes = new HashSet<List>();
                    translatedInstances.put(name, formalTypes);
                }
                if (formalTypes.contains(types)) continue;
                formalTypes.add(types);
                if (mi.flags().isPrivate()) continue;
                result.add(this.makeProxyMethod(pr, mi));
            }
            toVisit.addAll(type.interfaces());
        }
        return result;
    }

    private ClassMember makeProxyMethod(ProxyRewriter pr, MethodInstance mi) {
        FabILTypeSystem ts = pr.typeSystem();
        StringBuffer methodDecl = new StringBuffer();
        ArrayList<Object> subst = new ArrayList<Object>();
        Flags flags = ProxyRewriter.toPublic(mi.flags()).clearAbstract();
        methodDecl.append(flags + " ");
        Type returnType = mi.returnType();
        if (returnType.isArray() && ts.isFabricArray(returnType)) {
            returnType = ts.toFabricRuntimeArray(returnType.toArray());
        }
        String name = mi.name();
        methodDecl.append("%T " + name + "(");
        subst.add(returnType);
        StringBuffer args = new StringBuffer();
        List formalTypes = mi.formalTypes();
        int argCount = 1;
        for (Type t : formalTypes) {
            methodDecl.append((argCount == 1 ? "" : ", ") + "%T arg" + argCount);
            args.append((argCount == 1 ? "" : ", ") + "arg" + argCount);
            if (ts.isFabricArray(t)) {
                t = ts.toFabricRuntimeArray(t.toArray());
            }
            subst.add(t);
            ++argCount;
        }
        methodDecl.append(") ");
        List throwTypes = mi.throwTypes();
        if (!throwTypes.isEmpty()) {
            methodDecl.append("throws %LT ");
            subst.add(new ArrayList(throwTypes));
        }
        methodDecl.append("{ " + (returnType.isVoid() ? "" : "return "));
        String implType = this.node().type().fullName();
        if (flags.isStatic()) {
            methodDecl.append(implType + "._Impl");
        } else {
            methodDecl.append("((" + implType + ") fetch())");
        }
        methodDecl.append("." + name + "(" + args + "); }");
        QQ qq = pr.qq();
        return qq.parseMember(methodDecl.toString(), subst);
    }

    private ClassDecl makeImpl(ProxyRewriter pr, ClassType superClass) {
        ClassDecl classDecl = this.node();
        ParsedClassType classType = classDecl.type();
        Flags flags = ProxyRewriter.toPublic(classDecl.flags()).Static();
        ClassBody body = classDecl.body();
        List oldMembers = body.members();
        ArrayList<ClassMember> members = new ArrayList<ClassMember>(oldMembers.size());
        for (ClassMember m : oldMembers) {
            members.addAll(this.ext(m).implMember(pr, classDecl));
        }
        QQ qq = pr.qq();
        ClassMember makeProxyDecl = qq.parseMember("protected fabric.lang.Object._Proxy $makeProxy() {return new " + classType.fullName() + "._Proxy(this); }");
        members.add(makeProxyDecl);
        members.addAll(this.makeSerializers(pr, members));
        ClassMember copyAppStateFrom = this.makeCopyAppStateFrom(pr, members);
        if (copyAppStateFrom != null) {
            members.add(copyAppStateFrom);
        }
        ClassDecl result = qq.parseDecl(flags + " class _Impl extends " + superClass.fullName() + "._Impl implements %T {%LM}", (Object)classType, members);
        return result.type(classDecl.type());
    }

    private List<ClassMember> makeStatic(ProxyRewriter pr, ClassType superClass) {
        ClassDecl classDecl = this.node();
        ParsedClassType classType = classDecl.type();
        ClassBody body = classDecl.body();
        List oldMembers = body.members();
        ArrayList<Object> interfaceMembers = new ArrayList<Object>(oldMembers.size());
        ArrayList<Object> proxyMembers = new ArrayList<Object>(oldMembers.size());
        ArrayList<ClassMember> implMembers = new ArrayList<ClassMember>(oldMembers.size());
        ArrayList<Stmt> implInitMembers = new ArrayList<Stmt>(oldMembers.size());
        for (ClassMember m : oldMembers) {
            interfaceMembers.addAll(this.ext(m).staticInterfaceMember(pr, classDecl));
            proxyMembers.addAll(this.ext(m).staticProxyMember(pr, classDecl));
            implMembers.addAll(this.ext(m).staticImplMember(pr, classDecl));
            implInitMembers.addAll(this.ext(m).staticImplInitMember(pr));
        }
        QQ qq = pr.qq();
        ClassMember proxyConstructorDecl = qq.parseMember("public _Proxy(" + classType.fullName() + "._Static._Impl impl) { super(impl); }");
        proxyMembers.add(proxyConstructorDecl);
        proxyConstructorDecl = qq.parseMember("public _Proxy(fabric.worker.Store store, long onum) {super(store, onum); }");
        proxyMembers.add(proxyConstructorDecl);
        String staticIfaceName = classType.fullName() + "._Static";
        FieldDecl fieldDecl = (FieldDecl)qq.parseMember("public static final " + staticIfaceName + " $instance;");
        proxyMembers.add(fieldDecl);
        Initializer init = (Initializer)qq.parseMember("static {" + staticIfaceName + "._Impl impl = " + "  (" + staticIfaceName + "._Impl)" + "    fabric.lang.Object._Static._Proxy.$makeStaticInstance(" + "      " + staticIfaceName + "._Impl.class);" + "$instance = (" + staticIfaceName + ") impl.$getProxy();" + "impl.$init();" + "}");
        proxyMembers.add(init);
        ClassDecl proxyDecl = qq.parseDecl("final class _Proxy extends fabric.lang.Object._Proxy implements " + classType.fullName() + "._Static {%LM}", proxyMembers);
        interfaceMembers.add(proxyDecl);
        ClassMember implConstructorDecl = qq.parseMember("public _Impl(fabric.worker.Store store, fabric.lang.security.Label label) throws fabric.net.UnreachableNodeException {super(store, label); }");
        implMembers.add(implConstructorDecl);
        ClassMember makeProxyDecl = qq.parseMember("protected fabric.lang.Object._Proxy $makeProxy() { return new " + classType.fullName() + "._Static._Proxy(this); }");
        implMembers.add(makeProxyDecl);
        ClassMember initDecl = qq.parseMember("private void $init() { %LS }", implInitMembers);
        implMembers.add(initDecl);
        ClassDecl implDecl = qq.parseDecl("class _Impl extends fabric.lang.Object._Impl implements " + classType.fullName() + "._Static {%LM}", implMembers);
        interfaceMembers.add(implDecl);
        ClassDecl interfaceDecl = qq.parseDecl("interface _Static extends fabric.lang.Object, Cloneable {%LM}", interfaceMembers);
        ArrayList<ClassMember> result = new ArrayList<ClassMember>(2);
        result.add((ClassMember)interfaceDecl);
        return result;
    }

    private List<ClassMember> makeSerializers(ProxyRewriter pr, List<ClassMember> members) {
        FabILTypeSystem ts = pr.typeSystem();
        ArrayList<ClassMember> result = new ArrayList<ClassMember>(3);
        LinkedList<FieldDecl> fields = new LinkedList<FieldDecl>();
        for (ClassMember m : members) {
            FieldDecl f;
            TypeNode fieldType;
            if (!(m instanceof FieldDecl) || !ts.isFabricType(fieldType = (f = (FieldDecl)m).type()) || f.flags().isTransient()) continue;
            fields.add(f);
        }
        QQ qq = pr.qq();
        StringBuilder out = new StringBuilder();
        StringBuilder in = new StringBuilder();
        ArrayList<Type> inSubst = new ArrayList<Type>();
        for (FieldDecl f : fields) {
            Type t = f.declType();
            if (t.isBoolean()) {
                out.append("out.writeBoolean(this." + f.name() + ");");
                in.append("this." + f.name() + " = in.readBoolean();");
                continue;
            }
            if (t.isByte()) {
                out.append("out.writeByte(this." + f.name() + ");");
                in.append("this." + f.name() + " = in.readByte();");
                continue;
            }
            if (t.isChar()) {
                out.append("out.writeChar(this." + f.name() + ");");
                in.append("this." + f.name() + " = in.readChar();");
                continue;
            }
            if (t.isDouble()) {
                out.append("out.writeDouble(this." + f.name() + ");");
                in.append("this." + f.name() + " = in.readDouble();");
                continue;
            }
            if (t.isFloat()) {
                out.append("out.writeFloat(this." + f.name() + ");");
                in.append("this." + f.name() + " = in.readFloat();");
                continue;
            }
            if (t.isInt()) {
                out.append("out.writeInt(this." + f.name() + ");");
                in.append("this." + f.name() + " = in.readInt();");
                continue;
            }
            if (t.isLong()) {
                out.append("out.writeLong(this." + f.name() + ");");
                in.append("this." + f.name() + " = in.readLong();");
                continue;
            }
            if (t.isShort()) {
                out.append("out.writeShort(this." + f.name() + ");");
                in.append("this." + f.name() + " = in.readShort();");
                continue;
            }
            if (ts.isSubtype(t, (Type)ts.JavaInlineable())) {
                out.append("$writeInline(out, this." + f.name() + ");");
                in.append("this." + f.name() + " = (%T) in.readObject();");
                inSubst.add(t);
                continue;
            }
            out.append("$writeRef($getStore(), this." + f.name() + ", refTypes, " + "out, intraStoreRefs, interStoreRefs);");
            in.append("this." + f.name() + " = (" + f.declType() + ") $readRef(" + f.declType() + "._Proxy.class, " + "(fabric.common.RefTypeEnum) " + "refTypes.next(), in, store, intraStoreRefs);");
        }
        ClassMember serialize = qq.parseMember("public void $serialize(java.io.ObjectOutput out, java.util.List refTypes, java.util.List intraStoreRefs, java.util.List interStoreRefs) throws java.io.IOException {super.$serialize(out, refTypes, intraStoreRefs, interStoreRefs);" + out + " }");
        result.add(serialize);
        ClassMember deserialize = qq.parseMember("public _Impl(fabric.worker.Store store, long onum, int version, long expiry, long label, java.io.ObjectInput in, java.util.Iterator refTypes, java.util.Iterator intraStoreRefs) throws java.io.IOException, java.lang.ClassNotFoundException {super(store, onum, version, expiry, label, in, refTypes, intraStoreRefs);" + in + " }", inSubst);
        result.add(deserialize);
        return result;
    }

    private ClassMember makeCopyAppStateFrom(ProxyRewriter pr, List<ClassMember> members) {
        QQ qq = pr.qq();
        StringBuilder body = new StringBuilder();
        String implType = this.node().type().fullName() + "._Impl";
        for (ClassMember m : members) {
            if (!(m instanceof FieldDecl)) continue;
            FieldDecl f = (FieldDecl)m;
            body.append("this." + f.name() + " = src." + f.name() + ";");
        }
        if (body.length() == 0) {
            return null;
        }
        return qq.parseMember("public void $copyAppStateFrom(fabric.lang.Object._Impl other) {super.$copyAppStateFrom(other);" + implType + " src = (" + implType + ") other;" + body + " }");
    }

    @Override
    public List<ClassMember> interfaceMember(ProxyRewriter pr, ClassDecl parent) {
        ClassDecl decl = this.node();
        decl = decl.flags(ProxyRewriter.toPublic(decl.flags()));
        return Collections.singletonList(decl);
    }

    @Override
    public Node rewriteThreads(ThreadRewriter tr) {
        ClassDecl decl = this.node();
        ParsedClassType type = decl.type();
        if (type == null || !tr.shouldRewrite((ClassType)type)) {
            return super.rewriteThreads(tr);
        }
        QQ qq = tr.qq();
        FabILNodeFactory nf = tr.nodeFactory();
        FabILTypeSystem ts = tr.typeSystem();
        ArrayList<CanonicalTypeNode> interfaces = new ArrayList<CanonicalTypeNode>(decl.interfaces());
        interfaces.add(nf.CanonicalTypeNode(Position.compilerGenerated(), (Type)ts.FabricThread()));
        ClassDecl result = decl.interfaces(interfaces);
        ClassBody body = result.body();
        body = body.addMember(qq.parseMember("private fabric.worker.transaction.TransactionManager $tm;"));
        body = body.addMember(qq.parseMember("public final fabric.worker.transaction.TransactionManager getTransactionManager() { return $tm; }"));
        body = body.addMember(qq.parseMember("public final void setTransactionManager(fabric.worker.transaction.TransactionManager tm) {$tm = tm;}"));
        if (type.methods("start", Collections.emptyList()).isEmpty()) {
            body = body.addMember(qq.parseMember("public void start() {fabric.worker.transaction.TransactionManager.getInstance().registerThread(this); super.start();}"));
        }
        result = result.body(body);
        return result;
    }

    @Override
    public Node rewriteRemoteCalls(RemoteCallRewriter rr) {
        NodeFactory nf = rr.nodeFactory();
        FabILTypeSystem ts = rr.typeSystem();
        ClassDecl cd = this.node();
        if (!cd.name().equals("_Proxy")) {
            return cd;
        }
        TypeNode tnClass = rr.qq().parseType("java.lang.Class");
        TypeNode tnObject = rr.qq().parseType("java.lang.Object");
        ArrayList<Object> members = new ArrayList<Object>(cd.body().members().size());
        for (ClassMember cm : cd.body().members()) {
            Eval ret;
            MethodDecl md;
            members.add(cm);
            if (!(cm instanceof MethodDecl) || !(md = (MethodDecl)cm).flags().isPublic() || md.flags().isStatic() || !md.name().endsWith("_remote")) continue;
            String realName = md.name().substring(0, md.name().length() - 7);
            List realFormals = md.formals().subList(1, md.formals().size());
            String fieldName = "$paramTypes" + freshTid++;
            ArrayList<ClassLit> formalTypes = new ArrayList<ClassLit>(realFormals.size());
            for (Formal f : realFormals) {
                TypeNode tn = f.type();
                formalTypes.add(nf.ClassLit(Position.compilerGenerated(), tn));
            }
            Object init = formalTypes.size() == 0 ? nf.NullLit(Position.compilerGenerated()) : nf.ArrayInit(Position.compilerGenerated(), formalTypes);
            FieldDecl fd = nf.FieldDecl(Position.compilerGenerated(), Flags.STATIC.Public().Final(), (TypeNode)nf.ArrayTypeNode(Position.compilerGenerated(), tnClass), nf.Id(Position.compilerGenerated(), fieldName), (Expr)init);
            members.add(fd);
            ArrayList<Local> locals = new ArrayList<Local>(realFormals.size());
            for (Formal f : realFormals) {
                locals.add(nf.Local(Position.compilerGenerated(), f.id()));
            }
            Object args = locals.size() == 0 ? nf.NullLit(Position.compilerGenerated()) : nf.NewArray(Position.compilerGenerated(), tnObject, 1, nf.ArrayInit(Position.compilerGenerated(), locals));
            ArrayList<Object> arguments = new ArrayList<Object>(4);
            arguments.add(nf.This(Position.compilerGenerated()));
            arguments.add(nf.StringLit(Position.compilerGenerated(), realName));
            arguments.add(nf.AmbExpr(Position.compilerGenerated(), nf.Id(Position.compilerGenerated(), fieldName)));
            arguments.add(args);
            Id rcId = nf.Id(Position.compilerGenerated(), "$remoteWorker");
            Formal remoteWorker = nf.Formal(Position.compilerGenerated(), Flags.FINAL, (TypeNode)nf.CanonicalTypeNode(Position.compilerGenerated(), (Type)ts.RemoteWorker()), rcId);
            Call call = nf.Call(Position.compilerGenerated(), (Receiver)nf.Local(Position.compilerGenerated(), rcId), nf.Id(Position.compilerGenerated(), "issueRemoteCall"), arguments);
            Type retType = md.returnType().type();
            if (retType.isVoid()) {
                ret = nf.Eval(Position.compilerGenerated(), (Expr)call);
            } else if (retType.isPrimitive()) {
                PrimitiveType pt = (PrimitiveType)retType;
                ret = rr.qq().parseStmt(" return (" + pt.wrapperTypeString((TypeSystem)ts) + ")%E;", (Object)call);
            } else {
                Call castExpr = call;
                TypeNode returnType = md.returnType();
                if (ts.isFabricReference(returnType)) {
                    QQ qq = rr.qq();
                    castExpr = qq.parseExpr("fabric.lang.Object._Proxy.$getProxy(%E)", (Object)castExpr);
                }
                ret = nf.Return(Position.compilerGenerated(), (Expr)nf.Cast(Position.compilerGenerated(), md.returnType(), (Expr)castExpr));
            }
            ArrayList<Stmt> catchStmts = new ArrayList<Stmt>();
            catchStmts.add(rr.qq().parseStmt("java.lang.Throwable $t = $e.getCause();"));
            for (TypeNode exception : md.throwTypes()) {
                catchStmts.add(rr.qq().parseStmt("if ($t instanceof %T) throw (%T)$t;", (Object)exception, (Object)exception));
            }
            catchStmts.add(rr.qq().parseStmt("throw new fabric.common.exceptions.InternalError($e);"));
            Stmt tryCatch = rr.qq().parseStmt("try {\n  %S\n}\ncatch (%T $e) {\n  %LS\n}", (Object)ret, (Object)ts.RemoteCallException(), catchStmts);
            ArrayList<Formal> newFormals = new ArrayList<Formal>(md.formals().size() + 1);
            newFormals.add(remoteWorker);
            newFormals.addAll(md.formals());
            MethodDecl wrapper = nf.MethodDecl(Position.compilerGenerated(), Flags.PUBLIC, md.returnType(), nf.Id(Position.compilerGenerated(), realName + "$remote"), newFormals, md.throwTypes(), nf.Block(Position.compilerGenerated(), tryCatch));
            members.add(wrapper);
        }
        return cd.body(nf.ClassBody(Position.compilerGenerated(), members));
    }

    public ClassDecl node() {
        return (ClassDecl)super.node();
    }

    private ClassMemberExt ext(ClassMember m) {
        return (ClassMemberExt)m.ext();
    }
}

