/*
 * Decompiled with CFR 0.152.
 */
package fabil.extension;

import fabil.ast.Atomic;
import fabil.ast.FabILNodeFactory;
import fabil.extension.FabILExt_c;
import fabil.types.FabILTypeSystem;
import fabil.visit.StaticInitializerCollector;
import java.util.ArrayList;
import polyglot.ast.Assign;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassMember;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldAssign;
import polyglot.ast.FieldDecl;
import polyglot.ast.Initializer;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.Stmt;
import polyglot.types.ClassType;
import polyglot.types.Flags;
import polyglot.types.Type;
import polyglot.util.Position;

public class ClassBodyExt_c
extends FabILExt_c {
    @Override
    public Node collectStaticInitializers(StaticInitializerCollector sc) {
        ClassBody body = this.node();
        FabILNodeFactory nf = sc.nodeFactory();
        FabILTypeSystem ts = sc.typeSystem();
        ArrayList<Stmt> initStmts = new ArrayList<Stmt>();
        ClassType classType = null;
        ArrayList<Object> members = new ArrayList<Object>();
        for (Object obj : body.members()) {
            ClassMember member = (ClassMember)obj;
            if (member instanceof Initializer) {
                Initializer init = (Initializer)member;
                if (!init.flags().isStatic()) {
                    members.add(init);
                    continue;
                }
                initStmts.addAll(init.body().statements());
                continue;
            }
            if (member instanceof FieldDecl) {
                FieldDecl fieldDecl = (FieldDecl)member;
                if (!fieldDecl.flags().isStatic() || fieldDecl.init() == null) {
                    members.add(fieldDecl);
                    continue;
                }
                if (fieldDecl.name().startsWith("jlc$")) {
                    members.add(fieldDecl);
                    continue;
                }
                Position pos = Position.compilerGenerated();
                String name = fieldDecl.name();
                if (classType == null) {
                    classType = (ClassType)fieldDecl.fieldInstance().container();
                }
                CanonicalTypeNode fieldReceiver = nf.CanonicalTypeNode(pos, (Type)classType);
                Field field = nf.Field(pos, (Receiver)fieldReceiver, nf.Id(pos, name));
                field = (Field)field.type(fieldDecl.type().type());
                field = field.fieldInstance(fieldDecl.fieldInstance());
                FieldAssign fieldInit = nf.FieldAssign(pos, field, Assign.ASSIGN, fieldDecl.init());
                fieldInit = (FieldAssign)fieldInit.type(fieldDecl.type().type());
                initStmts.add((Stmt)nf.Eval(pos, (Expr)fieldInit));
                members.add(fieldDecl.init(null));
                continue;
            }
            members.add(member);
        }
        if (classType != null) {
            if (!ts.isFabricClass(classType)) {
                return this.node();
            }
            if (classType.flags().isInterface()) {
                return this.node();
            }
        }
        if (!initStmts.isEmpty()) {
            Position pos = Position.compilerGenerated();
            Atomic atomic = nf.Atomic(pos, initStmts);
            Initializer init = nf.Initializer(pos, Flags.STATIC, nf.Block(pos, (Stmt)atomic));
            init = init.initializerInstance(ts.initializerInstance(pos, classType, Flags.STATIC));
            members.add(init);
        }
        return body.members(members);
    }

    public ClassBody node() {
        return (ClassBody)super.node();
    }
}

