/*
 * Decompiled with CFR 0.152.
 */
package fabil.extension;

import fabil.ast.Atomic;
import fabil.extension.FabILExt_c;
import fabil.types.FabILTypeSystem;
import fabil.visit.AtomicRewriter;
import java.util.ArrayList;
import polyglot.ast.Assign;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.Id;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.TypeNode;
import polyglot.types.ArrayType;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.Type;
import polyglot.util.Position;

public class AtomicExt_c
extends FabILExt_c {
    private static int freshTid = 0;

    @Override
    public Node rewriteAtomic(AtomicRewriter ar) {
        Atomic atomic = (Atomic)this.node();
        NodeFactory nf = ar.nodeFactory();
        Position CG = Position.compilerGenerated();
        Eval begin = nf.Eval(CG, (Expr)nf.Call(CG, ar.transactionManager(), nf.Id(CG, "startTransaction")));
        Eval commit = nf.Eval(CG, (Expr)nf.Call(CG, ar.transactionManager(), nf.Id(CG, "commitTransaction")));
        Eval abort = nf.Eval(CG, (Expr)nf.Call(CG, ar.transactionManager(), nf.Id(CG, "abortTransaction")));
        FabILTypeSystem ts = ar.typeSystem();
        ArrayList<LocalDecl> lds = new ArrayList<LocalDecl>();
        ArrayList<Eval> restores = new ArrayList<Eval>();
        for (LocalInstance li : atomic.updatedLocals()) {
            ArrayType at;
            Id lName = nf.Id(Position.compilerGenerated(), li.name());
            Id vName = nf.Id(Position.compilerGenerated(), li.name() + "$var" + freshTid++);
            Type lt = li.type();
            if (lt.isArray() && ts.isPureFabricType((Type)(at = lt.toArray()))) {
                lt = ts.toFabricRuntimeArray(at);
            }
            lds.add(nf.LocalDecl(Position.compilerGenerated(), Flags.NONE, (TypeNode)nf.CanonicalTypeNode(Position.compilerGenerated(), lt), vName, (Expr)nf.Local(Position.compilerGenerated(), lName)));
            restores.add(nf.Eval(Position.compilerGenerated(), (Expr)nf.LocalAssign(Position.compilerGenerated(), nf.Local(Position.compilerGenerated(), lName), Assign.ASSIGN, (Expr)nf.Local(Position.compilerGenerated(), vName))));
        }
        String label = "$label" + freshTid++;
        String flag = "$commit" + freshTid++;
        String e = "$e" + freshTid++;
        String currentTid = "$currentTid" + freshTid++;
        String tm = "$tm" + freshTid++;
        String block = "{\n  %LS\n  fabric.worker.transaction.TransactionManager " + tm + " = fabric.worker.transaction.TransactionManager.getInstance();\n" + "  " + label + ": for (boolean " + flag + " = false; !" + flag + "; ) {\n" + "    " + flag + " = true;\n" + "    %S\n" + "    try {\n" + "      %LS\n" + "    }\n" + "    catch (final fabric.worker.RetryException " + e + ") {\n" + "      " + flag + " = false;" + "      continue " + label + ";\n" + "    }\n" + (atomic.mayAbort() ? "    catch (final fabric.worker.UserAbortException " + e + ") {\n" + "      " + flag + " = false;" + "      break " + label + ";\n" + "    }\n" : "") + "    catch (final fabric.worker.TransactionRestartingException " + e + ") {\n" + "      " + flag + " = false;" + "      fabric.common.TransactionID " + currentTid + " = \n" + "        " + tm + ".getCurrentTid();\n" + "      if (" + e + ".tid.isDescendantOf(" + currentTid + "))\n" + "        continue " + label + ";\n" + "      if (" + currentTid + ".parent != null) throw " + e + ";\n" + "      throw new InternalError(\"Something is broken with transaction management. Got a signal to restart a different transaction than the one being managed.\");\n" + "    }\n" + "    catch (final Throwable " + e + ") {\n" + "      " + flag + " = false;\n" + "      if (" + tm + ".checkForStaleObjects()) continue " + label + ";\n" + "      throw new fabric.worker.AbortException(" + e + ");\n" + "    }\n" + "    finally {\n" + "      if (" + flag + ") {\n" + "        try {\n" + "          %S\n" + "        }\n" + "        catch (final fabric.worker.AbortException " + e + ") {\n" + "          " + flag + " = false;\n" + "        }\n" + "        catch (final fabric.worker.TransactionRestartingException " + e + ") {\n" + "          " + flag + " = false;\n" + "          fabric.common.TransactionID " + currentTid + " = \n" + "            " + tm + ".getCurrentTid();\n" + "          if (" + currentTid + " == null || " + e + ".tid.isDescendantOf(" + currentTid + ")\n" + "              && !" + currentTid + ".equals(" + e + ".tid))\n" + "            continue " + label + ";\n" + "          throw " + e + ";\n" + "        }\n" + "      }\n" + "      else {\n" + "        %S\n" + "      }" + "      if (!" + flag + ") {\n" + "        %LS\n" + "      }\n" + "    }\n" + "  }\n" + "}\n";
        return ar.qq().parseStmt(block, lds, (Object)begin, (Object)atomic.statements(), (Object)commit, (Object)abort, restores);
    }
}

