/*
 * Decompiled with CFR 0.152.
 */
package fabil.ast;

import fabil.ast.Annotated;
import fabil.ast.FabILNodeFactory;
import fabil.ast.FabricArrayInit;
import fabil.ast.NewFabricArray;
import fabil.types.FabILTypeSystem;
import java.util.Collection;
import java.util.List;
import polyglot.ast.ArrayInit;
import polyglot.ast.Expr;
import polyglot.ast.NewArray_c;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.types.ArrayType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeChecker;

public class NewFabricArray_c
extends NewArray_c
implements NewFabricArray,
Annotated {
    protected Expr label;
    protected Expr location;

    public NewFabricArray_c(Position pos, TypeNode baseType, List<Expr> dims, int addDims, FabricArrayInit init, Expr label, Expr location) {
        super(pos, baseType, dims, addDims, (ArrayInit)init);
        this.location = location;
        this.label = label;
    }

    @Override
    public FabricArrayInit init() {
        return (FabricArrayInit)super.init();
    }

    @Override
    public NewFabricArray_c init(ArrayInit init) {
        return (NewFabricArray_c)super.init(init);
    }

    @Override
    public Expr label() {
        return this.label;
    }

    @Override
    public NewFabricArray_c label(Expr label) {
        NewFabricArray_c n = (NewFabricArray_c)this.copy();
        n.label = label;
        return n;
    }

    @Override
    public Expr location() {
        return this.location;
    }

    @Override
    public NewFabricArray_c location(Expr location) {
        NewFabricArray_c n = (NewFabricArray_c)this.copy();
        n.location = location;
        return n;
    }

    protected NewFabricArray_c reconstruct(TypeNode baseType, List<Expr> dims, FabricArrayInit init, Expr location, Expr label) {
        if (baseType != this.baseType || !CollectionUtil.equals(dims, (Collection)this.dims) || init != this.init || location != this.location || label != this.label) {
            NewFabricArray_c n = (NewFabricArray_c)this.copy();
            n.baseType = baseType;
            n.dims = TypedList.copyAndCheck(dims, Expr.class, (boolean)true);
            n.init = init;
            n.location = location;
            n.label = label;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        TypeNode baseType = (TypeNode)this.visitChild((Node)this.baseType, v);
        List dims = this.visitList(this.dims, v);
        FabricArrayInit init = (FabricArrayInit)this.visitChild((Node)this.init, v);
        Expr location = (Expr)this.visitChild((Node)this.location, v);
        Expr label = (Expr)this.visitChild((Node)this.label, v);
        return this.reconstruct(baseType, dims, init, location, label);
    }

    protected ArrayType arrayOf(TypeSystem ts, Type baseType, int dims) {
        return ((FabILTypeSystem)ts).fabricArrayOf(baseType, dims);
    }

    public NewFabricArray_c typeCheck(TypeChecker tc) throws SemanticException {
        FabILTypeSystem ts = (FabILTypeSystem)tc.typeSystem();
        NewFabricArray_c result = (NewFabricArray_c)super.typeCheck(tc);
        if (!ts.isFabricType(result.baseType)) {
            throw new SemanticException("Non-Fabric objects cannot be stored in Fabric arrays.", this.node().position());
        }
        if (this.location != null && !ts.isImplicitCastValid(this.location.type(), ts.Store())) {
            throw new SemanticException("Array location must be a store.", this.location.position());
        }
        if (this.label != null && !ts.isImplicitCastValid(this.label.type(), ts.Label())) {
            throw new SemanticException("Invalid array label.", this.label.position());
        }
        return result;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        if (this.init != null) {
            v.visitCFG((Term)this.baseType, NewFabricArray_c.listChild((List)this.dims, (Term)this.init), 1);
            v.visitCFGList(this.dims, (Term)this.init, 1);
            ArrayInit last = this.init;
            if (this.label != null) {
                v.visitCFG((Term)last, (Term)this.label, 1);
                last = this.label;
            }
            if (this.location != null) {
                v.visitCFG((Term)last, (Term)this.location, 1);
                last = this.location;
            }
            v.visitCFG((Term)last, (Term)this, 0);
        } else {
            v.visitCFG((Term)this.baseType, NewFabricArray_c.listChild((List)this.dims, null), 1);
            Expr last = null;
            if (this.label != null) {
                v.visitCFGList(this.dims, (Term)this.label, 1);
                last = this.label;
            }
            if (this.location != null) {
                if (last == null) {
                    v.visitCFGList(this.dims, (Term)this.location, 1);
                } else {
                    v.visitCFG((Term)last, (Term)this.location, 1);
                }
                last = this.location;
            }
            if (last == null) {
                v.visitCFGList(this.dims, (Term)this, 0);
            } else {
                v.visitCFG((Term)last, (Term)this, 0);
            }
        }
        return succs;
    }

    public Node copy(NodeFactory nf) {
        FabILNodeFactory filNf = (FabILNodeFactory)nf;
        return filNf.NewFabricArray(this.position, this.baseType, this.label, this.location, this.dims, this.addDims, (FabricArrayInit)this.init);
    }
}

