/*
 * Decompiled with CFR 0.152.
 */
package fabil.ast;

import fabil.ast.Annotated;
import fabil.ast.FabILNodeFactory;
import fabil.ast.FabricArrayInit;
import fabil.types.FabILTypeSystem;
import java.util.Collection;
import java.util.List;
import polyglot.ast.ArrayInit_c;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Term;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeChecker;

public class FabricArrayInit_c
extends ArrayInit_c
implements FabricArrayInit,
Annotated {
    protected Expr location;
    protected Expr label;

    public FabricArrayInit_c(Position pos, List<Expr> elements, Expr label, Expr location) {
        super(pos, elements);
        this.location = location;
        this.label = label;
    }

    public FabricArrayInit elements(List elements) {
        return (FabricArrayInit)super.elements(elements);
    }

    @Override
    public Expr location() {
        return this.location;
    }

    @Override
    public FabricArrayInit_c location(Expr location) {
        FabricArrayInit_c n = (FabricArrayInit_c)this.copy();
        n.location = location;
        return n;
    }

    @Override
    public Expr label() {
        return this.label;
    }

    @Override
    public FabricArrayInit_c label(Expr label) {
        FabricArrayInit_c n = (FabricArrayInit_c)this.copy();
        n.label = label;
        return n;
    }

    protected FabricArrayInit_c reconstruct(List<Expr> elements, Expr location, Expr label) {
        if (!CollectionUtil.equals(elements, (Collection)this.elements) || location != this.location || label != this.label) {
            FabricArrayInit_c n = (FabricArrayInit_c)this.copy();
            n.elements = TypedList.copyAndCheck(elements, Expr.class, (boolean)true);
            n.location = location;
            n.label = label;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        List elements = this.visitList(this.elements, v);
        Expr location = (Expr)this.visitChild((Node)this.location, v);
        Expr label = (Expr)this.visitChild((Node)this.label, v);
        return this.reconstruct(elements, location, label);
    }

    public FabricArrayInit_c typeCheck(TypeChecker tc) throws SemanticException {
        FabILTypeSystem ts = (FabILTypeSystem)tc.typeSystem();
        FabricArrayInit_c result = (FabricArrayInit_c)super.typeCheck(tc);
        if (this.location != null && !ts.isImplicitCastValid(this.location.type(), ts.Store())) {
            throw new SemanticException("Array location must be a store.", this.location.position());
        }
        if (this.label != null && !ts.isImplicitCastValid(this.label.type(), ts.Label())) {
            throw new SemanticException("Invalid array label.", this.label.position());
        }
        return result;
    }

    protected Type arrayOf(TypeSystem ts, Type baseType) {
        return ((FabILTypeSystem)ts).fabricArrayOf(baseType);
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        FabILTypeSystem ts = (FabILTypeSystem)av.typeSystem();
        if (child == this.location) {
            return ts.Store();
        }
        if (child == this.label) {
            return ts.Label();
        }
        Type t = av.toType();
        Type baseType = t.toArray().base();
        if (ts.isJavaInlineable(baseType)) {
            return ts.FObject();
        }
        return super.childExpectedType(child, av);
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        Expr last = null;
        if (this.label != null) {
            v.visitCFGList(this.elements, (Term)this.label, 1);
            last = this.label;
        }
        if (this.location != null) {
            if (last == null) {
                v.visitCFGList(this.elements, (Term)this.location, 1);
            } else {
                v.visitCFG((Term)last, (Term)this.location, 1);
            }
            last = this.location;
        }
        if (last == null) {
            v.visitCFGList(this.elements, (Term)this, 0);
        } else {
            v.visitCFG((Term)last, (Term)this, 0);
        }
        return succs;
    }

    public Node copy(NodeFactory nf) {
        FabILNodeFactory filNf = (FabILNodeFactory)nf;
        return filNf.FabricArrayInit(this.position, this.label, this.location, this.elements);
    }
}

