/*
 * Decompiled with CFR 0.152.
 */
package fabil;

import com.sun.org.apache.xalan.internal.xsltc.cmdline.getopt.GetOpt;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class MakeSignature {
    private Options opts;
    private PrintWriter out;

    public static void main(String[] args) throws Exception {
        new MakeSignature().run(args);
    }

    private void run(String[] args) throws Exception {
        this.getOpts(args);
        for (String c : this.opts.classes) {
            this.printUnit(c);
        }
    }

    private String normalize(String s) {
        if (s == null) {
            return s;
        }
        if (s.endsWith("/") || s.endsWith("\\")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    private void printUnit(String clazz) throws Exception {
        Class<?> c = Class.forName(clazz);
        if (this.opts.out == null) {
            this.out = new PrintWriter(System.out, true);
        } else {
            String fn = this.opts.out + "/" + c.getCanonicalName().replace('.', '/') + ".fab";
            String dir = fn.substring(0, fn.lastIndexOf(47));
            new File(dir).mkdirs();
            this.out = new PrintWriter((Writer)new FileWriter(fn), true);
        }
        Package p = c.getPackage();
        if (p != null) {
            this.out.println("package " + p.getName() + ";");
        }
        this.printClass(c);
    }

    private void printClass(Class<?> c) {
        this.out.println(Modifier.toString(c.getModifiers()) + (c.isInterface() ? "" : " class") + " " + c.getSimpleName());
        Class<?> superClass = c.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            this.out.println("    extends " + superClass.getCanonicalName());
        }
        boolean firstIface = true;
        if (this.opts.java) {
            this.out.print("    " + (c.isInterface() ? "extends" : "implements") + " fabric.lang.JavaInlineable");
            firstIface = false;
        }
        for (Class<?> iface : c.getInterfaces()) {
            if (firstIface) {
                firstIface = false;
                this.out.print("    " + (c.isInterface() ? "extends" : "implements") + " ");
            } else {
                this.out.print(", ");
            }
            this.out.print(iface.getCanonicalName());
        }
        this.out.println("{");
        if (this.opts.fields) {
            this.printFields(c);
        }
        this.printConstructors(c);
        this.printMethods(c);
        if (this.opts.inners) {
            this.printInners(c);
        }
        this.out.println("}");
    }

    private boolean visible(int mod) {
        return Modifier.isPublic(mod) ? true : (Modifier.isProtected(mod) ? this.opts.prots : (Modifier.isPrivate(mod) ? this.opts.privs : this.opts.packs));
    }

    private void printFields(Class<?> c) {
        for (Field f : c.getDeclaredFields()) {
            int mod = f.getModifiers() & 0xFFFFFF2F;
            if (!this.visible(mod)) continue;
            this.out.println("  " + Modifier.toString(mod) + " " + f.getType().getCanonicalName() + " " + f.getName() + ";");
        }
    }

    private void printConstructors(Class<?> c) {
        for (Constructor<?> constr : c.getDeclaredConstructors()) {
            int mod = constr.getModifiers();
            if (!this.visible(mod)) continue;
            this.out.print("  " + Modifier.toString(mod) + " " + c.getSimpleName() + "(");
            int argNum = 0;
            for (Class<?> param : constr.getParameterTypes()) {
                if (argNum > 0) {
                    this.out.print(", ");
                }
                this.out.print(param.getCanonicalName() + " arg" + argNum++);
            }
            this.out.println(") {}");
        }
    }

    private void printMethods(Class<?> c) {
        for (Method m : c.getDeclaredMethods()) {
            int mod = m.getModifiers() & 0xFFFFFF3F;
            if (!this.visible(mod)) continue;
            this.out.print("  " + Modifier.toString(mod));
            if (!Modifier.isNative(mod) && !Modifier.isAbstract(mod)) {
                this.out.print(" native");
            }
            this.out.print(" " + m.getReturnType().getCanonicalName() + " " + m.getName() + "(");
            int argNum = 0;
            for (Class<?> param : m.getParameterTypes()) {
                if (argNum > 0) {
                    this.out.print(", ");
                }
                this.out.print(param.getCanonicalName() + " arg" + argNum++);
            }
            this.out.println(");");
        }
    }

    private void printInners(Class<?> c) {
        for (Class<?> cc : c.getDeclaredClasses()) {
            int mod = cc.getModifiers();
            if (!this.visible(mod)) continue;
            this.printClass(cc);
        }
    }

    private void printUsage() {
        System.err.println("Usage: MakeSignature [options] <classname> ...");
        System.err.println("  Options:");
        System.err.println("    -d <path>  output path");
        System.err.println("    -j         Java inlineable class");
        System.err.println("    -f         output fields");
        System.err.println("    -p         output protected members");
        System.err.println("    -r         output private members");
        System.err.println("    -a         output package members");
        System.err.println("    -i         output inner members");
        System.err.println("    -e         same as -fprai");
        System.exit(-1);
    }

    private void getOpts(String[] args) {
        this.opts = new Options();
        GetOpt o = new GetOpt(args, "d:jfpraie");
        try {
            int c = o.getNextOption();
            while (c != -1) {
                switch (c) {
                    case 100: {
                        this.opts.out = o.getOptionArg();
                        break;
                    }
                    case 106: {
                        this.opts.java = true;
                        break;
                    }
                    case 102: {
                        this.opts.fields = true;
                        break;
                    }
                    case 112: {
                        this.opts.prots = true;
                        break;
                    }
                    case 114: {
                        this.opts.privs = true;
                        break;
                    }
                    case 97: {
                        this.opts.packs = true;
                        break;
                    }
                    case 105: {
                        this.opts.inners = true;
                        break;
                    }
                    case 101: {
                        this.opts.inners = true;
                        this.opts.packs = true;
                        this.opts.privs = true;
                        this.opts.prots = true;
                        this.opts.fields = true;
                    }
                }
                c = o.getNextOption();
            }
            this.opts.classes = o.getCmdArgs();
            this.opts.out = this.normalize(this.opts.out);
        }
        catch (Exception e) {
            this.printUsage();
        }
        if (this.opts.classes.length == 0) {
            this.printUsage();
        }
    }

    private static class Options {
        public static final String OPTS = "d:jfpraie";
        public String[] classes;
        public String out;
        public boolean java;
        public boolean fields;
        public boolean prots;
        public boolean privs;
        public boolean packs;
        public boolean inners;

        private Options() {
        }
    }
}

