/*
 * Decompiled with CFR 0.152.
 */
package fabil;

import fabil.FabILOptions;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import polyglot.frontend.ExtensionInfo;
import polyglot.main.Main;
import polyglot.main.Options;
import polyglot.main.UsageError;

public class FabILOptions_c
extends Options
implements FabILOptions {
    public boolean signatureMode;
    public boolean dumpDependencies;
    public String sigcp = null;
    public List<String> addSigcp = new ArrayList<String>();
    public int optLevel;

    public FabILOptions_c(ExtensionInfo extension) {
        super(extension);
    }

    public void setDefaultValues() {
        super.setDefaultValues();
        this.fully_qualified_names = true;
        this.signatureMode = false;
        this.dumpDependencies = false;
        this.optLevel = 0;
    }

    public int parseCommand(String[] args, int index, Set source) throws UsageError, Main.TerminationException {
        if (args[index].equals("-sig")) {
            ++index;
            this.signatureMode = true;
        } else if (args[index].equals("-dumpdeps")) {
            ++index;
            this.dumpDependencies = true;
        } else if (args[index].equals("-sigcp")) {
            int n = ++index;
            ++index;
            this.sigcp = args[n];
        } else if (args[index].equals("-addsigcp")) {
            int n = ++index;
            ++index;
            this.addSigcp.add(args[n]);
        } else if (args[index].startsWith("-O")) {
            if (args[index].length() == 2) {
                this.optLevel = Integer.MAX_VALUE;
            } else {
                try {
                    this.optLevel = Integer.parseInt(args[index].substring(2));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            ++index;
        } else {
            return super.parseCommand(args, index, source);
        }
        return index;
    }

    public void usage(PrintStream out) {
        super.usage(out);
        this.usageForFlag(out, "-sig", "compile sources to signatures");
        this.usageForFlag(out, "-sigcp <path>", "path for FabIL signatures (e.g. for fabric.lang.Object)");
        this.usageForFlag(out, "-addsigcp <path>", "additional path for FabIL signatures; prefixed to sigcp");
        this.usageForFlag(out, "-dumpdeps", "output dependencies for each class");
        this.usageForFlag(out, "-O", "turn optimizations on");
    }

    @Override
    public String constructSignatureClasspath() {
        String scp = "";
        for (String item : this.addSigcp) {
            scp = scp + File.pathSeparator + item;
        }
        if (this.sigcp != null) {
            scp = scp + File.pathSeparator + this.sigcp;
        }
        return scp;
    }

    @Override
    public String constructFabILClasspath() {
        return this.constructSignatureClasspath() + File.pathSeparator + this.constructFullClasspath();
    }

    @Override
    public String constructPostCompilerClasspath() {
        return super.constructPostCompilerClasspath() + File.pathSeparator + this.constructFullClasspath();
    }

    @Override
    public int optLevel() {
        return this.optLevel;
    }

    @Override
    public boolean dumpDependencies() {
        return this.dumpDependencies;
    }

    @Override
    public boolean signatureMode() {
        return this.signatureMode;
    }

    public static FabILOptions global() {
        return (FabILOptions)global;
    }
}

