/*
 * Decompiled with CFR 0.152.
 */
package jif.visit;

import java.util.List;
import jif.ast.JifClassDecl;
import jif.ast.JifMethodDecl;
import jif.ast.JifUtil;
import jif.extension.CallHelper;
import jif.types.Constraint;
import jif.types.ConstraintMessage;
import jif.types.JifContext;
import jif.types.JifMethodInstance;
import jif.types.JifProcedureInstance;
import jif.types.JifTypeSystem;
import jif.types.LabelConstraint;
import jif.types.NamedLabel;
import jif.types.PrincipalConstraint;
import jif.types.Solver;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.Label;
import jif.types.principal.Principal;
import jif.visit.JifLabelSubst;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.MethodInstance;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.Copy;
import polyglot.util.ErrorQueue;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.NodeVisitor;

public class LabelChecker
implements Copy {
    private JifContext context;
    protected final JifTypeSystem ts;
    protected final Job job;
    protected final NodeFactory nf;
    protected final boolean solvePerClassBody;
    protected final boolean solvePerMethod;
    protected Solver solver;

    public LabelChecker(Job job, TypeSystem ts, NodeFactory nf, boolean solvePerClassBody, boolean solvePerMethod, boolean doLabelSubst) {
        this.job = job;
        this.ts = (JifTypeSystem)ts;
        this.context = (JifContext)ts.createContext();
        this.nf = nf;
        this.solvePerClassBody = solvePerClassBody;
        this.solvePerMethod = solvePerMethod;
        if (!solvePerClassBody && !solvePerMethod) {
            this.solver = this.ts.createSolver("Job solver: " + job.toString());
        }
    }

    public Object copy() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalCompilerError("Java clone() weirdness.", (Throwable)e);
        }
    }

    public JifContext context() {
        return this.context;
    }

    public JifContext jifContext() {
        return this.context;
    }

    public LabelChecker context(JifContext c) {
        if (c == this.context) {
            return this;
        }
        LabelChecker lc = (LabelChecker)this.copy();
        lc.context = c;
        return lc;
    }

    public JifTypeSystem typeSystem() {
        return this.ts;
    }

    public JifTypeSystem jifTypeSystem() {
        return this.ts;
    }

    public NodeFactory nodeFactory() {
        return this.nf;
    }

    public Solver solver() {
        return this.solver;
    }

    public Job job() {
        return this.job;
    }

    public ErrorQueue errorQueue() {
        return this.job.compiler().errorQueue();
    }

    public Label upperBound(Label L1, Label L2) {
        return this.ts.join(L1, L2);
    }

    public Label upperBound(Label L1, Label L2, Label L3) {
        return this.ts.join(this.ts.join(L1, L2), L3);
    }

    public Label lowerBound(Label L1, Label L2) {
        return this.ts.meet(L1, L2);
    }

    protected Node preLabelCheck(Node n) {
        return n;
    }

    protected Node postLabelCheck(Node old, Node n) {
        return n;
    }

    public Node labelCheck(Node n) throws SemanticException {
        if (JifUtil.jifExt(n) != null) {
            this.context().labelEnv().setSolver(this.solver());
            n = this.preLabelCheck(n);
            Node newNode = JifUtil.jifExt(n).labelCheck(this);
            n = newNode = this.postLabelCheck(n, newNode);
        }
        return n;
    }

    public void constrain(NamedLabel lhs, Constraint.Kind kind, NamedLabel rhs, LabelEnv env, Position pos, ConstraintMessage msg) throws SemanticException {
        this.constrain(lhs, kind, rhs, env, pos, true, msg);
    }

    public void constrain(NamedLabel lhs, Constraint.Kind kind, NamedLabel rhs, LabelEnv env, Position pos, boolean report, ConstraintMessage msg) throws SemanticException {
        LabelConstraint c = new LabelConstraint(lhs, kind, rhs, env, pos, msg, report);
        if (msg != null) {
            msg.setConstraint(c);
        }
        this.constrain(c);
    }

    public void constrain(NamedLabel lhs, Constraint.Kind kind, NamedLabel rhs, LabelEnv env, Position pos) throws SemanticException {
        this.constrain(lhs, kind, rhs, env, pos, false, null);
    }

    protected void constrain(Constraint c) throws SemanticException {
        this.solver.addConstraint(c);
    }

    public void constrain(Principal p, Constraint.Kind kind, Principal q, LabelEnv env, Position pos, ConstraintMessage msg) throws SemanticException {
        this.constrain(p, kind, q, env, pos, msg, true);
    }

    public void constrain(Principal p, Constraint.Kind kind, Principal q, LabelEnv env, Position pos, ConstraintMessage msg, boolean report) throws SemanticException {
        PrincipalConstraint c = new PrincipalConstraint(p, kind, q, env, pos, msg, report);
        if (msg != null) {
            msg.setConstraint(c);
        }
        this.constrain(c);
    }

    public void enteringClassDecl(ClassType ct) {
        if (this.solvePerClassBody) {
            this.solver = this.ts.createSolver(ct.name());
        }
    }

    public void enteringMethod(MethodInstance mi) {
        if (this.solvePerMethod) {
            this.solver = this.ts.createSolver(mi.container().toString() + "." + mi.name());
        }
    }

    public JifClassDecl leavingClassDecl(JifClassDecl n) {
        if (this.solvePerClassBody) {
            return (JifClassDecl)this.solveConstraints((Node)n);
        }
        return n;
    }

    public JifMethodDecl leavingMethod(JifMethodDecl n) {
        if (this.solvePerMethod) {
            return (JifMethodDecl)this.solveConstraints((Node)n);
        }
        return n;
    }

    public Node finishedLabelCheckPass(Node n) {
        if (!this.solvePerClassBody) {
            return this.solveConstraints(n);
        }
        return n;
    }

    protected Node solveConstraints(Node n) {
        Node newN = n;
        JifLabelSubst jls = new JifLabelSubst(this.job, this.ts, this.nf, this.solver);
        if ((jls = (JifLabelSubst)jls.begin()) != null) {
            newN = n.visit((NodeVisitor)jls);
            jls.finish(newN);
        }
        return newN;
    }

    public void reportSemanticException(SemanticException e) {
        Position pos = e.position() != null ? e.position() : this.job().ast().position();
        this.errorQueue().enqueue(5, e.getMessage(), pos);
    }

    public CallHelper createCallHelper(Label receiverLabel, Receiver receiver, ReferenceType calleeContainer, JifProcedureInstance pi, List actualArgs, Position position) {
        return new CallHelper(receiverLabel, receiver, calleeContainer, pi, actualArgs, position);
    }

    public CallHelper createCallHelper(Label receiverLabel, ReferenceType calleeContainer, JifProcedureInstance pi, List actualArgs, Position position) {
        return this.createCallHelper(receiverLabel, null, calleeContainer, pi, actualArgs, position);
    }

    public CallHelper createOverrideHelper(JifMethodInstance overridden, JifMethodInstance overriding) {
        return CallHelper.OverrideHelper(overridden, overriding, this);
    }
}

