/*
 * Decompiled with CFR 0.152.
 */
package jif.visit;

import jif.visit.LabelChecker;
import polyglot.ast.Node;
import polyglot.frontend.AbstractPass;
import polyglot.frontend.Job;
import polyglot.frontend.goals.Goal;
import polyglot.types.SemanticException;
import polyglot.util.ErrorQueue;
import polyglot.util.InternalCompilerError;

public class LabelCheckPass
extends AbstractPass {
    private final Job job;
    private final LabelChecker lc;

    public LabelCheckPass(Goal goal, Job job, LabelChecker lc) {
        super(goal);
        this.job = job;
        this.lc = lc;
    }

    public boolean run() {
        Node ast = this.job.ast();
        if (ast == null) {
            throw new InternalCompilerError("Null AST for job " + this.job + ": did the parser run?");
        }
        ErrorQueue q = this.job.compiler().errorQueue();
        int nErrsBefore = q.errorCount();
        try {
            ast = this.lc.labelCheck(ast);
            ast = this.lc.finishedLabelCheckPass(ast);
        }
        catch (SemanticException e) {
            this.lc.reportSemanticException(e);
        }
        int nErrsAfter = q.errorCount();
        this.job.ast(ast);
        return nErrsBefore == nErrsAfter;
    }
}

