/*
 * Decompiled with CFR 0.152.
 */
package jif.visit;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jif.ast.DowngradeExpr;
import jif.ast.Jif;
import jif.ast.JifUtil;
import jif.extension.JifArrayAccessDel;
import jif.extension.JifExprExt;
import polyglot.ast.ArrayAccess;
import polyglot.ast.ArrayAccessAssign;
import polyglot.ast.Assign;
import polyglot.ast.Binary;
import polyglot.ast.Conditional;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Local;
import polyglot.ast.LocalAssign;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Term;
import polyglot.ast.Unary;
import polyglot.frontend.Job;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.DataFlow;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerBoundsChecker
extends DataFlow {
    protected static final Set<Binary.Operator> INTERESTING_BINARY_OPERATORS = new HashSet<Binary.Operator>(Arrays.asList(Binary.EQ, Binary.LE, Binary.LT, Binary.GE, Binary.GT));
    private static final int MAY_INCREASE = 1;
    private static final int MAY_DECREASE = 2;

    public IntegerBoundsChecker(Job job) {
        this(job, job.extensionInfo().typeSystem(), job.extensionInfo().nodeFactory());
    }

    public IntegerBoundsChecker(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf, true);
    }

    protected DataFlow.Item createInitialItem(FlowGraph graph, Term node, boolean entry) {
        return new DataFlowItem();
    }

    protected Map flow(List inItems, List inItemKeys, FlowGraph graph, Term n, boolean entry, Set edgeKeys) {
        return this.flowToBooleanFlow(inItems, inItemKeys, graph, n, entry, edgeKeys);
    }

    public Map flow(DataFlow.Item trueItem, DataFlow.Item falseItem, DataFlow.Item otherItem, FlowGraph graph, Term n, boolean entry, Set succEdgeKeys) {
        DataFlowItem otherDFItem;
        Map m;
        DataFlow.Item inItem = this.safeConfluence(trueItem, FlowGraph.EDGE_KEY_TRUE, falseItem, FlowGraph.EDGE_KEY_FALSE, otherItem, FlowGraph.EDGE_KEY_OTHER, n, entry, graph);
        if (entry) {
            return IntegerBoundsChecker.itemToMap((DataFlow.Item)inItem, (Set)succEdgeKeys);
        }
        DataFlowItem inDFItem = (DataFlowItem)inItem;
        HashMap<LocalInstance, Bounds> updates = new HashMap<LocalInstance, Bounds>();
        LocalInstance increased = null;
        LocalInstance decreased = null;
        if (n instanceof LocalDecl) {
            LocalDecl ld = (LocalDecl)n;
            if (ld.init() != null) {
                int result = this.addBoundsAssign(updates, ld.localInstance(), ld.init(), inDFItem, null);
                if ((result & 1) != 0) {
                    increased = ld.localInstance();
                }
                if ((result & 2) != 0) {
                    decreased = ld.localInstance();
                }
            }
        } else if (n instanceof LocalAssign) {
            int result;
            LocalAssign la = (LocalAssign)n;
            LocalInstance li = ((Local)la.left()).localInstance();
            Expr right = la.right();
            if (!la.operator().equals((Object)Assign.ASSIGN)) {
                Binary.Operator op = la.operator().binaryOperator();
                right = this.nodeFactory().Binary(Position.compilerGenerated(), la.left(), op, la.right());
                right = right.type(la.left().type());
            }
            if (((result = this.addBoundsAssign(updates, li, right, inDFItem, ((JifExprExt)JifUtil.jifExt((Node)la)).getNumericBounds())) & 1) != 0) {
                increased = li;
            }
            if ((result & 2) != 0) {
                decreased = li;
            }
        } else if (n instanceof Unary) {
            Unary u = (Unary)n;
            if (u.expr() instanceof Local) {
                Local l = (Local)u.expr();
                if (u.operator() == Unary.POST_INC || u.operator() == Unary.PRE_INC) {
                    increased = l.localInstance();
                } else if (u.operator() == Unary.POST_DEC || u.operator() == Unary.PRE_DEC) {
                    decreased = l.localInstance();
                }
            }
        } else if (n instanceof Binary && ((Binary)n).type().isBoolean() && ((Binary)n).left().type().isNumeric() && INTERESTING_BINARY_OPERATORS.contains(((Binary)n).operator())) {
            HashMap<LocalInstance, Bounds> falseupdates = new HashMap<LocalInstance, Bounds>();
            Binary b = (Binary)n;
            Expr left = b.left();
            Expr right = b.right();
            boolean flowedOverBinary = false;
            if (b.operator() == Binary.LT) {
                this.addBounds(updates, left, true, right);
                this.addBounds(falseupdates, right, false, left);
                flowedOverBinary = true;
            } else if (b.operator() == Binary.LE) {
                this.addBounds(updates, left, false, right);
                this.addBounds(falseupdates, right, true, left);
                flowedOverBinary = true;
            } else if (b.operator() == Binary.GT) {
                this.addBounds(updates, right, true, left);
                this.addBounds(falseupdates, left, false, right);
                flowedOverBinary = true;
            } else if (b.operator() == Binary.GE) {
                this.addBounds(updates, right, false, left);
                this.addBounds(falseupdates, left, true, right);
                flowedOverBinary = true;
            } else if (b.operator() == Binary.EQ) {
                this.addBounds(updates, left, false, right);
                this.addBounds(updates, right, false, left);
                flowedOverBinary = true;
            }
            if (flowedOverBinary) {
                DataFlowItem trueOutDFItem = inDFItem.update(updates, increased, decreased);
                DataFlowItem falseOutDFItem = inDFItem.update(falseupdates, increased, decreased);
                return IntegerBoundsChecker.itemsToMap((DataFlow.Item)trueOutDFItem, (DataFlow.Item)falseOutDFItem, null, (Set)succEdgeKeys);
            }
        }
        DataFlowItem outDFItem = inDFItem.update(updates, increased, decreased);
        if (n instanceof Expr && ((Expr)n).type().isNumeric()) {
            this.setExprBounds((Expr)n, this.findNumericRange((Expr)n, inDFItem));
        }
        if (n instanceof Expr && ((Expr)n).type().isBoolean() && (n instanceof Binary || n instanceof Unary) && (m = this.flowBooleanConditions(trueItem = trueItem == null ? outDFItem : trueItem, falseItem = falseItem == null ? outDFItem : falseItem, otherDFItem = outDFItem, graph, (Expr)n, succEdgeKeys)) != null) {
            return m;
        }
        return IntegerBoundsChecker.itemToMap((DataFlow.Item)outDFItem, (Set)succEdgeKeys);
    }

    protected void post(FlowGraph graph, Term root) throws SemanticException {
        super.post(graph, root);
        this.notifyAllNodes((Node)root);
    }

    public void check(FlowGraph graph, Term n, boolean entry, DataFlow.Item inItem, Map outItems) throws SemanticException {
        Interval indBounds;
        Interval bounds;
        DataFlowItem dfIn = (DataFlowItem)inItem;
        if (n instanceof Expr && ((Expr)n).type().isNumeric() && (bounds = this.findNumericRange((Expr)n, dfIn)) != null) {
            this.setExprBounds((Expr)n, bounds);
        }
        ArrayAccess aa = null;
        if (n instanceof ArrayAccess) {
            aa = (ArrayAccess)n;
        } else if (n instanceof ArrayAccessAssign) {
            ArrayAccessAssign aaa = (ArrayAccessAssign)n;
            aa = (ArrayAccess)aaa.left();
        }
        if (aa != null && aa.array() instanceof Local && (indBounds = this.getExprBounds(aa.index())).getLower() != null && indBounds.getLower() >= 0L) {
            Local arr = (Local)aa.array();
            Set<LocalInstance> arrays = this.findArrayLengthBounds(aa.index(), true, dfIn);
            if (arrays.contains(arr.localInstance())) {
                JifArrayAccessDel jaad = (JifArrayAccessDel)aa.del();
                jaad.setNoOutOfBoundsExcThrown();
            }
        }
    }

    protected void notifyAllNodes(Node n) {
        n.visit(new NodeVisitor(){

            public Node leave(Node old, Node n, NodeVisitor v) {
                Jif ext = JifUtil.jifExt(n);
                ext.integerBoundsCalculated();
                return n;
            }
        });
    }

    protected DataFlow.Item confluence(List items, Term node, boolean entry, FlowGraph graph) {
        HashMap<LocalInstance, Bounds> newMap = null;
        for (DataFlowItem df : items) {
            if (newMap == null) {
                newMap = new HashMap<LocalInstance, Bounds>(df.bounds);
                continue;
            }
            Iterator iterator = newMap.keySet().iterator();
            while (iterator.hasNext()) {
                LocalInstance li = (LocalInstance)iterator.next();
                if (df.bounds.containsKey(li)) {
                    Bounds b0 = (Bounds)newMap.get(li);
                    Bounds b1 = df.bounds.get(li);
                    newMap.put(li, b0.merge(b1));
                    continue;
                }
                iterator.remove();
            }
        }
        DataFlowItem result = new DataFlowItem(newMap);
        return result;
    }

    protected void setExprBounds(Expr e, Interval bounds) {
        JifExprExt ext = (JifExprExt)JifUtil.jifExt((Node)e);
        ext.setNumericBounds(bounds);
    }

    protected Interval getExprBounds(Expr e) {
        JifExprExt ext = (JifExprExt)JifUtil.jifExt((Node)e);
        Interval rng = ext.getNumericBounds();
        return rng == null ? Interval.FULL : rng;
    }

    protected void addBounds(Map<LocalInstance, Bounds> updates, Expr left, boolean strict, Expr right) {
        Bounds b;
        if (!left.type().isNumeric() || !right.type().isNumeric()) {
            return;
        }
        Set<LocalInstance> lli = this.findLocalInstanceBounds(left, Bound.lower(false));
        Set<LocalInstance> rli = this.findLocalInstanceBounds(right, Bound.upper(false));
        Set<LocalInstance> arrayLengthLli = this.findArrayLengthBounds(left, Bound.lower(false));
        Set<LocalInstance> arrayLengthRli = this.findArrayLengthBounds(right, Bound.upper(false));
        Interval lrng = this.findNumericRange(left, null);
        Interval rrng = this.findNumericRange(right, null);
        for (LocalInstance l : lli) {
            b = updates.get(l);
            if (b == null) {
                b = new Bounds();
            }
            Long lupper = b.range.upper;
            if (rrng.upper != Bounds.POS_INF && rrng.upper <= lupper) {
                lupper = strict ? rrng.upper - 1L : rrng.upper;
            }
            for (LocalInstance r : rli) {
                if (r == l) continue;
                b.bounds.add(new LocalBound(Bound.upper(strict), r));
            }
            for (LocalInstance r : arrayLengthRli) {
                b.bounds.add(new ArrayLengthBound(Bound.upper(strict), r));
            }
            updates.put(l, new Bounds(b.range.lower, lupper, b.bounds));
        }
        for (LocalInstance r : rli) {
            b = updates.get(r);
            if (b == null) {
                b = new Bounds();
            }
            Long rlower = b.range.lower;
            if (lrng.lower != Bounds.NEG_INF && lrng.lower >= rlower) {
                rlower = strict ? lrng.lower + 1L : lrng.lower;
            }
            for (LocalInstance l : lli) {
                if (l == r) continue;
                b.bounds.add(new LocalBound(Bound.lower(strict), l));
            }
            for (LocalInstance l : arrayLengthLli) {
                b.bounds.add(new ArrayLengthBound(Bound.lower(strict), l));
            }
            updates.put(r, new Bounds(rlower, b.range.upper, b.bounds));
        }
    }

    protected int addBoundsAssign(Map<LocalInstance, Bounds> updates, LocalInstance li, Expr right, DataFlowItem df, Interval existingNumericBounds) {
        int result = 3;
        if (!li.type().isNumeric() || !right.type().isNumeric()) {
            return result;
        }
        Bounds b = updates.get(li);
        if (b == null) {
            b = new Bounds();
        }
        Set<LocalInstance> rupperli = this.findLocalInstanceBounds(right, Bound.upper(false));
        for (LocalInstance r : rupperli) {
            if (r != li) {
                b.bounds.add(new LocalBound(Bound.upper(false), r));
                Bounds br = updates.get(r);
                if (br == null) {
                    br = new Bounds();
                    updates.put(r, br);
                }
                br.bounds.add(new LocalBound(Bound.lower(false), li));
                continue;
            }
            result &= 0xFFFFFFFE;
        }
        Set<LocalInstance> rlowerli = this.findLocalInstanceBounds(right, Bound.lower(false));
        for (LocalInstance r : rlowerli) {
            if (r != li) {
                b.bounds.add(new LocalBound(Bound.lower(false), r));
                Bounds br = updates.get(r);
                if (br == null) {
                    br = new Bounds();
                    updates.put(r, br);
                }
                br.bounds.add(new LocalBound(Bound.upper(false), li));
                continue;
            }
            result &= 0xFFFFFFFD;
        }
        Set<LocalInstance> rupperarray = this.findArrayLengthBounds(right, Bound.upper(false));
        for (LocalInstance r : rupperarray) {
            b.bounds.add(new ArrayLengthBound(Bound.upper(false), r));
        }
        Set<LocalInstance> rlowerarray = this.findArrayLengthBounds(right, Bound.lower(false));
        for (LocalInstance r : rlowerarray) {
            b.bounds.add(new ArrayLengthBound(Bound.lower(false), r));
        }
        Interval rrng = this.findNumericRange(right, df);
        if (existingNumericBounds != null) {
            if ((result & 1) != 0 && rrng.upper > existingNumericBounds.upper) {
                rrng = new Interval(rrng.lower, Bounds.POS_INF);
            }
            if ((result & 2) != 0 && rrng.lower < existingNumericBounds.lower) {
                rrng = new Interval(Bounds.NEG_INF, rrng.upper);
            }
        }
        updates.put(li, new Bounds(rrng, b.bounds));
        return result;
    }

    protected Set<LocalInstance> findLocalInstanceBounds(Expr expr, Bound.Type type) {
        if (expr instanceof Local) {
            return Collections.singleton(((Local)expr).localInstance());
        }
        if (expr instanceof Unary) {
            Unary u = (Unary)expr;
            if (u.operator() == Unary.PRE_INC || u.operator() == Unary.PRE_DEC) {
                return this.findLocalInstanceBounds(u.expr(), type);
            }
            if (u.operator() == Unary.POST_INC && type.isUpper()) {
                return this.findLocalInstanceBounds(u.expr(), type);
            }
            if (u.operator() == Unary.POST_DEC && type.isLower()) {
                return this.findLocalInstanceBounds(u.expr(), type);
            }
        } else {
            if (expr instanceof Conditional) {
                Conditional c = (Conditional)expr;
                Set<LocalInstance> con = this.findLocalInstanceBounds(c.consequent(), type);
                Set<LocalInstance> alt = this.findLocalInstanceBounds(c.alternative(), type);
                HashSet<LocalInstance> result = new HashSet<LocalInstance>(con);
                result.retainAll(alt);
                return result;
            }
            if (expr instanceof Binary) {
                Binary b = (Binary)expr;
                if (b.operator() == Binary.ADD) {
                    Set<LocalInstance> left = this.findLocalInstanceBounds(b.left(), type);
                    Set<LocalInstance> right = this.findLocalInstanceBounds(b.right(), type);
                    Interval lrng = this.findNumericRange(b.left(), null);
                    Interval rrng = this.findNumericRange(b.right(), null);
                    HashSet<LocalInstance> result = new HashSet<LocalInstance>();
                    if (type.isLower() && lrng.lower >= 0L || type.isUpper() && lrng.upper <= 0L) {
                        result.addAll(right);
                    }
                    if (type.isLower() && rrng.lower >= 0L || type.isUpper() && rrng.upper <= 0L) {
                        result.addAll(left);
                    }
                    return result;
                }
                if (b.operator() == Binary.SUB) {
                    Set<LocalInstance> left = this.findLocalInstanceBounds(b.left(), type);
                    Interval rrng = this.findNumericRange(b.right(), null);
                    HashSet<LocalInstance> result = new HashSet<LocalInstance>();
                    if (type.isLower() && rrng.upper <= 0L || type.isUpper() && rrng.lower >= 0L) {
                        result.addAll(left);
                    }
                    return result;
                }
            } else if (expr instanceof Assign) {
                Assign a = (Assign)expr;
                HashSet<LocalInstance> result = new HashSet<LocalInstance>();
                if (a instanceof LocalAssign) {
                    result.add(((Local)a.left()).localInstance());
                }
                if (a.operator() == Assign.ASSIGN) {
                    result.addAll(this.findLocalInstanceBounds(a.right(), type));
                }
                return result;
            }
        }
        return Collections.emptySet();
    }

    protected Set<LocalInstance> findArrayLengthBounds(Expr expr, Bound.Type type) {
        if (expr instanceof Field) {
            Field f = (Field)expr;
            if (f.target() instanceof Local && f.name().equals("length") && f.target().type().isArray()) {
                return Collections.singleton(((Local)f.target()).localInstance());
            }
        } else {
            if (expr instanceof Conditional) {
                Conditional c = (Conditional)expr;
                Set<LocalInstance> con = this.findArrayLengthBounds(c.consequent(), type);
                Set<LocalInstance> alt = this.findArrayLengthBounds(c.alternative(), type);
                HashSet<LocalInstance> result = new HashSet<LocalInstance>(con);
                result.retainAll(alt);
                return result;
            }
            if (expr instanceof Binary) {
                Binary b = (Binary)expr;
                if (b.operator() == Binary.ADD) {
                    Set<LocalInstance> left = this.findArrayLengthBounds(b.left(), type);
                    Set<LocalInstance> right = this.findArrayLengthBounds(b.right(), type);
                    Interval lrng = this.findNumericRange(b.left(), null);
                    Interval rrng = this.findNumericRange(b.right(), null);
                    HashSet<LocalInstance> result = new HashSet<LocalInstance>();
                    if (type.isLower() && lrng.lower >= 0L || type.isUpper() && lrng.upper <= 0L) {
                        result.addAll(right);
                    }
                    if (type.isLower() && rrng.lower >= 0L || type.isUpper() && rrng.upper <= 0L) {
                        result.addAll(left);
                    }
                    return result;
                }
                if (b.operator() == Binary.SUB) {
                    Set<LocalInstance> left = this.findArrayLengthBounds(b.left(), type);
                    Interval rrng = this.findNumericRange(b.right(), null);
                    HashSet<LocalInstance> result = new HashSet<LocalInstance>();
                    if (type.isLower() && rrng.upper <= 0L || type.isUpper() && rrng.lower >= 0L) {
                        result.addAll(left);
                    }
                    return result;
                }
            } else if (expr instanceof Assign) {
                Local aleft;
                Assign a = (Assign)expr;
                HashSet<LocalInstance> result = new HashSet<LocalInstance>();
                if (a instanceof LocalAssign && (aleft = (Local)a.left()).type().isArray()) {
                    result.add(aleft.localInstance());
                }
                if (a.operator() == Assign.ASSIGN) {
                    result.addAll(this.findArrayLengthBounds(a.right(), type));
                }
                return result;
            }
        }
        return Collections.emptySet();
    }

    protected Set<LocalInstance> findArrayLengthBounds(Expr expr, boolean strict, DataFlowItem df) {
        Interval right;
        Binary b;
        if (expr instanceof Local) {
            Local l = (Local)expr;
            return this.findArrayLengthBounds(l.localInstance(), strict, df);
        }
        if (expr instanceof Binary && (b = (Binary)expr).operator() == Binary.SUB && Interval.POS.contains(right = this.getExprBounds(b.right()))) {
            boolean newStrict = strict;
            if (right.getLower() > 0L) {
                newStrict = false;
            }
            return this.findArrayLengthBounds(b.left(), newStrict, df);
        }
        return Collections.EMPTY_SET;
    }

    protected Set<LocalInstance> findArrayLengthBounds(LocalInstance li, boolean strict, DataFlowItem df) {
        return this.findArrayLengthBounds(li, strict, df, new HashSet<LocalInstance>());
    }

    protected Set<LocalInstance> findArrayLengthBounds(LocalInstance li, boolean strict, DataFlowItem df, Set<LocalInstance> seen) {
        if (seen.contains(li)) {
            return Collections.EMPTY_SET;
        }
        seen.add(li);
        Bounds bnds = df.bounds.get(li);
        if (bnds == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<LocalInstance> s = new HashSet<LocalInstance>();
        for (Bound b : bnds.bounds) {
            if (b instanceof ArrayLengthBound && b.isUpper()) {
                if (strict && !b.isStrict()) continue;
                s.add(((ArrayLengthBound)b).array);
                continue;
            }
            if (!(b instanceof LocalBound) || !b.isUpper()) continue;
            LocalBound lb = (LocalBound)b;
            boolean newStrict = strict && !b.isStrict();
            s.addAll(this.findArrayLengthBounds(lb.li, newStrict, df, seen));
        }
        return s;
    }

    protected Long findNumericBound(LocalInstance li, DataFlowItem df, Bound.Type type) {
        return this.findNumericBound(li, df, type, new HashSet<LocalInstance>());
    }

    protected Long findNumericBound(LocalInstance li, DataFlowItem df, Bound.Type type, Set<LocalInstance> seen) {
        if (df == null || seen.contains(li)) {
            return type.isLower() ? Bounds.NEG_INF : Bounds.POS_INF;
        }
        seen.add(li);
        Bounds bnds = df.bounds.get(li);
        if (bnds == null) {
            return type.isLower() ? Bounds.NEG_INF : Bounds.POS_INF;
        }
        Long best = bnds.getNumericBound(type);
        for (Bound b : bnds.bounds) {
            if (!(b instanceof LocalBound)) continue;
            LocalBound lb = (LocalBound)b;
            if (type.isLower() != lb.isLower()) continue;
            best = Bounds.refine(best, this.findNumericBound(lb.li, df, lb.type, seen), type);
        }
        if (best != Bounds.POS_INF && best != Bounds.NEG_INF && type.isStrict()) {
            best = type.isLower() ? Long.valueOf(best - 1L) : Long.valueOf(best + 1L);
        }
        return best;
    }

    protected Interval findNumericRange(Expr expr, DataFlowItem df) {
        Field f;
        if (!expr.type().isNumeric()) {
            throw new IllegalArgumentException();
        }
        if (expr.isConstant() && expr.constantValue() instanceof Number) {
            long n = ((Number)expr.constantValue()).longValue();
            return Interval.singleton(n);
        }
        Interval best = Interval.FULL;
        if (expr instanceof Field && (f = (Field)expr).name().equals("length") && f.target().type().isArray()) {
            best = best.intersect(Interval.POS);
        }
        if (df == null) {
            return best;
        }
        if (expr instanceof Local) {
            LocalInstance li = ((Local)expr).localInstance();
            Long low = this.findNumericBound(li, df, Bound.lower(false));
            Long high = this.findNumericBound(li, df, Bound.upper(false));
            best = best.intersect(new Interval(low, high));
        } else if (expr.isConstant() && expr.constantValue() instanceof Number) {
            long n = ((Number)expr.constantValue()).longValue();
            best = best.intersect(Interval.singleton(n));
        } else if (expr instanceof Unary) {
            Unary u = (Unary)expr;
            Interval rng = this.getExprBounds(u.expr());
            if (u.operator() == Unary.POST_INC || u.operator() == Unary.POST_DEC) {
                best = best.intersect(rng);
            } else if (u.operator() == Unary.PRE_INC) {
                best = best.intersect(rng.shift(1L));
            } else if (u.operator() == Unary.PRE_DEC) {
                best = best.intersect(rng.shift(-1L));
            }
        } else if (expr instanceof Conditional) {
            Conditional c = (Conditional)expr;
            Interval con = this.getExprBounds(c.consequent());
            Interval alt = this.getExprBounds(c.alternative());
            best = best.intersect(con.union(alt));
        } else if (expr instanceof DowngradeExpr) {
            DowngradeExpr e = (DowngradeExpr)expr;
            best = best.intersect(this.getExprBounds(e.expr()));
        } else if (expr instanceof Binary) {
            Binary b = (Binary)expr;
            Interval left = this.getExprBounds(b.left());
            Interval right = this.getExprBounds(b.right());
            if (b.operator() == Binary.ADD) {
                best = best.intersect(left.add(right));
            } else if (b.operator() == Binary.SUB) {
                best = best.intersect(left.subtract(right));
            } else if (b.operator() == Binary.MUL) {
                best = best.intersect(left.multiply(right));
            }
        } else if (expr instanceof Assign) {
            Assign a = (Assign)expr;
            Interval left = this.getExprBounds(a.left());
            Interval right = this.getExprBounds(a.right());
            if (a.operator() == Assign.ASSIGN) {
                best = best.intersect(right);
            } else if (a.operator() == Assign.ADD_ASSIGN) {
                best = best.intersect(left.add(right));
            } else if (a.operator() == Assign.SUB_ASSIGN) {
                best = best.intersect(left.subtract(right));
            } else if (a.operator() == Assign.MUL_ASSIGN) {
                best = best.intersect(left.multiply(right));
            }
        } else if (expr instanceof Field && "length".equals((f = (Field)expr).name()) && f.type().isInt() && f.target().type().isArray()) {
            best = best.intersect(Interval.POS);
        }
        return best;
    }

    protected static Long max(Long a, Long b) {
        if (a == Bounds.NEG_INF) {
            return b;
        }
        if (b == Bounds.NEG_INF) {
            return a;
        }
        return a < b ? b : a;
    }

    protected static Long min(Long a, Long b) {
        if (a == Bounds.POS_INF) {
            return b;
        }
        if (b == Bounds.POS_INF) {
            return a;
        }
        return a < b ? a : b;
    }

    protected static boolean nullableEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    protected static int nullableHashCode(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DataFlowItem
    extends DataFlow.Item {
        protected final Map<LocalInstance, Bounds> bounds;

        public DataFlowItem() {
            this.bounds = Collections.emptyMap();
        }

        protected DataFlowItem(Map<LocalInstance, Bounds> bounds) {
            this.bounds = bounds;
        }

        public DataFlowItem(DataFlowItem d) {
            this.bounds = new HashMap<LocalInstance, Bounds>(d.bounds);
        }

        public boolean equals(Object o) {
            if (o instanceof DataFlowItem) {
                DataFlowItem other = (DataFlowItem)((Object)o);
                return ((Object)this.bounds).equals(other.bounds);
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.bounds).hashCode();
        }

        public String toString() {
            return this.bounds.toString();
        }

        public DataFlowItem update(Map<LocalInstance, Bounds> updates, LocalInstance increased, LocalInstance decreased) {
            if (increased == null && decreased == null && (updates == null || updates.isEmpty())) {
                return this;
            }
            boolean changed = false;
            HashMap<LocalInstance, Bounds> updated = new HashMap<LocalInstance, Bounds>(this.bounds);
            if (increased != null || decreased != null) {
                for (LocalInstance li : this.bounds.keySet()) {
                    Bounds bnds = this.bounds.get(li);
                    Set<Bound> old = bnds.bounds;
                    HashSet<Bound> now = new HashSet<Bound>(old);
                    Interval rng = bnds.range;
                    if (li == increased || li == decreased) {
                        for (Bound b : old) {
                            if (b.isLower() && li == decreased) {
                                now.remove(b);
                                continue;
                            }
                            if (!b.isUpper() || li != increased) continue;
                            now.remove(b);
                        }
                        Long low = li == decreased ? Bounds.NEG_INF : rng.lower;
                        Long high = li == increased ? Bounds.POS_INF : rng.upper;
                        rng = new Interval(low, high);
                    } else {
                        for (Bound b : old) {
                            if (b instanceof LocalBound) {
                                LocalBound lb = (LocalBound)b;
                                if (lb.li != li) continue;
                                if (lb.isLower() && li == increased) {
                                    now.remove(lb);
                                    continue;
                                }
                                if (!lb.isUpper() || li != decreased) continue;
                                now.remove(lb);
                                continue;
                            }
                            if (!(b instanceof ArrayLengthBound)) continue;
                            ArrayLengthBound alb = (ArrayLengthBound)b;
                            if (alb.array != increased && alb.array != decreased) continue;
                            now.remove(alb);
                        }
                    }
                    if (old.size() == now.size() && bnds.range.equals(rng)) continue;
                    updated.put(li, new Bounds(rng, now));
                    changed = true;
                }
            }
            for (LocalInstance li : updates.keySet()) {
                Bounds b0 = updates.get(li);
                Bounds b1 = (Bounds)updated.get(li);
                if (b1 == null) {
                    updated.put(li, b0);
                    changed = true;
                    continue;
                }
                if ((b0 = b1.refine(b0)) == b1) continue;
                updated.put(li, b0);
                changed = true;
            }
            if (changed) {
                return new DataFlowItem(updated);
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Bounds {
        public static final Long POS_INF = new Long(Long.MAX_VALUE);
        public static final Long NEG_INF = new Long(Long.MIN_VALUE);
        protected final Interval range;
        protected final Set<Bound> bounds;

        public static Long refine(Long i, Long j, Bound.Type type) {
            if (type.isLower()) {
                return IntegerBoundsChecker.max(i, j);
            }
            return IntegerBoundsChecker.min(i, j);
        }

        public Bounds() {
            this.range = Interval.FULL;
            this.bounds = new HashSet<Bound>();
        }

        public Bounds(Interval range, Set<Bound> bounds) {
            if (range == null || bounds == null) {
                throw new NullPointerException();
            }
            this.range = range;
            this.bounds = bounds;
        }

        public Bounds(Long lowerBound, Long upperBound, Set<Bound> bounds) {
            this(new Interval(lowerBound, upperBound), bounds);
        }

        public Long getNumericLower() {
            return this.range.lower;
        }

        public Long getNumericUpper() {
            return this.range.upper;
        }

        public Set<Bound> getBounds() {
            return this.bounds;
        }

        public Long getNumericBound(Bound.Type type) {
            if (type.isLower()) {
                return this.range.lower;
            }
            return this.range.upper;
        }

        public boolean isTighterThan(Bounds other) {
            return other.range.contains(this.range) && this.bounds.containsAll(other.bounds);
        }

        public Bounds merge(Bounds b1) {
            Bounds b0 = this;
            if (b1.isTighterThan(b0)) {
                return b0;
            }
            if (b0.isTighterThan(b1)) {
                return b1;
            }
            Interval rng = b0.range.union(b1.range);
            HashSet<Bound> bnds = new HashSet<Bound>(b0.bounds);
            bnds.retainAll(b1.bounds);
            return new Bounds(rng, bnds);
        }

        public Bounds refine(Bounds b1) {
            Bounds b0 = this;
            if (b0.isTighterThan(b1)) {
                return b0;
            }
            if (b1.isTighterThan(b0)) {
                return b1;
            }
            Interval rng = b0.range.intersect(b1.range);
            HashSet<Bound> bnds = new HashSet<Bound>(b0.bounds);
            bnds.addAll(b1.bounds);
            return new Bounds(rng, bnds);
        }

        public boolean equals(Object o) {
            if (o instanceof Bounds) {
                Bounds that = (Bounds)o;
                return this.range.equals(that.range) && ((Object)this.bounds).equals(that.bounds);
            }
            return false;
        }

        public int hashCode() {
            return this.range.hashCode() ^ ((Object)this.bounds).hashCode();
        }

        public String toString() {
            return "(" + this.range + ", " + this.bounds + ")";
        }
    }

    public static class Interval {
        public static final Interval FULL = new Interval(Bounds.NEG_INF, Bounds.POS_INF);
        public static final Interval POS = new Interval(0L, Bounds.POS_INF);
        protected final Long lower;
        protected final Long upper;

        public static Interval singleton(long i) {
            return new Interval(i, i);
        }

        public Interval(Long lower, Long upper) {
            if (lower == null || upper == null) {
                throw new NullPointerException();
            }
            this.lower = lower;
            this.upper = upper;
        }

        public Long getLower() {
            return this.lower;
        }

        public Long getUpper() {
            return this.upper;
        }

        public boolean contains(Interval other) {
            return this.lower <= other.lower && this.upper >= other.upper;
        }

        public Interval union(Interval other) {
            Long low = IntegerBoundsChecker.min(this.lower, other.lower);
            Long high = IntegerBoundsChecker.max(this.upper, other.upper);
            return new Interval(low, high);
        }

        public Interval intersect(Interval other) {
            Long low = IntegerBoundsChecker.max(this.lower, other.lower);
            Long high = IntegerBoundsChecker.min(this.upper, other.upper);
            return new Interval(low, high);
        }

        public Interval shift(long i) {
            Long low = this.lower == Bounds.NEG_INF ? Bounds.NEG_INF : this.lower + i;
            Long high = this.upper == Bounds.POS_INF ? Bounds.POS_INF : this.upper + i;
            return new Interval(low, high);
        }

        public Interval add(Interval other) {
            Long low = Bounds.NEG_INF;
            Long high = Bounds.POS_INF;
            if (this.lower != Bounds.NEG_INF && other.lower != Bounds.NEG_INF) {
                low = this.lower + other.lower;
            }
            if (this.upper != Bounds.POS_INF && other.upper != Bounds.POS_INF) {
                high = this.upper + other.upper;
            }
            return new Interval(low, high);
        }

        public Interval subtract(Interval other) {
            Long low = Bounds.NEG_INF;
            Long high = Bounds.POS_INF;
            if (this.lower != Bounds.NEG_INF && other.upper != Bounds.POS_INF) {
                low = this.lower - other.upper;
            }
            if (this.upper != Bounds.POS_INF && other.lower != Bounds.NEG_INF) {
                high = this.upper - other.lower;
            }
            return new Interval(low, high);
        }

        protected Long longMult(Long i, Long j) {
            if (i == 0L || j == 0L) {
                return 0L;
            }
            if (i == Bounds.POS_INF && j > 0L || j == Bounds.POS_INF && i > 0L) {
                return Bounds.POS_INF;
            }
            if ((i == Bounds.POS_INF && j < 0L) | (j == Bounds.POS_INF && i < 0L)) {
                return Bounds.NEG_INF;
            }
            if (i == Bounds.NEG_INF && j > 0L || j == Bounds.NEG_INF && i > 0L) {
                return Bounds.NEG_INF;
            }
            if (i == Bounds.NEG_INF && j < 0L || j == Bounds.NEG_INF && i < 0L) {
                return Bounds.POS_INF;
            }
            return i * j;
        }

        public Interval multiply(Interval other) {
            Long ac = this.longMult(this.lower, other.lower);
            Long ad = this.longMult(this.lower, other.upper);
            Long bc = this.longMult(this.upper, other.lower);
            Long bd = this.longMult(this.upper, other.upper);
            Long low = IntegerBoundsChecker.min(IntegerBoundsChecker.min(ac, ad), IntegerBoundsChecker.min(bc, bd));
            Long high = IntegerBoundsChecker.max(IntegerBoundsChecker.max(ac, ad), IntegerBoundsChecker.max(bc, bd));
            return new Interval(low, high);
        }

        public boolean equals(Object o) {
            if (o instanceof Interval) {
                Interval other = (Interval)o;
                return IntegerBoundsChecker.nullableEquals(this.lower, other.lower) && IntegerBoundsChecker.nullableEquals(this.upper, other.upper);
            }
            return false;
        }

        public int hashCode() {
            return IntegerBoundsChecker.nullableHashCode(this.lower) ^ IntegerBoundsChecker.nullableHashCode(this.upper);
        }

        private static String longString(Long i) {
            if (i == Bounds.POS_INF || i == Bounds.NEG_INF) {
                return "-";
            }
            return i.toString();
        }

        public String toString() {
            return "[" + Interval.longString(this.lower) + "," + Interval.longString(this.upper) + "]";
        }
    }

    protected static class ArrayLengthBound
    extends Bound {
        protected final LocalInstance array;

        public ArrayLengthBound(Bound.Type type, LocalInstance array) {
            super(type);
            this.array = array;
            assert (array.type().isArray());
        }

        public Bound strict(boolean strict) {
            if (this.type.isStrict() == strict) {
                return this;
            }
            return new ArrayLengthBound(this.type.strict(strict), this.array);
        }

        public boolean equals(Object o) {
            if (o instanceof ArrayLengthBound) {
                ArrayLengthBound other = (ArrayLengthBound)o;
                return super.equals(o) && this.array.equals(other.array);
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode() ^ this.array.hashCode() ^ 0xFA1C74CD;
        }

        public String toString() {
            return (Object)((Object)this.type) + this.array.name() + ".length";
        }
    }

    protected static class LocalBound
    extends Bound {
        protected final LocalInstance li;

        public LocalBound(Bound.Type type, LocalInstance bound) {
            super(type);
            this.li = bound;
        }

        public Bound strict(boolean strict) {
            if (this.type.isStrict() == strict) {
                return this;
            }
            return new LocalBound(this.type.strict(strict), this.li);
        }

        public boolean equals(Object o) {
            if (o instanceof LocalBound) {
                LocalBound other = (LocalBound)o;
                return super.equals(o) && this.li.equals(other.li);
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode() ^ this.li.hashCode();
        }

        public String toString() {
            return (Object)((Object)this.type) + this.li.name();
        }
    }

    protected static abstract class Bound {
        public static final Type LT = Type.LT;
        public static final Type LE = Type.LE;
        public static final Type GT = Type.GT;
        public static final Type GE = Type.GE;
        protected final Type type;

        public static Type lower(boolean strict) {
            return GT.strict(strict);
        }

        public static Type upper(boolean strict) {
            return LT.strict(strict);
        }

        public Bound(Type type) {
            this.type = type;
        }

        public boolean isLower() {
            return this.type.isLower();
        }

        public boolean isUpper() {
            return this.type.isUpper();
        }

        public boolean isStrict() {
            return this.type.isStrict();
        }

        public boolean equals(Object o) {
            if (o instanceof Bound) {
                Bound other = (Bound)o;
                return this.type == other.type;
            }
            return false;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            return this.type.toString();
        }

        public abstract Bound strict(boolean var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static enum Type {
            LT("<"),
            LE("<="),
            GT(">"),
            GE(">=");

            private final String name;

            private Type(String name) {
                this.name = name;
            }

            public boolean isLower() {
                return this == GT || this == GE;
            }

            public boolean isUpper() {
                return this == LT || this == LE;
            }

            public boolean isStrict() {
                return this == LT || this == GT;
            }

            public Type strict() {
                switch (this) {
                    case LE: {
                        return LT;
                    }
                    case GE: {
                        return GT;
                    }
                }
                return this;
            }

            public Type nonStrict() {
                switch (this) {
                    case LT: {
                        return LE;
                    }
                    case GT: {
                        return GE;
                    }
                }
                return this;
            }

            public Type strict(boolean strict) {
                return strict ? this.strict() : this.nonStrict();
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

