/*
 * Decompiled with CFR 0.152.
 */
package jif.types.principal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import jif.translate.ConjunctivePrincipalToJavaExpr_c;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.principal.ConjunctivePrincipal;
import jif.types.principal.DisjunctivePrincipal;
import jif.types.principal.Principal;
import jif.types.principal.Principal_c;
import polyglot.main.Report;
import polyglot.types.SemanticException;
import polyglot.types.TypeObject;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class ConjunctivePrincipal_c
extends Principal_c
implements ConjunctivePrincipal {
    private final Set conjuncts;

    public ConjunctivePrincipal_c(Collection conjuncts, JifTypeSystem ts, Position pos) {
        super(ts, pos, new ConjunctivePrincipalToJavaExpr_c());
        this.conjuncts = new LinkedHashSet(conjuncts);
        if (conjuncts.size() < 2) {
            throw new InternalCompilerError("ConjunctivePrincipal should have at least 2 members");
        }
    }

    public boolean isRuntimeRepresentable() {
        for (Principal p : this.conjuncts) {
            if (p.isRuntimeRepresentable()) continue;
            return false;
        }
        return true;
    }

    public boolean isCanonical() {
        for (Principal p : this.conjuncts) {
            if (p.isCanonical()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String sep = "&";
        if (Report.should_report((String)"debug", (int)1)) {
            sb.append("<");
            sep = " and ";
        } else if (Report.should_report((String)"debug", (int)2)) {
            sb.append("<conjunction: ");
            sep = " and ";
        }
        Iterator iter = this.conjuncts.iterator();
        while (iter.hasNext()) {
            Principal p = (Principal)iter.next();
            if (p instanceof DisjunctivePrincipal) {
                sb.append('(');
                sb.append(p);
                sb.append(')');
            } else {
                sb.append(p);
            }
            if (!iter.hasNext()) continue;
            sb.append(sep);
        }
        if (Report.should_report((String)"debug", (int)1)) {
            sb.append(">");
        } else if (Report.should_report((String)"debug", (int)2)) {
            sb.append(">");
        }
        return sb.toString();
    }

    public boolean equalsImpl(TypeObject o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ConjunctivePrincipal) {
            ConjunctivePrincipal that = (ConjunctivePrincipal)o;
            return ((Object)this.conjuncts).equals(that.conjuncts());
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.conjuncts).hashCode();
    }

    public Set conjuncts() {
        return Collections.unmodifiableSet(this.conjuncts);
    }

    public Principal simplify() {
        if (!this.isCanonical()) {
            return this;
        }
        LinkedHashSet<Principal> needed = new LinkedHashSet<Principal>();
        JifTypeSystem jts = (JifTypeSystem)this.ts;
        Iterator i = this.conjuncts.iterator();
        while (i.hasNext()) {
            Principal ci = ((Principal)i.next()).simplify();
            if (ci.hasVariables()) {
                needed.add(ci);
                continue;
            }
            boolean subsumed = false;
            Iterator j = needed.iterator();
            while (j.hasNext()) {
                Principal cj = (Principal)j.next();
                if (cj.hasVariables()) continue;
                if (jts.actsFor(cj, ci)) {
                    subsumed = true;
                    break;
                }
                if (!jts.actsFor(ci, cj)) continue;
                j.remove();
            }
            if (subsumed) continue;
            needed.add(ci);
        }
        if (((Object)needed).equals(this.conjuncts)) {
            return this;
        }
        if (needed.size() == 1) {
            return (Principal)needed.iterator().next();
        }
        return new ConjunctivePrincipal_c(needed, (JifTypeSystem)this.ts, this.position());
    }

    public Principal subst(LabelSubstitution substitution) throws SemanticException {
        HashSet<Principal> substConjuncts = new HashSet<Principal>();
        for (Principal conjunct : this.conjuncts) {
            substConjuncts.add(conjunct.subst(substitution));
        }
        return new ConjunctivePrincipal_c(substConjuncts, (JifTypeSystem)this.ts, this.position());
    }
}

