/*
 * Decompiled with CFR 0.152.
 */
package jif.types.label;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jif.translate.CannotLabelToJavaExpr_c;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.ConfPolicy;
import jif.types.label.IntegPolicy;
import jif.types.label.JoinIntegPolicy_c;
import jif.types.label.JoinLabel;
import jif.types.label.JoinPolicy_c;
import jif.types.label.Label;
import jif.types.label.Label_c;
import jif.types.label.MeetIntegPolicy_c;
import jif.types.label.MeetLabel;
import jif.types.label.MeetPolicy_c;
import jif.types.label.PairLabel;
import jif.types.label.VarLabel_c;
import jif.types.label.WriterPolicy;
import jif.types.label.WritersToReadersLabel;
import polyglot.main.Report;
import polyglot.types.SemanticException;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class WritersToReadersLabel_c
extends Label_c
implements WritersToReadersLabel {
    final Label label;

    public WritersToReadersLabel_c(Label label, JifTypeSystem ts, Position pos) {
        super(ts, pos, new CannotLabelToJavaExpr_c());
        this.label = label;
        this.setDescription("finds an upper bound of " + label + " and converts the writers of the bound into readers");
    }

    public Label label() {
        return this.label;
    }

    public boolean isRuntimeRepresentable() {
        return false;
    }

    public boolean isCovariant() {
        return false;
    }

    public boolean isComparable() {
        return true;
    }

    public boolean isCanonical() {
        return true;
    }

    protected boolean isDisambiguatedImpl() {
        return this.label.isCanonical();
    }

    public boolean isEnumerable() {
        return true;
    }

    public IntegPolicy integProjection() {
        return ((JifTypeSystem)this.ts).bottomIntegPolicy(this.position());
    }

    public boolean equalsImpl(TypeObject o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WritersToReadersLabel)) {
            return false;
        }
        WritersToReadersLabel that = (WritersToReadersLabel)o;
        return this.label.equals(that.label());
    }

    public int hashCode() {
        return this.label.hashCode() ^ 0x91F45;
    }

    public String componentString(Set printedLabels) {
        if (Report.should_report((String)"debug", (int)1)) {
            return "<writersToReaders " + this.label + ">";
        }
        return "writersToReaders(" + this.label() + ")";
    }

    public boolean leq_(Label L, LabelEnv env, LabelEnv.SearchState state) {
        return false;
    }

    public List throwTypes(TypeSystem ts) {
        return Collections.EMPTY_LIST;
    }

    public Label subst(LabelSubstitution substitution) throws SemanticException {
        Label newLabel;
        WritersToReadersLabel lbl = this;
        if (substitution.recurseIntoChildren(lbl) && (newLabel = lbl.label().subst(substitution)) != lbl.label()) {
            JifTypeSystem ts = (JifTypeSystem)this.typeSystem();
            lbl = ts.writersToReadersLabel(lbl.position(), newLabel);
        }
        return substitution.substLabel(lbl);
    }

    public boolean hasWritersToReaders() {
        return true;
    }

    public Label transform(LabelEnv env) {
        Label bound = env.findUpperBound(this.label());
        return WritersToReadersLabel_c.transformImpl(bound);
    }

    protected static Label transformImpl(Label label) {
        JifTypeSystem ts = (JifTypeSystem)label.typeSystem();
        if (label instanceof VarLabel_c) {
            return ts.writersToReadersLabel(label.position(), label);
        }
        if (label instanceof PairLabel) {
            PairLabel pl = (PairLabel)label;
            ConfPolicy newCP = WritersToReadersLabel_c.transformIntegToConf(pl.integPolicy());
            return ts.pairLabel(pl.position(), newCP, ts.bottomIntegPolicy(pl.position()));
        }
        if (label instanceof JoinLabel) {
            JoinLabel L = (JoinLabel)label;
            LinkedHashSet<Label> comps = new LinkedHashSet<Label>();
            for (Label c : L.joinComponents()) {
                comps.add(WritersToReadersLabel_c.transformImpl(c));
            }
            return ts.meetLabel(label.position(), comps);
        }
        if (label instanceof MeetLabel) {
            MeetLabel L = (MeetLabel)label;
            LinkedHashSet<Label> comps = new LinkedHashSet<Label>();
            for (Label c : L.meetComponents()) {
                comps.add(WritersToReadersLabel_c.transformImpl(c));
            }
            return ts.joinLabel(label.position(), comps);
        }
        throw new InternalCompilerError("WritersToReaders undefined for " + label);
    }

    protected static ConfPolicy transformIntegToConf(IntegPolicy pol) {
        JifTypeSystem ts = (JifTypeSystem)pol.typeSystem();
        if (pol instanceof WriterPolicy) {
            WriterPolicy wp = (WriterPolicy)pol;
            return ts.readerPolicy(wp.position(), wp.owner(), wp.writer());
        }
        if (pol instanceof JoinIntegPolicy_c) {
            JoinPolicy_c jp = (JoinPolicy_c)((Object)pol);
            HashSet<ConfPolicy> newPols = new HashSet<ConfPolicy>(jp.joinComponents().size());
            for (IntegPolicy ip : jp.joinComponents()) {
                ConfPolicy cp = WritersToReadersLabel_c.transformIntegToConf(ip);
                newPols.add(cp);
            }
            return ts.meetConfPolicy(jp.position(), newPols);
        }
        if (pol instanceof MeetIntegPolicy_c) {
            MeetPolicy_c mp = (MeetPolicy_c)((Object)pol);
            HashSet<ConfPolicy> newPols = new HashSet<ConfPolicy>(mp.meetComponents().size());
            for (IntegPolicy ip : mp.meetComponents()) {
                ConfPolicy cp = WritersToReadersLabel_c.transformIntegToConf(ip);
                newPols.add(cp);
            }
            return ts.joinConfPolicy(mp.position(), newPols);
        }
        throw new InternalCompilerError("Unexpected integ policy: " + pol);
    }
}

