/*
 * Decompiled with CFR 0.152.
 */
package jif.types.label;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.PathMap;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.ConfPolicy;
import jif.types.label.Policy;
import jif.types.label.Policy_c;
import jif.types.label.ReaderPolicy;
import jif.types.principal.Principal;
import jif.visit.LabelChecker;
import polyglot.types.SemanticException;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class ReaderPolicy_c
extends Policy_c
implements ReaderPolicy {
    private final Principal owner;
    private final Principal reader;

    public ReaderPolicy_c(Principal owner, Principal reader, JifTypeSystem ts, Position pos) {
        super(ts, pos);
        if (owner == null) {
            throw new InternalCompilerError("null owner");
        }
        this.owner = owner;
        this.reader = reader;
    }

    public Principal owner() {
        return this.owner;
    }

    public Principal reader() {
        return this.reader;
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isCanonical() {
        return this.owner.isCanonical() && this.reader.isCanonical();
    }

    public boolean isRuntimeRepresentable() {
        return this.owner.isRuntimeRepresentable() && this.reader.isRuntimeRepresentable();
    }

    protected Policy simplifyImpl() {
        return this;
    }

    public boolean equalsImpl(TypeObject o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ReaderPolicy_c) {
            ReaderPolicy_c that = (ReaderPolicy_c)o;
            if (this.owner == that.owner || this.owner != null && this.owner.equals(that.owner)) {
                return this.reader.equals(that.reader);
            }
        }
        return false;
    }

    public int hashCode() {
        return (this.owner == null ? 0 : this.owner.hashCode()) ^ this.reader.hashCode() ^ 0xE780A;
    }

    public boolean leq_(ConfPolicy p, LabelEnv env, LabelEnv.SearchState state) {
        if (this.isBottomConfidentiality() || p.isTopConfidentiality()) {
            return true;
        }
        if (this.reader.isBottomPrincipal()) {
            return true;
        }
        if (p instanceof ReaderPolicy) {
            ReaderPolicy that = (ReaderPolicy)p;
            if (!env.actsFor(that.owner(), this.owner)) {
                return false;
            }
            return env.actsFor(that.reader(), this.owner()) || env.actsFor(that.reader(), this.reader());
        }
        return false;
    }

    public String toString(Set printedLabels) {
        StringBuffer sb = new StringBuffer(this.owner.toString());
        sb.append("->");
        if (!this.reader.isTopPrincipal()) {
            sb.append(this.reader.toString());
        }
        return sb.toString();
    }

    public List throwTypes(TypeSystem ts) {
        ArrayList throwTypes = new ArrayList();
        throwTypes.addAll(this.owner.throwTypes(ts));
        throwTypes.addAll(this.reader.throwTypes(ts));
        return throwTypes;
    }

    public Policy subst(LabelSubstitution substitution) throws SemanticException {
        Principal newReader;
        boolean changed = false;
        Principal newOwner = this.owner.subst(substitution);
        if (newOwner != this.owner) {
            changed = true;
        }
        if ((newReader = this.reader.subst(substitution)) != this.reader) {
            changed = true;
        }
        if (!changed) {
            return substitution.substPolicy(this);
        }
        JifTypeSystem ts = (JifTypeSystem)this.typeSystem();
        ReaderPolicy newPolicy = ts.readerPolicy(this.position(), newOwner, newReader);
        return substitution.substPolicy(newPolicy);
    }

    public PathMap labelCheck(JifContext A, LabelChecker lc) {
        PathMap X = this.owner.labelCheck(A, lc);
        A.setPc(X.N(), lc);
        PathMap Xr = this.reader.labelCheck(A, lc);
        X = X.join(Xr);
        return X;
    }

    public boolean isBottomConfidentiality() {
        return this.owner.isBottomPrincipal() && this.reader.isBottomPrincipal();
    }

    public boolean isTopConfidentiality() {
        return this.owner.isTopPrincipal() && this.reader.isTopPrincipal();
    }

    public boolean isTop() {
        return this.isTopConfidentiality();
    }

    public boolean isBottom() {
        return this.isBottomConfidentiality();
    }

    public ConfPolicy meet(ConfPolicy p) {
        JifTypeSystem ts = (JifTypeSystem)this.ts;
        return ts.meet(this, p);
    }

    public ConfPolicy join(ConfPolicy p) {
        JifTypeSystem ts = (JifTypeSystem)this.ts;
        return ts.join(this, p);
    }
}

