/*
 * Decompiled with CFR 0.152.
 */
package jif.types.label;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jif.translate.LabelToJavaExpr;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.JifTypeSystem_c;
import jif.types.LabelSubstitution;
import jif.types.PathMap;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.ConfPolicy;
import jif.types.label.IntegPolicy;
import jif.types.label.Label;
import jif.types.label.Label_c;
import jif.types.label.MeetLabel;
import jif.types.label.PairLabel;
import jif.visit.LabelChecker;
import polyglot.types.SemanticException;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class MeetLabel_c
extends Label_c
implements MeetLabel {
    private final Set components;
    private Label normalized = null;

    public MeetLabel_c(Set components, JifTypeSystem ts, Position pos, LabelToJavaExpr trans) {
        super(ts, pos, trans);
        this.components = Collections.unmodifiableSet(MeetLabel_c.flatten(components));
        if (this.components.isEmpty()) {
            throw new InternalCompilerError("No empty meets");
        }
    }

    public boolean isRuntimeRepresentable() {
        for (Label c : this.components) {
            if (c.isRuntimeRepresentable()) continue;
            return false;
        }
        return true;
    }

    public boolean isCanonical() {
        for (Label c : this.components) {
            if (c.isCanonical()) continue;
            return false;
        }
        return true;
    }

    protected boolean isDisambiguatedImpl() {
        return true;
    }

    public boolean isCovariant() {
        for (Label c : this.components) {
            if (!c.isCovariant()) continue;
            return true;
        }
        return false;
    }

    public boolean isComparable() {
        for (Label c : this.components) {
            if (c.isComparable()) continue;
            return false;
        }
        return true;
    }

    public boolean isEnumerable() {
        return true;
    }

    public boolean isBottom() {
        if (this.components.isEmpty()) {
            return false;
        }
        for (Label c : this.components) {
            if (!c.isBottom()) continue;
            return true;
        }
        return false;
    }

    public boolean isTop() {
        return this.components.isEmpty();
    }

    public boolean equalsImpl(TypeObject o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MeetLabel_c) {
            MeetLabel_c that = (MeetLabel_c)o;
            return ((Object)this.components).equals(that.components);
        }
        if (o instanceof Label) {
            return ((Object)this.components).equals(Collections.singleton(o));
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.components).hashCode();
    }

    public String componentString(Set printedLabels) {
        return this.componentString(printedLabels, false);
    }

    private String componentString(Set printedLabels, boolean topLevel) {
        String s = "";
        Iterator i = this.components.iterator();
        while (i.hasNext()) {
            Label c = (Label)i.next();
            s = topLevel ? s + c.toString(printedLabels) : s + c.componentString(printedLabels);
            if (!i.hasNext()) continue;
            s = s + " meet ";
        }
        return s;
    }

    public String toString() {
        return "{" + this.componentString(new HashSet(), true) + "}";
    }

    public String toString(Set printedLabels) {
        return "{" + this.componentString(printedLabels, true) + "}";
    }

    public boolean leq_(Label L, LabelEnv env, LabelEnv.SearchState state) {
        if (!L.isComparable() || !L.isEnumerable()) {
            throw new InternalCompilerError("Cannot compare " + L);
        }
        for (Label pi : this.components) {
            if (!env.leq(pi, L, state)) continue;
            return true;
        }
        return false;
    }

    public Set meetComponents() {
        return Collections.unmodifiableSet(this.components);
    }

    public Object copy() {
        MeetLabel_c l = (MeetLabel_c)super.copy();
        l.normalized = null;
        return l;
    }

    public Label normalize() {
        if (this.normalized == null) {
            this.normalized = this.normalizeImpl();
        }
        return this.normalized;
    }

    private Label normalizeImpl() {
        if (this.components.size() == 1) {
            return (Label)this.components.iterator().next();
        }
        JifTypeSystem ts = (JifTypeSystem)this.typeSystem();
        PairLabel pl = null;
        boolean combinedPL = false;
        LinkedHashSet<Label> nonPairLabels = new LinkedHashSet<Label>();
        for (Label lbl : this.meetComponents()) {
            if (lbl instanceof PairLabel) {
                PairLabel p = (PairLabel)lbl;
                if (pl == null) {
                    pl = p;
                    continue;
                }
                combinedPL = true;
                pl = ts.pairLabel(this.position(), pl.confPolicy().meet(p.confPolicy()), pl.integPolicy().meet(p.integPolicy()));
                continue;
            }
            nonPairLabels.add(lbl);
        }
        if (combinedPL) {
            nonPairLabels.add(pl);
            return ts.meetLabel(this.position(), nonPairLabels);
        }
        return this;
    }

    protected Label simplifyImpl() {
        if (!this.isDisambiguated() || this.components.isEmpty()) {
            return this;
        }
        Set comps = MeetLabel_c.flatten(this.components);
        LinkedHashSet<Label> needed = new LinkedHashSet<Label>();
        JifTypeSystem jts = (JifTypeSystem)this.ts;
        Iterator i = comps.iterator();
        while (i.hasNext()) {
            Label ci = ((Label)i.next()).simplify();
            if (ci.hasVariables() || ci.hasWritersToReaders()) {
                needed.add(ci);
                continue;
            }
            boolean subsumed = false;
            Iterator j = needed.iterator();
            while (j.hasNext()) {
                Label cj = (Label)j.next();
                if (cj.hasVariables() || cj.hasWritersToReaders()) continue;
                if (jts.leq(cj, ci)) {
                    subsumed = true;
                    break;
                }
                if (!jts.leq(ci, cj)) continue;
                j.remove();
            }
            if (subsumed) continue;
            needed.add(ci);
        }
        if (((Object)needed).equals(this.components)) {
            return this;
        }
        if (needed.size() == 1) {
            return (Label)needed.iterator().next();
        }
        return new MeetLabel_c(needed, (JifTypeSystem)this.ts, this.position(), ((JifTypeSystem_c)this.ts).meetLabelTranslator());
    }

    private static Set flatten(Set comps) {
        boolean needFlattening = false;
        for (Label L : comps) {
            if (!(L instanceof MeetLabel)) continue;
            needFlattening = true;
            break;
        }
        if (!needFlattening) {
            return comps;
        }
        LinkedHashSet<Label> c = new LinkedHashSet<Label>();
        for (Label L : comps) {
            if (L.isBottom()) {
                return Collections.singleton(L);
            }
            if (L instanceof MeetLabel) {
                Set lComps = ((MeetLabel)L).meetComponents();
                c.addAll(lComps);
                continue;
            }
            c.add(L);
        }
        return c;
    }

    public ConfPolicy confProjection() {
        HashSet<ConfPolicy> confPols = new HashSet<ConfPolicy>();
        for (Label c : this.components) {
            confPols.add(c.confProjection());
        }
        return ((JifTypeSystem)this.ts).meetConfPolicy(this.position, confPols);
    }

    public IntegPolicy integProjection() {
        HashSet<IntegPolicy> integPols = new HashSet<IntegPolicy>();
        for (Label c : this.components) {
            integPols.add(c.integProjection());
        }
        return ((JifTypeSystem)this.ts).meetIntegPolicy(this.position, integPols);
    }

    public List throwTypes(TypeSystem ts) {
        ArrayList throwTypes = new ArrayList();
        for (Label L : this.components) {
            throwTypes.addAll(L.throwTypes(ts));
        }
        return throwTypes;
    }

    public Label subst(LabelSubstitution substitution) throws SemanticException {
        if (this.components.isEmpty() || substitution.stackContains(this) || !substitution.recurseIntoChildren(this)) {
            return substitution.substLabel(this);
        }
        substitution.pushLabel(this);
        boolean changed = false;
        LinkedHashSet<Label> s = new LinkedHashSet<Label>();
        for (Label c : this.components) {
            Label newc = c.subst(substitution);
            if (!changed && newc != c) {
                Label d;
                changed = true;
                s = new LinkedHashSet();
                Iterator j = this.components.iterator();
                while (j.hasNext() && c != (d = (Label)j.next())) {
                    s.add(d);
                }
            }
            if (!changed) continue;
            s.add(newc);
        }
        substitution.popLabel(this);
        if (!changed) {
            return substitution.substLabel(this);
        }
        JifTypeSystem ts = (JifTypeSystem)this.typeSystem();
        Label newmeetLabel = ts.meetLabel(this.position(), MeetLabel_c.flatten(s));
        return substitution.substLabel(newmeetLabel);
    }

    public boolean hasWritersToReaders() {
        for (Label ci : this.meetComponents()) {
            if (!ci.hasWritersToReaders()) continue;
            return true;
        }
        return false;
    }

    public Set variableComponents() {
        LinkedHashSet s = new LinkedHashSet();
        for (Label ci : this.meetComponents()) {
            s.addAll(ci.variableComponents());
        }
        return s;
    }

    public PathMap labelCheck(JifContext A, LabelChecker lc) {
        JifTypeSystem ts = (JifTypeSystem)A.typeSystem();
        PathMap X = ts.pathMap().N(A.pc()).NV(A.pc());
        if (this.components.isEmpty()) {
            return X;
        }
        A = (JifContext)A.pushBlock();
        Iterator i = this.components.iterator();
        while (i.hasNext()) {
            A.setPc(X.N(), lc);
            Label c = (Label)i.next();
            PathMap Xc = c.labelCheck(A, lc);
            X = X.join(Xc);
        }
        return X;
    }
}

