/*
 * Decompiled with CFR 0.152.
 */
package jif.types.label;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.PathMap;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.Policy;
import jif.types.label.Policy_c;
import jif.visit.LabelChecker;
import polyglot.types.SemanticException;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public abstract class JoinPolicy_c
extends Policy_c {
    private final Set joinComponents;
    private Integer hashCode = null;

    public JoinPolicy_c(Set components, JifTypeSystem ts, Position pos) {
        super(ts, pos);
        this.joinComponents = Collections.unmodifiableSet(JoinPolicy_c.flatten(components));
        if (this.joinComponents.isEmpty()) {
            throw new InternalCompilerError("Empty collection!");
        }
    }

    public boolean isSingleton() {
        return this.joinComponents.size() == 1;
    }

    public boolean isCanonical() {
        for (Policy c : this.joinComponents) {
            if (c.isCanonical()) continue;
            return false;
        }
        return true;
    }

    public boolean isRuntimeRepresentable() {
        for (Policy c : this.joinComponents) {
            if (c.isRuntimeRepresentable()) continue;
            return false;
        }
        return true;
    }

    public boolean equalsImpl(TypeObject o) {
        if (this == o) {
            return true;
        }
        if (o instanceof JoinPolicy_c) {
            JoinPolicy_c that = (JoinPolicy_c)o;
            return this.hashCode() == that.hashCode() && ((Object)this.joinComponents).equals(that.joinComponents);
        }
        if (o instanceof Policy) {
            return ((Object)this.joinComponents).equals(Collections.singleton(o));
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = new Integer(((Object)this.joinComponents).hashCode());
        }
        return this.hashCode;
    }

    public String toString(Set printedLabels) {
        String s = "";
        Iterator i = this.joinComponents.iterator();
        while (i.hasNext()) {
            Policy c = (Policy)i.next();
            s = s + c.toString(printedLabels);
            if (!i.hasNext()) continue;
            s = s + "; ";
        }
        return s;
    }

    protected boolean leq_(Policy p, LabelEnv env, LabelEnv.SearchState state) {
        for (Policy pi : this.joinComponents) {
            if (env.leq(pi, p, state)) continue;
            return false;
        }
        return true;
    }

    public Collection joinComponents() {
        return Collections.unmodifiableCollection(this.joinComponents);
    }

    protected Policy simplifyImpl() {
        if (this.joinComponents.isEmpty()) {
            return this;
        }
        if (this.joinComponents.size() == 1) {
            return ((Policy)this.joinComponents.iterator().next()).simplify();
        }
        Set comps = JoinPolicy_c.flatten(this.joinComponents);
        LinkedHashSet<Policy> needed = new LinkedHashSet<Policy>();
        JifTypeSystem jts = (JifTypeSystem)this.ts;
        Iterator i = comps.iterator();
        while (i.hasNext()) {
            Policy ci = ((Policy)i.next()).simplify();
            boolean subsumed = false;
            if (ci.hasVariables() || ci.hasWritersToReaders()) {
                needed.add(ci);
                continue;
            }
            Iterator j = needed.iterator();
            while (j.hasNext()) {
                Policy cj = (Policy)j.next();
                if (cj.hasVariables() || cj.hasWritersToReaders()) continue;
                if (jts.leq(ci, cj)) {
                    subsumed = true;
                    break;
                }
                if (!jts.leq(cj, ci)) continue;
                j.remove();
            }
            if (subsumed) continue;
            needed.add(ci);
        }
        if (((Object)needed).equals(this.joinComponents)) {
            return this;
        }
        if (needed.size() == 1) {
            return (Policy)needed.iterator().next();
        }
        return this.constructJoinPolicy(needed, this.position);
    }

    protected abstract Policy constructJoinPolicy(Set var1, Position var2);

    private static Set flatten(Set comps) {
        boolean needFlattening = false;
        for (Policy p : comps) {
            if (!(p instanceof JoinPolicy_c)) continue;
            needFlattening = true;
            break;
        }
        if (!needFlattening) {
            return comps;
        }
        LinkedHashSet<Policy> c = new LinkedHashSet<Policy>();
        for (Policy p : comps) {
            if (p.isTop()) {
                return Collections.singleton(p);
            }
            if (p instanceof JoinPolicy_c) {
                Collection lComps = ((JoinPolicy_c)p).joinComponents();
                c.addAll(lComps);
                continue;
            }
            c.add(p);
        }
        return c;
    }

    public List throwTypes(TypeSystem ts) {
        ArrayList throwTypes = new ArrayList();
        for (Policy L : this.joinComponents) {
            throwTypes.addAll(L.throwTypes(ts));
        }
        return throwTypes;
    }

    public Policy subst(LabelSubstitution substitution) throws SemanticException {
        if (this.joinComponents.isEmpty()) {
            return substitution.substPolicy(this).simplify();
        }
        boolean changed = false;
        LinkedHashSet<Policy> s = new LinkedHashSet<Policy>();
        for (Policy c : this.joinComponents) {
            Policy newc = c.subst(substitution);
            if (newc != c) {
                changed = true;
            }
            s.add(newc);
        }
        if (!changed) {
            return substitution.substPolicy(this).simplify();
        }
        Policy newJoinPolicy = this.constructJoinPolicy(JoinPolicy_c.flatten(s), this.position);
        return substitution.substPolicy(newJoinPolicy).simplify();
    }

    public boolean hasWritersToReaders() {
        for (Policy c : this.joinComponents) {
            if (!c.hasWritersToReaders()) continue;
            return true;
        }
        return false;
    }

    public boolean hasVariables() {
        for (Policy c : this.joinComponents) {
            if (!c.hasVariables()) continue;
            return true;
        }
        return false;
    }

    public PathMap labelCheck(JifContext A, LabelChecker lc) {
        JifTypeSystem ts = (JifTypeSystem)A.typeSystem();
        PathMap X = ts.pathMap().N(A.pc()).NV(A.pc());
        if (this.joinComponents.isEmpty()) {
            return X;
        }
        A = (JifContext)A.pushBlock();
        Iterator i = this.joinComponents.iterator();
        while (i.hasNext()) {
            A.setPc(X.N(), lc);
            Policy c = (Policy)i.next();
            PathMap Xc = c.labelCheck(A, lc);
            X = X.join(Xc);
        }
        return X;
    }

    public boolean isTop() {
        for (Policy c : this.joinComponents) {
            if (!c.isTop()) continue;
            return true;
        }
        return false;
    }

    public boolean isBottom() {
        for (Policy c : this.joinComponents) {
            if (c.isBottom()) continue;
            return false;
        }
        return true;
    }
}

