/*
 * Decompiled with CFR 0.152.
 */
package jif.types.label;

import java.util.List;
import java.util.Set;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.PathMap;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.IntegPolicy;
import jif.types.label.Label;
import jif.types.label.Policy;
import jif.types.label.Policy_c;
import jif.visit.LabelChecker;
import polyglot.types.SemanticException;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.Position;

public class IntegProjectionPolicy_c
extends Policy_c
implements IntegPolicy {
    private final Label label;

    public IntegProjectionPolicy_c(Label label, JifTypeSystem ts, Position pos) {
        super(ts, pos);
        this.label = label;
    }

    public Label label() {
        return this.label;
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isCanonical() {
        return this.label.isCanonical();
    }

    public boolean isRuntimeRepresentable() {
        return this.label.isRuntimeRepresentable();
    }

    protected Policy simplifyImpl() {
        return this;
    }

    public boolean equalsImpl(TypeObject o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IntegProjectionPolicy_c) {
            IntegProjectionPolicy_c that = (IntegProjectionPolicy_c)o;
            return this.label == that.label || this.label != null && this.label.equals(that.label);
        }
        return false;
    }

    public int hashCode() {
        return this.label.hashCode();
    }

    public boolean leq_(IntegPolicy p, LabelEnv env, LabelEnv.SearchState state) {
        if (p instanceof IntegProjectionPolicy_c) {
            return env.leq(this.label(), ((IntegProjectionPolicy_c)p).label(), state);
        }
        if (p.isTopIntegrity()) {
            return true;
        }
        Label ub = env.findUpperBound(this.label);
        return env.leq(ub.integProjection(), p, state);
    }

    public String toString(Set printedLabels) {
        return "I(" + this.label.componentString(printedLabels) + ")";
    }

    public List throwTypes(TypeSystem ts) {
        return this.label.throwTypes(ts);
    }

    public Policy subst(LabelSubstitution substitution) throws SemanticException {
        Label newLabel = this.label.subst(substitution);
        if (newLabel == this.label) {
            return substitution.substPolicy(this).simplify();
        }
        JifTypeSystem ts = (JifTypeSystem)this.typeSystem();
        IntegPolicy newPolicy = ts.integProjection(this.label());
        return substitution.substPolicy(newPolicy).simplify();
    }

    public PathMap labelCheck(JifContext A, LabelChecker lc) {
        return this.label.labelCheck(A, lc);
    }

    public boolean isBottomIntegrity() {
        return this.label.isBottom();
    }

    public boolean isTopIntegrity() {
        return this.label.isTop();
    }

    public boolean isTop() {
        return this.isTopIntegrity();
    }

    public boolean isBottom() {
        return this.isBottomIntegrity();
    }

    public boolean hasWritersToReaders() {
        return this.label.hasWritersToReaders();
    }

    public boolean hasVariables() {
        return this.label.hasVariables();
    }

    public IntegPolicy meet(IntegPolicy p) {
        JifTypeSystem ts = (JifTypeSystem)this.ts;
        return ts.meet(this, p);
    }

    public IntegPolicy join(IntegPolicy p) {
        JifTypeSystem ts = (JifTypeSystem)this.ts;
        return ts.join(this, p);
    }
}

