/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import jif.ast.JifProcedureDecl;
import jif.types.DefaultSignature;
import jif.types.JifProcedureInstance;
import jif.types.JifTypeSystem;
import jif.types.label.ArgLabel;
import jif.types.label.Label;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.ProcedureDecl;
import polyglot.ast.TypeNode;
import polyglot.types.Type;
import polyglot.util.Position;

public class VarSignature
implements DefaultSignature {
    JifTypeSystem ts;

    public VarSignature(JifTypeSystem ts) {
        this.ts = ts;
    }

    public Label defaultPCBound(Position pos, String methodName) {
        return this.ts.freshLabelVariable(pos, methodName, "start label for the method " + methodName);
    }

    public Label defaultArgBound(Formal f) {
        String argName = f.name();
        return this.ts.freshLabelVariable(f.position(), argName, "upper bound for the formal argument " + argName);
    }

    public Label defaultReturnLabel(ProcedureDecl pd) {
        Label Lr = this.ts.noComponentsLabel();
        for (TypeNode tn : pd.throwTypes()) {
            Label excLabel = this.ts.labelOfType(tn.type(), this.ts.bottomLabel());
            Lr = this.ts.join(Lr, excLabel);
        }
        return Lr;
    }

    public Label defaultReturnValueLabel(ProcedureDecl pd) {
        JifProcedureDecl jpd = (JifProcedureDecl)pd;
        Label Lrv = jpd.returnLabel() != null ? jpd.returnLabel().label() : this.defaultReturnLabel(pd);
        JifProcedureInstance pi = (JifProcedureInstance)pd.procedureInstance();
        for (Type t : pi.formalTypes()) {
            ArgLabel a = (ArgLabel)this.ts.labelOfType(t);
            Lrv = this.ts.join(Lrv, a);
        }
        return Lrv;
    }

    public Label defaultFieldLabel(FieldDecl fd) {
        return this.ts.bottomLabel();
    }

    public Label defaultArrayBaseLabel(Type baseType) {
        if (baseType.isArray() && this.ts.isLabeled(baseType.toArray().ultimateBase())) {
            return this.ts.labelOfType(baseType.toArray().ultimateBase());
        }
        return this.ts.noComponentsLabel();
    }
}

