/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.util.Collection;
import java.util.LinkedList;
import jif.types.Constraint;
import jif.types.ConstraintMessage;
import jif.types.PrincipalEquation;
import jif.types.hierarchy.LabelEnv;
import jif.types.principal.ConjunctivePrincipal;
import jif.types.principal.DisjunctivePrincipal;
import jif.types.principal.Principal;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class PrincipalConstraint
extends Constraint {
    public static final Constraint.Kind EQUIV = new Constraint.Kind(" equiv ");
    public static final Constraint.Kind ACTSFOR = new Constraint.Kind(" actsfor ");

    public PrincipalConstraint(Principal lhs, Constraint.Kind kind, Principal rhs, LabelEnv env, Position pos, ConstraintMessage msg, boolean report) {
        super(lhs, kind, rhs, env, pos, msg, report);
    }

    public Principal lhsPrincipal() {
        return (Principal)this.lhs;
    }

    public Principal rhsPrincipal() {
        return (Principal)this.rhs;
    }

    public Collection getEquations() {
        LinkedList eqns = new LinkedList();
        if (this.kind == ACTSFOR) {
            this.addActsforEqns(eqns, this.lhsPrincipal(), this.rhsPrincipal());
        } else if (this.kind == EQUIV) {
            this.addActsforEqns(eqns, this.lhsPrincipal(), this.rhsPrincipal());
            this.addActsforEqns(eqns, this.rhsPrincipal(), this.lhsPrincipal());
        } else {
            throw new InternalCompilerError("Inappropriate kind of equation: " + (Object)((Object)this.kind));
        }
        return eqns;
    }

    protected void addActsforEqns(Collection eqns, Principal left, Principal right) {
        left = left.simplify();
        right = right.simplify();
        if (left instanceof DisjunctivePrincipal) {
            for (Principal jc : ((DisjunctivePrincipal)left).disjuncts()) {
                this.addActsforEqns(eqns, jc, right);
            }
        } else if (right instanceof ConjunctivePrincipal) {
            for (Principal mc : ((ConjunctivePrincipal)right).conjuncts()) {
                this.addActsforEqns(eqns, left, mc);
            }
        } else {
            PrincipalEquation eqn = new PrincipalEquation(left, right, this);
            eqns.add(eqn);
        }
    }

    public boolean hasVariables() {
        return this.lhsPrincipal().hasVariables() || this.rhsPrincipal().hasVariables();
    }
}

