/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import jif.extension.LabelTypeCheckUtil;
import jif.types.Constraint;
import jif.types.ConstraintMessage;
import jif.types.JifTypeSystem;
import jif.types.LabelEquation;
import jif.types.NamedLabel;
import jif.types.VarMap;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.JoinLabel;
import jif.types.label.Label;
import jif.types.label.MeetLabel;
import jif.types.label.WritersToReadersLabel;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class LabelConstraint
extends Constraint {
    public static final Constraint.Kind EQUAL = new Constraint.Kind(" == ");
    public static final Constraint.Kind LEQ = new Constraint.Kind(" <= ");
    protected NamedLabel namedLHS;
    protected NamedLabel namedRHS;

    public LabelConstraint(NamedLabel lhs, Constraint.Kind kind, NamedLabel rhs, LabelEnv env, Position pos, ConstraintMessage msg, boolean report) {
        super(lhs.label(), kind, rhs.label(), env, pos, msg, report);
        this.namedLHS = lhs;
        this.namedRHS = rhs;
    }

    public Label lhsLabel() {
        return (Label)this.lhs;
    }

    public Label rhsLabel() {
        return (Label)this.rhs;
    }

    public NamedLabel namedLhs() {
        return this.namedLHS;
    }

    public NamedLabel namedRhs() {
        return this.namedRHS;
    }

    protected Map namedLabels() {
        LinkedHashMap ne = new LinkedHashMap();
        if (this.namedLHS != null) {
            ne.putAll(this.namedLHS.nameToLabels);
        }
        if (this.namedRHS != null) {
            ne.putAll(this.namedRHS.nameToLabels);
        }
        return ne;
    }

    protected Map namedDescrips() {
        LinkedHashMap ne = new LinkedHashMap();
        if (this.namedLHS != null) {
            ne.putAll(this.namedLHS.nameToDescrip);
        }
        if (this.namedRHS != null) {
            ne.putAll(this.namedRHS.nameToDescrip);
        }
        return ne;
    }

    public Map definitions(VarMap bounds) {
        LinkedHashMap defns = new LinkedHashMap();
        LinkedHashSet<Label> labelComponents = new LinkedHashSet<Label>();
        Map namedLabels = this.namedLabels();
        Map namedDescrips = this.namedDescrips();
        LabelTypeCheckUtil ltcu = ((JifTypeSystem)this.lhs.typeSystem()).labelTypeCheckUtil();
        for (String s : namedLabels.keySet()) {
            ArrayList<Object> l = new ArrayList<Object>(2);
            defns.put(s, l);
            if (namedDescrips.get(s) != null) {
                l.add(namedDescrips.get(s));
            }
            Label bound = bounds.applyTo((Label)namedLabels.get(s));
            l.add(bound.toString());
            Collection components = ltcu.labelComponents(bound);
            for (Label lb : components) {
                labelComponents.add(lb);
            }
        }
        Label bound = bounds.applyTo(this.lhsLabel());
        Collection components = ltcu.labelComponents(bound);
        for (Label lb : components) {
            labelComponents.add(lb);
        }
        bound = bounds.applyTo(this.rhsLabel());
        components = ltcu.labelComponents(bound);
        for (Label l : components) {
            labelComponents.add(l);
        }
        for (Label l : labelComponents) {
            if (l.description() == null) continue;
            String s = l.componentString();
            if (s.length() == 0) {
                s = l.toString();
            }
            ArrayList<String> list = new ArrayList<String>(2);
            list.add(l.description());
            defns.put(s, list);
            if (!(l instanceof WritersToReadersLabel)) continue;
            list.add(this.env.triggerTransforms(l).toString());
        }
        defns.putAll(this.env.definitions(bounds, labelComponents));
        return defns;
    }

    public Collection getEquations() {
        LinkedList eqns = new LinkedList();
        if (this.kind == LEQ) {
            this.addLEQEqns(eqns, this.lhsLabel(), this.rhsLabel());
        } else if (this.kind == EQUAL) {
            this.addLEQEqns(eqns, this.lhsLabel(), this.rhsLabel());
            this.addLEQEqns(eqns, this.rhsLabel(), this.lhsLabel());
        } else {
            throw new InternalCompilerError("Inappropriate kind of equation: " + (Object)((Object)this.kind));
        }
        return eqns;
    }

    protected void addLEQEqns(Collection eqns, Label left, Label right) {
        left = left.simplify();
        right = right.simplify();
        if (left instanceof JoinLabel) {
            for (Label jc : ((JoinLabel)left).joinComponents()) {
                this.addLEQEqns(eqns, jc, right);
            }
        } else if (right instanceof MeetLabel) {
            for (Label mc : ((MeetLabel)right).meetComponents()) {
                this.addLEQEqns(eqns, left, mc);
            }
        } else {
            LabelEquation eqn = new LabelEquation(left, right, this);
            eqns.add(eqn);
        }
    }

    public boolean hasVariables() {
        return this.lhsLabel().hasVariables() || this.rhsLabel().hasVariables();
    }
}

