/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jif.extension.LabelTypeCheckUtil;
import jif.translate.DynamicLabelToJavaExpr_c;
import jif.translate.DynamicPrincipalToJavaExpr_c;
import jif.translate.JoinLabelToJavaExpr_c;
import jif.translate.LabelToJavaExpr;
import jif.translate.MeetLabelToJavaExpr_c;
import jif.translate.PairLabelToJavaExpr_c;
import jif.translate.PrincipalToJavaExpr;
import jif.types.ActsForConstraint;
import jif.types.ActsForConstraint_c;
import jif.types.AuthConstraint;
import jif.types.AuthConstraint_c;
import jif.types.AutoEndorseConstraint;
import jif.types.AutoEndorseConstraint_c;
import jif.types.CallerConstraint;
import jif.types.CallerConstraint_c;
import jif.types.ConstArrayType;
import jif.types.ConstArrayType_c;
import jif.types.DefaultSignature;
import jif.types.ExceptionPath;
import jif.types.ExceptionPath_c;
import jif.types.FixedSignature;
import jif.types.GotoPath_c;
import jif.types.JifClassType;
import jif.types.JifConstructorInstance;
import jif.types.JifConstructorInstance_c;
import jif.types.JifContext_c;
import jif.types.JifFieldInstance;
import jif.types.JifFieldInstance_c;
import jif.types.JifLazyClassInitializer_c;
import jif.types.JifLocalInstance;
import jif.types.JifLocalInstance_c;
import jif.types.JifMethodInstance;
import jif.types.JifMethodInstance_c;
import jif.types.JifMuPClass_c;
import jif.types.JifParsedPolyType;
import jif.types.JifParsedPolyType_c;
import jif.types.JifPolyType;
import jif.types.JifProcedureInstance;
import jif.types.JifSubstType;
import jif.types.JifSubst_c;
import jif.types.JifTypeSystem;
import jif.types.LabelLeAssertion;
import jif.types.LabelLeAssertion_c;
import jif.types.LabeledType;
import jif.types.LabeledType_c;
import jif.types.Param;
import jif.types.ParamInstance;
import jif.types.ParamInstance_c;
import jif.types.Path;
import jif.types.PathMap;
import jif.types.PrincipalInstance;
import jif.types.PrincipalInstance_c;
import jif.types.Solver;
import jif.types.SolverGLB;
import jif.types.UnknownParam_c;
import jif.types.hierarchy.LabelEnv;
import jif.types.hierarchy.LabelEnv_c;
import jif.types.label.AccessPath;
import jif.types.label.AccessPathConstant;
import jif.types.label.ArgLabel;
import jif.types.label.ArgLabel_c;
import jif.types.label.ConfPolicy;
import jif.types.label.ConfProjectionPolicy_c;
import jif.types.label.CovariantParamLabel;
import jif.types.label.CovariantParamLabel_c;
import jif.types.label.DynamicLabel;
import jif.types.label.DynamicLabel_c;
import jif.types.label.IntegPolicy;
import jif.types.label.IntegProjectionPolicy_c;
import jif.types.label.JoinConfPolicy_c;
import jif.types.label.JoinIntegPolicy_c;
import jif.types.label.JoinLabel;
import jif.types.label.JoinLabel_c;
import jif.types.label.Label;
import jif.types.label.MeetConfPolicy_c;
import jif.types.label.MeetIntegPolicy_c;
import jif.types.label.MeetLabel;
import jif.types.label.MeetLabel_c;
import jif.types.label.NotTaken;
import jif.types.label.NotTaken_c;
import jif.types.label.PairLabel;
import jif.types.label.PairLabel_c;
import jif.types.label.ParamLabel;
import jif.types.label.ParamLabel_c;
import jif.types.label.Policy;
import jif.types.label.ReaderPolicy;
import jif.types.label.ReaderPolicy_c;
import jif.types.label.ThisLabel;
import jif.types.label.ThisLabel_c;
import jif.types.label.UnknownLabel;
import jif.types.label.UnknownLabel_c;
import jif.types.label.VarLabel;
import jif.types.label.VarLabel_c;
import jif.types.label.WriterPolicy;
import jif.types.label.WriterPolicy_c;
import jif.types.label.WritersToReadersLabel;
import jif.types.label.WritersToReadersLabel_c;
import jif.types.principal.BottomPrincipal;
import jif.types.principal.BottomPrincipal_c;
import jif.types.principal.ConjunctivePrincipal;
import jif.types.principal.ConjunctivePrincipal_c;
import jif.types.principal.DisjunctivePrincipal;
import jif.types.principal.DisjunctivePrincipal_c;
import jif.types.principal.DynamicPrincipal;
import jif.types.principal.DynamicPrincipal_c;
import jif.types.principal.ExternalPrincipal;
import jif.types.principal.ExternalPrincipal_c;
import jif.types.principal.ParamPrincipal;
import jif.types.principal.ParamPrincipal_c;
import jif.types.principal.Principal;
import jif.types.principal.TopPrincipal;
import jif.types.principal.TopPrincipal_c;
import jif.types.principal.UnknownPrincipal;
import jif.types.principal.UnknownPrincipal_c;
import jif.types.principal.VarPrincipal;
import jif.types.principal.VarPrincipal_c;
import polyglot.ast.Branch;
import polyglot.ext.param.types.MuPClass;
import polyglot.ext.param.types.PClass;
import polyglot.ext.param.types.ParamTypeSystem_c;
import polyglot.ext.param.types.Subst;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Source;
import polyglot.types.ArrayType;
import polyglot.types.ClassType;
import polyglot.types.CodeInstance;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.InitializerInstance;
import polyglot.types.LazyClassInitializer;
import polyglot.types.LocalInstance;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.Package;
import polyglot.types.ParsedClassType;
import polyglot.types.PrimitiveType;
import polyglot.types.PrimitiveType_c;
import polyglot.types.ReferenceType;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.TableResolver;
import polyglot.types.TopLevelResolver;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.types.UnknownQualifier;
import polyglot.types.UnknownType;
import polyglot.types.VarInstance;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class JifTypeSystem_c
extends ParamTypeSystem_c
implements JifTypeSystem {
    protected final TypeSystem jlts;
    private final LabelEnv emptyLabelEnv = this.createEmptyLabelEnv();
    private final DefaultSignature ds;
    private static final PrimitiveType.Kind PRINCIPAL_KIND = new PrimitiveType.Kind("principal");
    private static final PrimitiveType.Kind LABEL_KIND = new PrimitiveType.Kind("label");
    protected PrimitiveType PRINCIPAL_;
    protected PrimitiveType LABEL_;
    protected Type PRINCIPAL_CLASS_ = null;
    private Label top = null;
    private Label bottom = null;
    private Label noComponents = null;
    private Label notTaken = null;
    static String JIF_SIG_OF_JAVA_MARKER = "__JIF_SIG_OF_JAVA_CLASS$20030619";
    static String JIF_PARAMS_RUNTIME_MARKER = "__JIF_PARAMS_RUNTIME_REPRESENTED$20051007";
    static String JIF_SAFE_CONSTRUCTOR_MARKER = "__JIF_SAFE_CONSTRUCTORS$20050907";
    protected LabelTypeCheckUtil ltcu = null;

    public JifTypeSystem_c(TypeSystem jlts) {
        this.jlts = jlts;
        this.ds = new FixedSignature(this);
    }

    public Solver createSolver(String solverName) {
        return new SolverGLB(this, this.extInfo.compiler(), solverName);
    }

    protected LabelEnv createEmptyLabelEnv() {
        return new LabelEnv_c(this, false);
    }

    public LabelEnv createLabelEnv() {
        return new LabelEnv_c(this, true);
    }

    public MuPClass mutablePClass(Position pos) {
        return new JifMuPClass_c(this, pos);
    }

    public LazyClassInitializer defaultClassInitializer() {
        return new JifLazyClassInitializer_c((TypeSystem)this);
    }

    public void initialize(TopLevelResolver loadedResolver, ExtensionInfo extInfo) throws SemanticException {
        super.initialize(loadedResolver, extInfo);
        this.PRINCIPAL_ = new PrimitiveType_c((TypeSystem)this, PRINCIPAL_KIND);
        this.LABEL_ = new PrimitiveType_c((TypeSystem)this, LABEL_KIND);
    }

    public UnknownType unknownType(Position pos) {
        UnknownType t = super.unknownType(pos);
        return t;
    }

    public UnknownQualifier unknownQualifier(Position pos) {
        UnknownQualifier t = super.unknownQualifier(pos);
        return t;
    }

    public Package packageForName(Package prefix, String name) throws SemanticException {
        Package p = super.packageForName(prefix, name);
        return p;
    }

    public String PrincipalClassName() {
        return "jif.lang.Principal";
    }

    public String PrincipalUtilClassName() {
        return "jif.lang.PrincipalUtil";
    }

    public String LabelClassName() {
        return "jif.lang.Label";
    }

    public String LabelUtilClassName() {
        return "jif.lang.LabelUtil";
    }

    public String RuntimePackageName() {
        return "jif.runtime";
    }

    public PrimitiveType Principal() {
        return this.PRINCIPAL_;
    }

    public Type PrincipalClass() {
        if (this.PRINCIPAL_CLASS_ == null) {
            try {
                this.PRINCIPAL_CLASS_ = this.typeForName(this.PrincipalClassName());
            }
            catch (SemanticException e) {
                throw new InternalCompilerError("Cannot find Jif class " + this.PrincipalClassName(), (Throwable)e);
            }
        }
        return this.PRINCIPAL_CLASS_;
    }

    public PrimitiveType Label() {
        return this.LABEL_;
    }

    public Context createContext() {
        return new JifContext_c(this, this.jlts);
    }

    public ConstArrayType constArrayOf(Type type) {
        return this.constArrayOf(type.position(), type);
    }

    public ConstArrayType constArrayOf(Position pos, Type type) {
        return this.constArrayOf(pos, type, false);
    }

    public ConstArrayType constArrayOf(Position pos, Type type, boolean castableToNonConst) {
        return new ConstArrayType_c(this, pos, type, true, castableToNonConst);
    }

    public ConstArrayType constArrayOf(Type type, int dims) {
        return this.constArrayOf(null, type, dims);
    }

    public ConstArrayType constArrayOf(Position pos, Type type, int dims) {
        return this.constArrayOf(pos, type, dims, false);
    }

    public ConstArrayType constArrayOf(Position pos, Type type, int dims, boolean castableToNonConst) {
        return this.constArrayOf(pos, type, dims, castableToNonConst, false);
    }

    public ConstArrayType constArrayOf(Position pos, Type type, int dims, boolean castableToNonConst, boolean recurseIntoBaseType) {
        if (recurseIntoBaseType && type.isArray()) {
            ArrayType baseArray = type.toArray();
            type = this.constArrayOf(pos, baseArray.base(), 1, castableToNonConst, recurseIntoBaseType);
        }
        if (dims > 1) {
            return this.constArrayOf(pos, (Type)this.constArrayOf(pos, (Type)type, dims - 1, castableToNonConst));
        }
        if (dims == 1) {
            return this.constArrayOf(pos, (Type)type, castableToNonConst);
        }
        throw new InternalCompilerError("Must call constArrayOf(type, dims) with dims > 0");
    }

    protected ArrayType arrayType(Position pos, Type type) {
        if (!this.isLabeled(type)) {
            type = this.labeledType(pos, type, this.defaultSignature().defaultArrayBaseLabel(type));
        }
        return new ConstArrayType_c(this, pos, type, false);
    }

    public InitializerInstance initializerInstance(Position pos, ClassType container, Flags flags) {
        InitializerInstance ii = super.initializerInstance(pos, container, flags);
        return ii;
    }

    public FieldInstance fieldInstance(Position pos, ReferenceType container, Flags flags, Type type, String name) {
        JifFieldInstance_c fi = new JifFieldInstance_c(this, pos, container, flags, type, name);
        return fi;
    }

    public LocalInstance localInstance(Position pos, Flags flags, Type type, String name) {
        JifLocalInstance_c li = new JifLocalInstance_c(this, pos, flags, type, name);
        return li;
    }

    public ConstructorInstance constructorInstance(Position pos, ClassType container, Flags flags, List formalTypes, List excTypes) {
        return this.jifConstructorInstance(pos, container, flags, this.unknownLabel(pos), false, this.unknownLabel(pos), false, formalTypes, Collections.EMPTY_LIST, excTypes, Collections.EMPTY_LIST);
    }

    public JifConstructorInstance jifConstructorInstance(Position pos, ClassType container, Flags flags, Label startLabel, boolean isDefaultStartLabel, Label returnLabel, boolean isDefaultReturnLabel, List formalTypes, List formalArgLabels, List excTypes, List constraints) {
        JifConstructorInstance_c ci = new JifConstructorInstance_c(this, pos, container, flags, startLabel, isDefaultStartLabel, returnLabel, isDefaultReturnLabel, formalTypes, formalArgLabels, excTypes, constraints);
        return ci;
    }

    public MethodInstance methodInstance(Position pos, ReferenceType container, Flags flags, Type returnType, String name, List formalTypes, List excTypes) {
        return this.jifMethodInstance(pos, container, flags, returnType, name, this.unknownLabel(pos), false, formalTypes, Collections.EMPTY_LIST, this.unknownLabel(pos), false, excTypes, Collections.EMPTY_LIST);
    }

    public JifMethodInstance jifMethodInstance(Position pos, ReferenceType container, Flags flags, Type returnType, String name, Label startLabel, boolean isDefaultStartLabel, List formalTypes, List formalArgLabels, Label endLabel, boolean isDefaultEndLabel, List excTypes, List constraints) {
        JifMethodInstance_c mi = new JifMethodInstance_c(this, pos, container, flags, returnType, name, startLabel, isDefaultStartLabel, formalTypes, formalArgLabels, endLabel, isDefaultEndLabel, excTypes, constraints);
        return mi;
    }

    public ParamInstance paramInstance(Position pos, JifClassType container, ParamInstance.Kind kind, String name) {
        ParamInstance_c pi = new ParamInstance_c(this, pos, container, kind, name);
        return pi;
    }

    public PrincipalInstance principalInstance(Position pos, ExternalPrincipal principal) {
        PrincipalInstance_c pi = new PrincipalInstance_c(this, pos, principal);
        return pi;
    }

    public boolean descendsFrom(Type child, Type ancestor) {
        return super.descendsFrom(this.strip(child), this.strip(ancestor));
    }

    public boolean isSubtype(Type child, Type ancestor) {
        return super.isSubtype(this.strip(child), this.strip(ancestor));
    }

    public boolean isCastValid(Type fromType, Type toType) {
        Type strpFromType = this.strip(fromType);
        Type strpToType = this.strip(toType);
        if (this.Principal().equals(strpFromType) && this.isCastValid(this.PrincipalClass(), toType)) {
            return true;
        }
        if (this.Principal().equals(strpToType) && this.isSubtype(strpFromType, this.PrincipalClass())) {
            return true;
        }
        return super.isCastValid(strpFromType, strpToType);
    }

    public boolean isImplicitCastValid(Type fromType, Type toType) {
        Type strpFromType = this.strip(fromType);
        Type strpToType = this.strip(toType);
        if (this.Principal().equals(strpFromType) && this.PrincipalClass().equals(strpToType)) {
            return true;
        }
        if (this.Principal().equals(strpToType) && this.isSubtype(strpFromType, this.PrincipalClass())) {
            return true;
        }
        return super.isImplicitCastValid(strpFromType, strpToType);
    }

    public Type staticTarget(Type t) {
        JifParsedPolyType jppt;
        if (t instanceof JifParsedPolyType && (jppt = (JifParsedPolyType)t).params().size() > 0) {
            return jppt.instantiatedFrom().clazz();
        }
        return super.staticTarget(t);
    }

    public boolean equalsNoStrip(TypeObject t1, TypeObject t2) {
        return super.equals(t1, t2);
    }

    public boolean equalsStrip(TypeObject t1, TypeObject t2) {
        if (t1 instanceof Type) {
            t1 = this.strip((Type)t1);
        }
        if (t2 instanceof Type) {
            t2 = this.strip((Type)t2);
        }
        return super.equals(t1, t2);
    }

    public boolean equals(TypeObject t1, TypeObject t2) {
        return this.equalsStrip(t1, t2);
    }

    public boolean typeEquals(Type t1, Type t2) {
        return this.equals((TypeObject)t1, (TypeObject)t2);
    }

    protected Type leastCommonAncestorSubtype(Type subtype, Type supertype) {
        while (subtype != null && !this.equals((TypeObject)subtype, (TypeObject)supertype)) {
            subtype = subtype.toClass().superType();
        }
        Iterator iter1 = ((JifClassType)subtype).actuals().iterator();
        Iterator iter2 = ((JifClassType)supertype).actuals().iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            Param p1 = (Param)iter1.next();
            Param p2 = (Param)iter2.next();
            if (p1 instanceof Principal && p2 instanceof Principal && !((Principal)p1).equals(p2)) {
                return null;
            }
            if (!(p1 instanceof Label && p2 instanceof Label ? !this.leq((Label)p1, (Label)p2) || !this.leq((Label)p2, (Label)p1) : !p1.equals(p2))) continue;
            return null;
        }
        if (iter1.hasNext() || iter2.hasNext()) {
            return null;
        }
        return supertype;
    }

    public Type leastCommonAncestor(Type type1, Type type2) throws SemanticException {
        this.assert_((TypeObject)type1);
        this.assert_((TypeObject)type2);
        type1 = this.unlabel(type1);
        type2 = this.unlabel(type2);
        if (type1.isNumeric() || type2.isNumeric() || type1.isNull() || type2.isNull()) {
            return super.leastCommonAncestor(this.strip(type1), this.strip(type2));
        }
        if (type1.isArray() && type2.isArray()) {
            Type base1 = type1.toArray().base();
            Type base2 = type2.toArray().base();
            Label L1 = this.labelOfType(base1);
            Label L2 = this.labelOfType(base2);
            Label arrL = null;
            if (L1 instanceof VarLabel) {
                arrL = L2;
            } else if (L2 instanceof VarLabel) {
                arrL = L1;
            } else if (this.leq(L1, L2) && this.leq(L2, L1)) {
                arrL = L1;
            }
            if (arrL != null) {
                return this.arrayOf(this.labeledType(base1.position(), this.leastCommonAncestor(this.unlabel(base1), this.unlabel(base2)), arrL));
            }
            return this.Object();
        }
        if (type1 == type2) {
            return type1;
        }
        if (type1.isReference() && type2.isReference()) {
            Type t2;
            Type t;
            if (type1.isClass() && type1.toClass().flags().isInterface()) {
                return this.Object();
            }
            if (type2.isClass() && type2.toClass().flags().isInterface()) {
                return this.Object();
            }
            if (this.equals((TypeObject)type1, (TypeObject)this.Object())) {
                return type1;
            }
            if (this.equals((TypeObject)type2, (TypeObject)this.Object())) {
                return type2;
            }
            if (!(type1 instanceof JifClassType) || !(type2 instanceof JifClassType)) {
                return this.Object();
            }
            if (this.isSubtype(type1, type2) && (t = this.leastCommonAncestorSubtype(type1, type2)) != null) {
                return t;
            }
            if (this.isSubtype(type2, type1) && (t = this.leastCommonAncestorSubtype(type2, type1)) != null) {
                return t;
            }
            Type t1 = this.leastCommonAncestor(type1.toReference().superType(), type2);
            if (this.equals((TypeObject)t1, (TypeObject)(t2 = this.leastCommonAncestor(type2.toReference().superType(), type1)))) {
                return t1;
            }
            return this.Object();
        }
        throw new SemanticException("No least common ancestor found for types \"" + type1 + "\" and \"" + type2 + "\".");
    }

    public boolean numericConversionValid(Type t, Object value) {
        return super.numericConversionValid(this.strip(t), value);
    }

    public Resolver bodyContextResolver(ClassType type, Resolver outer) {
        return outer;
    }

    public Resolver classContextResolver(ClassType type) {
        return new TableResolver();
    }

    public ParsedClassType createClassType(LazyClassInitializer init, Source fromSource) {
        if (!init.fromClassFile()) {
            return new JifParsedPolyType_c(this, init, fromSource);
        }
        return super.createClassType(init, fromSource);
    }

    public List defaultPackageImports() {
        ArrayList<String> l = new ArrayList<String>(2);
        l.add("java.lang");
        l.add("jif.lang");
        return l;
    }

    public LabeledType labeledType(Position pos, Type type, Label label) {
        if (this.isLabeled(type)) {
            throw new InternalCompilerError("Trying to label a labeled type");
        }
        return new LabeledType_c(this, pos, type, label);
    }

    public PathMap pathMap() {
        return new PathMap(this);
    }

    public PathMap pathMap(Path path, Label L) {
        PathMap m = this.pathMap();
        return m.set(path, L);
    }

    public ExceptionPath exceptionPath(Type type) {
        return new ExceptionPath_c(this.unlabel(type));
    }

    public Path gotoPath(Branch.Kind kind, String target) {
        return new GotoPath_c(kind, target);
    }

    public Param unknownParam(Position pos) {
        return new UnknownParam_c(this, pos);
    }

    public ClassType nullInstantiate(Position pos, PClass pc) {
        if (pc.clazz() instanceof JifPolyType) {
            JifPolyType pt = (JifPolyType)pc.clazz();
            LinkedHashMap subst = new LinkedHashMap();
            Iterator i = pt.params().iterator();
            Iterator j = pt.actuals().iterator();
            while (i.hasNext() && j.hasNext()) {
                ParamInstance param = (ParamInstance)i.next();
                Object actual = j.next();
                subst.put(param, actual);
            }
            if (i.hasNext() || j.hasNext()) {
                throw new InternalCompilerError("Params and actuals had different lengths");
            }
            return (ClassType)this.subst((Type)pt, subst);
        }
        throw new InternalCompilerError("Cannot null instantiate \"" + pc + "\".");
    }

    public void checkInstantiation(Position pos, PClass t, List args) throws SemanticException {
        super.checkInstantiation(pos, t, args);
        Iterator i = args.iterator();
        Iterator j = ((JifPolyType)t.clazz()).params().iterator();
        while (i.hasNext() && j.hasNext()) {
            Param p = (Param)i.next();
            ParamInstance pi = (ParamInstance)j.next();
            if (pi.isLabel() && !(p instanceof Label)) {
                throw new SemanticException("Cannot use " + p + " as a label.", p.position());
            }
            if (!pi.isPrincipal() || p instanceof Principal) continue;
            throw new SemanticException("Cannot use " + p + " as a principal.", p.position());
        }
    }

    public ClassType uncheckedInstantiate(Position pos, PClass t, List actuals) {
        return super.uncheckedInstantiate(pos, t, actuals);
    }

    public Subst subst(Map substMap, Map cache) {
        return new JifSubst_c(this, substMap, cache);
    }

    public VarLabel freshLabelVariable(Position pos, String s, String description) {
        VarLabel_c t = new VarLabel_c(s, description, this, pos);
        return t;
    }

    public VarPrincipal freshPrincipalVariable(Position pos, String s, String description) {
        VarPrincipal_c t = new VarPrincipal_c(s, description, this, pos);
        return t;
    }

    public ParamPrincipal principalParam(Position pos, ParamInstance pi) {
        ParamPrincipal_c t = new ParamPrincipal_c(pi, this, pos);
        return t;
    }

    public DynamicPrincipal dynamicPrincipal(Position pos, AccessPath path) {
        DynamicPrincipal_c t = new DynamicPrincipal_c(path, this, pos, this.dynamicPrincipalTranslator());
        return t;
    }

    protected PrincipalToJavaExpr dynamicPrincipalTranslator() {
        return new DynamicPrincipalToJavaExpr_c();
    }

    public Principal pathToPrincipal(Position pos, AccessPath path) {
        if (path instanceof AccessPathConstant) {
            AccessPathConstant apc = (AccessPathConstant)path;
            if (!apc.isPrincipalConstant()) {
                throw new InternalCompilerError("Dynamic principal with a constant access path: " + apc);
            }
            return (Principal)apc.constantValue();
        }
        DynamicPrincipal_c t = new DynamicPrincipal_c(path, this, pos, this.dynamicPrincipalTranslator());
        return t;
    }

    public ExternalPrincipal externalPrincipal(Position pos, String name) {
        ExternalPrincipal_c t = new ExternalPrincipal_c(name, this, pos);
        return t;
    }

    public UnknownPrincipal unknownPrincipal(Position pos) {
        UnknownPrincipal_c t = new UnknownPrincipal_c(this, pos);
        return t;
    }

    public TopPrincipal topPrincipal(Position pos) {
        return new TopPrincipal_c(this, pos);
    }

    public BottomPrincipal bottomPrincipal(Position pos) {
        return new BottomPrincipal_c(this, pos);
    }

    public Principal conjunctivePrincipal(Position pos, Principal l, Principal r) {
        return this.conjunctivePrincipal(pos, CollectionUtil.list((Object)l, (Object)r));
    }

    public Principal conjunctivePrincipal(Position pos, Collection ps) {
        if (ps.isEmpty()) {
            return this.bottomPrincipal(pos);
        }
        if ((ps = this.flattenConjuncts(ps)).size() == 1) {
            return (Principal)ps.iterator().next();
        }
        return new ConjunctivePrincipal_c(ps, this, pos);
    }

    public Principal disjunctivePrincipal(Position pos, Principal l, Principal r) {
        return this.disjunctivePrincipal(pos, CollectionUtil.list((Object)l, (Object)r));
    }

    public Principal disjunctivePrincipal(Position pos, Collection ps) {
        if (ps.isEmpty()) {
            return this.topPrincipal(pos);
        }
        if ((ps = this.flattenDisjuncts(ps)).size() == 1) {
            return (Principal)ps.iterator().next();
        }
        return new DisjunctivePrincipal_c(ps, this, pos);
    }

    private Collection flattenConjuncts(Collection ps) {
        LinkedHashSet<Principal> newps = new LinkedHashSet<Principal>();
        for (Principal p : ps) {
            if (p instanceof ConjunctivePrincipal) {
                ConjunctivePrincipal cp = (ConjunctivePrincipal)p;
                newps.addAll(cp.conjuncts());
                continue;
            }
            newps.add(p);
        }
        LinkedHashSet<Principal> needed = new LinkedHashSet<Principal>();
        for (Principal p : newps) {
            boolean essential = true;
            for (Principal q : needed) {
                if (!this.emptyLabelEnv.actsFor(q, p)) continue;
                essential = false;
                break;
            }
            if (!essential) continue;
            needed.add(p);
        }
        return needed;
    }

    private Collection flattenDisjuncts(Collection ps) {
        LinkedHashSet<Principal> newps = new LinkedHashSet<Principal>();
        for (Principal p : ps) {
            if (p instanceof DisjunctivePrincipal) {
                DisjunctivePrincipal dp = (DisjunctivePrincipal)p;
                newps.addAll(dp.disjuncts());
                continue;
            }
            newps.add(p);
        }
        LinkedHashSet<Principal> needed = new LinkedHashSet<Principal>();
        for (Principal p : newps) {
            boolean essential = true;
            for (Principal q : needed) {
                if (!this.emptyLabelEnv.actsFor(p, q)) continue;
                essential = false;
                break;
            }
            if (!essential) continue;
            needed.add(p);
        }
        return needed;
    }

    public Label topLabel(Position pos) {
        return this.pairLabel(pos, this.topConfPolicy(pos), this.topIntegPolicy(pos));
    }

    public Label topLabel() {
        if (this.top == null) {
            this.top = this.topLabel(null);
        }
        return this.top;
    }

    public Label bottomLabel(Position pos) {
        return this.pairLabel(pos, this.bottomConfPolicy(pos), this.bottomIntegPolicy(pos));
    }

    public Label bottomLabel() {
        if (this.bottom == null) {
            this.bottom = this.bottomLabel(null);
        }
        return this.bottom;
    }

    public Label noComponentsLabel() {
        if (this.noComponents == null) {
            this.noComponents = this.noComponentsLabel(null);
        }
        return this.noComponents;
    }

    public Label noComponentsLabel(Position pos) {
        return this.pairLabel(pos, this.bottomConfPolicy(pos), this.topIntegPolicy(pos));
    }

    public Label notTaken(Position pos) {
        NotTaken_c t = new NotTaken_c(this, pos);
        return t;
    }

    public Label notTaken() {
        if (this.notTaken == null) {
            this.notTaken = this.notTaken(null);
        }
        return this.notTaken;
    }

    public CovariantParamLabel covariantLabel(Position pos, ParamInstance pi) {
        CovariantParamLabel_c t = new CovariantParamLabel_c(pi, this, pos);
        return t;
    }

    public ParamLabel paramLabel(Position pos, ParamInstance pi) {
        ParamLabel_c t = new ParamLabel_c(pi, this, pos);
        return t;
    }

    public ReaderPolicy readerPolicy(Position pos, Principal owner, Principal reader) {
        ReaderPolicy_c t = new ReaderPolicy_c(owner, reader, this, pos);
        return t;
    }

    public ReaderPolicy readerPolicy(Position pos, Principal owner, Collection readers) {
        Principal r = this.disjunctivePrincipal(pos, readers);
        return this.readerPolicy(pos, owner, r);
    }

    public WriterPolicy writerPolicy(Position pos, Principal owner, Principal writer) {
        WriterPolicy_c t = new WriterPolicy_c(owner, writer, this, pos);
        return t;
    }

    public WriterPolicy writerPolicy(Position pos, Principal owner, Collection writers) {
        Principal w = this.disjunctivePrincipal(pos, writers);
        return this.writerPolicy(pos, owner, w);
    }

    public ConfPolicy bottomConfPolicy(Position pos) {
        return this.readerPolicy(pos, (Principal)this.bottomPrincipal(pos), this.bottomPrincipal(pos));
    }

    public IntegPolicy bottomIntegPolicy(Position pos) {
        return this.writerPolicy(pos, (Principal)this.topPrincipal(pos), this.topPrincipal(pos));
    }

    public ConfPolicy topConfPolicy(Position pos) {
        return this.readerPolicy(pos, (Principal)this.topPrincipal(pos), this.topPrincipal(pos));
    }

    public IntegPolicy topIntegPolicy(Position pos) {
        return this.writerPolicy(pos, (Principal)this.bottomPrincipal(pos), this.bottomPrincipal(pos));
    }

    public Label joinLabel(Position pos, Set components) {
        if (components == null) {
            components = Collections.EMPTY_SET;
        }
        if (components.isEmpty()) {
            return this.bottomLabel(pos);
        }
        if (components.size() == 1) {
            return (Label)components.iterator().next();
        }
        JoinLabel_c t = new JoinLabel_c(components, this, pos, this.joinLabelTranslator());
        return t;
    }

    public LabelToJavaExpr joinLabelTranslator() {
        return new JoinLabelToJavaExpr_c();
    }

    public Label meetLabel(Position pos, Set components) {
        if (components == null) {
            components = Collections.EMPTY_SET;
        }
        if (components.isEmpty()) {
            return this.topLabel(pos);
        }
        if (components.size() == 1) {
            return (Label)components.iterator().next();
        }
        MeetLabel_c t = new MeetLabel_c(components, this, pos, this.meetLabelTranslator());
        return t;
    }

    public LabelToJavaExpr meetLabelTranslator() {
        return new MeetLabelToJavaExpr_c();
    }

    public DynamicLabel dynamicLabel(Position pos, AccessPath path) {
        DynamicLabel_c t = new DynamicLabel_c(path, this, pos, this.dynamicLabelTranslator());
        return t;
    }

    public Label pathToLabel(Position pos, AccessPath path) {
        if (path instanceof AccessPathConstant) {
            AccessPathConstant apc = (AccessPathConstant)path;
            if (!apc.isLabelConstant()) {
                throw new InternalCompilerError("Dynamic label with a constant access path: " + apc);
            }
            return (Label)apc.constantValue();
        }
        DynamicLabel t = this.dynamicLabel(pos, path);
        return t;
    }

    protected LabelToJavaExpr dynamicLabelTranslator() {
        return new DynamicLabelToJavaExpr_c();
    }

    public ArgLabel argLabel(Position pos, LocalInstance vi, CodeInstance ci) {
        ArgLabel_c t = new ArgLabel_c((JifTypeSystem)this, (VarInstance)vi, ci, pos);
        return t;
    }

    public ArgLabel argLabel(Position pos, ParamInstance pi) {
        ArgLabel_c t = new ArgLabel_c((JifTypeSystem)this, pi, null, pos);
        return t;
    }

    public Label callSitePCLabel(JifProcedureInstance pi) {
        ArgLabel_c pcLabel = new ArgLabel_c((JifTypeSystem)this, pi, "caller_pc", pi.position());
        pcLabel.setUpperBound(pi.pcBound());
        pcLabel.setDescription("The pc at the call site of this " + pi.designator() + " (bounded above by " + pi.pcBound() + ")");
        return pcLabel;
    }

    public ThisLabel thisLabel(JifClassType ct) {
        return this.thisLabel(ct.position(), ct);
    }

    public ThisLabel thisLabel(ArrayType at) {
        return this.thisLabel(at.position(), (ReferenceType)at);
    }

    public ThisLabel thisLabel(Position pos, JifClassType ct) {
        return this.thisLabel(pos, (ReferenceType)ct);
    }

    public ThisLabel thisLabel(Position pos, ReferenceType ct) {
        return new ThisLabel_c((JifTypeSystem)this, ct, pos);
    }

    public UnknownLabel unknownLabel(Position pos) {
        UnknownLabel_c t = new UnknownLabel_c(this, pos);
        return t;
    }

    public PairLabel pairLabel(Position pos, ConfPolicy confPol, IntegPolicy integPol) {
        return new PairLabel_c(this, confPol, integPol, pos, this.pairLabelTranslator());
    }

    protected LabelToJavaExpr pairLabelTranslator() {
        return new PairLabelToJavaExpr_c();
    }

    public WritersToReadersLabel writersToReadersLabel(Position pos, Label L) {
        WritersToReadersLabel_c t = new WritersToReadersLabel_c(L, this, pos);
        return t;
    }

    public ActsForConstraint actsForConstraint(Position pos, Principal actor, Principal granter, boolean isEquiv) {
        return new ActsForConstraint_c(this, pos, actor, granter, isEquiv);
    }

    public LabelLeAssertion labelLeAssertion(Position pos, Label lhs, Label rhs) {
        return new LabelLeAssertion_c(this, lhs, rhs, pos);
    }

    public AuthConstraint authConstraint(Position pos, List principals) {
        return new AuthConstraint_c(this, pos, principals);
    }

    public AutoEndorseConstraint autoEndorseConstraint(Position pos, Label endorseTo) {
        return new AutoEndorseConstraint_c(this, pos, endorseTo);
    }

    public CallerConstraint callerConstraint(Position pos, List principals) {
        return new CallerConstraint_c(this, pos, principals);
    }

    public Label labelOfField(FieldInstance vi, Label pc) {
        return ((JifFieldInstance)vi).label();
    }

    public Label labelOfLocal(LocalInstance vi, Label pc) {
        return ((JifLocalInstance)vi).label();
    }

    public Label labelOfType(Type type) {
        return this.labelOfType(type, this.bottomLabel(type.position()));
    }

    public Label labelOfType(Type type, Label defaultLabel) {
        if (type instanceof LabeledType) {
            return ((LabeledType)type).labelPart();
        }
        return defaultLabel;
    }

    protected Type strip(Type type) {
        if (type instanceof LabeledType) {
            return this.strip(((LabeledType)type).typePart());
        }
        if (type instanceof JifSubstType) {
            return this.strip(((JifSubstType)type).base());
        }
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            return at.base(this.strip(at.base()));
        }
        return type;
    }

    public Type unlabel(Type type) {
        if (type instanceof LabeledType) {
            return ((LabeledType)type).typePart();
        }
        return type;
    }

    public boolean isLabel(Type type) {
        return this.equals((TypeObject)this.unlabel(type), (TypeObject)this.LABEL_);
    }

    public boolean isPrincipal(Type type) {
        return this.equals((TypeObject)this.unlabel(type), (TypeObject)this.PRINCIPAL_);
    }

    public boolean isLabeled(Type type) {
        return type instanceof LabeledType;
    }

    public boolean isJifClass(Type type) {
        FieldInstance fi;
        ClassType ct = type.toClass();
        return ct == null || (fi = ct.fieldNamed(JIF_SIG_OF_JAVA_MARKER)) == null || !fi.flags().isPrivate() && !ct.flags().isInterface() || !fi.flags().isStatic();
    }

    public boolean isMarkerFieldName(String s) {
        return JIF_SIG_OF_JAVA_MARKER.equals(s) || JIF_PARAMS_RUNTIME_MARKER.equals(s) || JIF_SAFE_CONSTRUCTOR_MARKER.equals(s);
    }

    public boolean isParamsRuntimeRep(Type t) {
        FieldInstance fi;
        if (this.isJifClass(t)) {
            return true;
        }
        ClassType ct = t.toClass();
        return ct != null && (fi = ct.fieldNamed(JIF_PARAMS_RUNTIME_MARKER)) != null && fi.flags().isPrivate() && fi.flags().isStatic();
    }

    public ClassType hasUntrustedAncestor(Type t) {
        if (t == null || t.toReference() == null) {
            return null;
        }
        Type st = t.toReference().superType();
        if (st == null || st.toClass() == null) {
            return null;
        }
        ClassType ct = st.toClass();
        if (!this.hasSafeConstructors(ct)) {
            return ct;
        }
        return this.hasUntrustedAncestor((Type)ct);
    }

    public boolean hasSafeConstructors(ClassType ct) {
        FieldInstance fi;
        if (this.isJifClass((Type)ct)) {
            return true;
        }
        return ct != null && (fi = ct.fieldNamed(JIF_SAFE_CONSTRUCTOR_MARKER)) != null && fi.flags().isPrivate() && fi.flags().isStatic();
    }

    public boolean canCoerceToString(Type t, Context c) {
        return this.equalsStrip((TypeObject)t, (TypeObject)this.String()) || t.isPrimitive() && !this.isPrincipal(t) && !this.isLabel(t);
    }

    public Label join(Label L1, Label L2) {
        if (L1 instanceof NotTaken) {
            return L2.simplify();
        }
        if (L2 instanceof NotTaken) {
            return L1.simplify();
        }
        if (L1.isTop() || L2.isBottom()) {
            return L1.simplify();
        }
        if (L2.isTop() || L1.isBottom()) {
            return L2.simplify();
        }
        LinkedHashSet<Label> s = new LinkedHashSet<Label>();
        s.add(L1);
        s.add(L2);
        Position pos = L1.position();
        if (pos == null) {
            pos = L2.position();
        }
        return this.joinLabel(pos, s).simplify();
    }

    public Label meet(Label L1, Label L2) {
        if (L1.isTop() || L2.isBottom()) {
            return L2.simplify();
        }
        if (L2.isTop() || L1.isBottom()) {
            return L1.simplify();
        }
        LinkedHashSet<Label> s = new LinkedHashSet<Label>();
        s.add(L1);
        s.add(L2);
        Position pos = L1.position();
        if (pos == null) {
            pos = L2.position();
        }
        return this.meetLabel(pos, s).simplify();
    }

    public boolean actsFor(Principal p, Principal q) {
        return this.emptyLabelEnv.actsFor(p, q);
    }

    public boolean leq(Label L1, Label L2) {
        return this.emptyLabelEnv.leq(L1, L2);
    }

    public boolean leq(Policy p1, Policy p2) {
        return this.emptyLabelEnv.leq(p1, p2);
    }

    public ConfPolicy joinConfPolicy(Position pos, Set components) {
        if (components.isEmpty()) {
            return this.bottomConfPolicy(pos);
        }
        if (components.size() == 1) {
            return (ConfPolicy)components.iterator().next();
        }
        return (ConfPolicy)new JoinConfPolicy_c(components, this, pos).simplify();
    }

    public IntegPolicy joinIntegPolicy(Position pos, Set components) {
        if (components.isEmpty()) {
            return this.bottomIntegPolicy(pos);
        }
        if (components.size() == 1) {
            return (IntegPolicy)components.iterator().next();
        }
        return (IntegPolicy)new JoinIntegPolicy_c(components, this, pos).simplify();
    }

    public ConfPolicy meetConfPolicy(Position pos, Set components) {
        if (components.isEmpty()) {
            return this.topConfPolicy(pos);
        }
        if (components.size() == 1) {
            return (ConfPolicy)components.iterator().next();
        }
        return (ConfPolicy)new MeetConfPolicy_c(components, this, pos).simplify();
    }

    public IntegPolicy meetIntegPolicy(Position pos, Set components) {
        if (components.isEmpty()) {
            return this.topIntegPolicy(pos);
        }
        if (components.size() == 1) {
            return (IntegPolicy)components.iterator().next();
        }
        return (IntegPolicy)new MeetIntegPolicy_c(components, this, pos).simplify();
    }

    public ConfPolicy join(ConfPolicy p1, ConfPolicy p2) {
        if (p1.isTop() || p2.isBottom()) {
            return (ConfPolicy)p1.simplify();
        }
        if (p2.isTop() || p1.isBottom()) {
            return (ConfPolicy)p2.simplify();
        }
        HashSet<ConfPolicy> s = new HashSet<ConfPolicy>();
        s.add(p1);
        s.add(p2);
        Position pos = p1.position();
        if (pos == null) {
            pos = p2.position();
        }
        return (ConfPolicy)this.joinConfPolicy(pos, s).simplify();
    }

    public IntegPolicy join(IntegPolicy p1, IntegPolicy p2) {
        if (p1.isTop() || p2.isBottom()) {
            return (IntegPolicy)p1.simplify();
        }
        if (p2.isTop() || p1.isBottom()) {
            return (IntegPolicy)p2.simplify();
        }
        HashSet<IntegPolicy> s = new HashSet<IntegPolicy>();
        s.add(p1);
        s.add(p2);
        Position pos = p1.position();
        if (pos == null) {
            pos = p2.position();
        }
        return (IntegPolicy)this.joinIntegPolicy(pos, s).simplify();
    }

    public ConfPolicy meet(ConfPolicy p1, ConfPolicy p2) {
        if (p1.isTop() || p2.isBottom()) {
            return (ConfPolicy)p2.simplify();
        }
        if (p2.isTop() || p1.isBottom()) {
            return (ConfPolicy)p1.simplify();
        }
        HashSet<ConfPolicy> s = new HashSet<ConfPolicy>();
        s.add(p1);
        s.add(p2);
        Position pos = p1.position();
        if (pos == null) {
            pos = p2.position();
        }
        return (ConfPolicy)this.meetConfPolicy(pos, s).simplify();
    }

    public IntegPolicy meet(IntegPolicy p1, IntegPolicy p2) {
        if (p1.isTop() || p2.isBottom()) {
            return (IntegPolicy)p2.simplify();
        }
        if (p2.isTop() || p1.isBottom()) {
            return (IntegPolicy)p1.simplify();
        }
        HashSet<IntegPolicy> s = new HashSet<IntegPolicy>();
        s.add(p1);
        s.add(p2);
        Position pos = p1.position();
        if (pos == null) {
            pos = p2.position();
        }
        return (IntegPolicy)this.meetIntegPolicy(pos, s).simplify();
    }

    public ConfPolicy confProjection(Label L) {
        if (L instanceof MeetLabel || L instanceof JoinLabel || L instanceof PairLabel) {
            return L.confProjection();
        }
        return new ConfProjectionPolicy_c(L, this, L.position());
    }

    public IntegPolicy integProjection(Label L) {
        if (L instanceof MeetLabel || L instanceof JoinLabel || L instanceof PairLabel) {
            return L.integProjection();
        }
        return new IntegProjectionPolicy_c(L, this, L.position());
    }

    public String translateClass(Resolver c, ClassType t) {
        if (t.package_() != null && (t.package_().equals(this.createPackage("jif.lang")) || t.package_().equals(this.createPackage("jif.principals")))) {
            return super.translateClass(null, t);
        }
        return super.translateClass(c, t);
    }

    public String translatePrimitive(Resolver c, PrimitiveType t) {
        if (this.isLabel((Type)t)) {
            return this.LabelClassName();
        }
        if (this.isPrincipal((Type)t)) {
            return this.PrincipalClassName();
        }
        return super.translatePrimitive(c, t);
    }

    public List abstractSuperInterfaces(ReferenceType rt) {
        return super.abstractSuperInterfaces(rt);
    }

    public boolean isAccessible(MemberInstance mi, ClassType contextClass) {
        return super.isAccessible(mi, contextClass);
    }

    public PrimitiveType primitiveForName(String name) throws SemanticException {
        if (name.equals("label")) {
            return this.Label();
        }
        if (name.equals("principal")) {
            return this.Principal();
        }
        return super.primitiveForName(name);
    }

    public Collection uncheckedExceptions() {
        return Collections.singletonList(this.Error());
    }

    public DefaultSignature defaultSignature() {
        return this.ds;
    }

    public ConstructorInstance defaultConstructor(Position pos, ClassType container) {
        this.assert_((TypeObject)container);
        return this.jifConstructorInstance(pos, container, this.Public(), this.topLabel(), true, this.bottomLabel(), true, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    public LabelTypeCheckUtil labelTypeCheckUtil() {
        if (this.ltcu == null) {
            this.ltcu = new LabelTypeCheckUtil(this);
        }
        return this.ltcu;
    }
}

