/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jif.types.ActsForConstraint;
import jif.types.Assertion;
import jif.types.AuthConstraint;
import jif.types.AutoEndorseConstraint;
import jif.types.CallerConstraint;
import jif.types.JifClassType;
import jif.types.JifFieldInstance;
import jif.types.JifProcedureInstance;
import jif.types.JifSubst;
import jif.types.JifSubstClassType_c;
import jif.types.JifTypeSystem;
import jif.types.LabelLeAssertion;
import jif.types.LabelSubstitution;
import jif.types.Param;
import jif.types.ParamInstance;
import jif.types.UnknownParam;
import jif.types.label.CovariantParamLabel;
import jif.types.label.Label;
import jif.types.label.ParamLabel;
import jif.types.principal.ParamPrincipal;
import jif.types.principal.Principal;
import polyglot.ext.param.types.ParamTypeSystem;
import polyglot.ext.param.types.Subst_c;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.FieldInstance;
import polyglot.types.MethodInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.util.CachingTransformingList;
import polyglot.util.InternalCompilerError;
import polyglot.util.Transformation;

public class JifSubst_c
extends Subst_c
implements JifSubst {
    protected SubstLabelSubst substLabelSubst = new SubstLabelSubst();

    public JifSubst_c(JifTypeSystem ts, Map subst, Map cache) {
        super((ParamTypeSystem)ts, subst, cache);
        Iterator i = this.entries();
        while (i.hasNext()) {
            Map.Entry e = (Map.Entry)i.next();
            if (e.getKey() instanceof ParamInstance && e.getValue() instanceof Param) continue;
            throw new InternalCompilerError("bad map: the keys must be UIDs, and the values must be Params: " + subst);
        }
    }

    public Param get(ParamInstance pi) {
        return (Param)this.subst.get(pi);
    }

    public void put(ParamInstance pi, Param param) {
        this.subst.put(pi, param);
    }

    protected boolean cacheTypeEquality(Type t1, Type t2) {
        return ((JifTypeSystem)this.ts).equalsNoStrip((TypeObject)t1, (TypeObject)t2);
    }

    public Type uncachedSubstType(Type t) {
        JifTypeSystem ts = (JifTypeSystem)this.ts;
        if (ts.isLabeled(t)) {
            return ts.labeledType(t.position(), this.substType(ts.unlabel(t)), this.substLabel(ts.labelOfType(t)));
        }
        return super.uncachedSubstType(t);
    }

    public ClassType substClassType(ClassType t) {
        if (!(t instanceof JifClassType)) {
            return t;
        }
        return new JifSubstClassType_c((JifTypeSystem)this.ts, t.position(), (JifClassType)t, this);
    }

    public MethodInstance substMethod(MethodInstance mi) {
        if ((mi = super.substMethod(mi)) instanceof JifProcedureInstance) {
            JifProcedureInstance jmi = (JifProcedureInstance)mi;
            jmi.setPCBound(this.substLabel(jmi.pcBound()), jmi.isDefaultPCBound());
            jmi.setReturnLabel(this.substLabel(jmi.returnLabel()), jmi.isDefaultReturnLabel());
            jmi.setConstraints((List)new CachingTransformingList(jmi.constraints(), (Transformation)new ConstraintXform()));
            mi = (MethodInstance)jmi;
        }
        return mi;
    }

    public ConstructorInstance substConstructor(ConstructorInstance ci) {
        if ((ci = super.substConstructor(ci)) instanceof JifProcedureInstance) {
            JifProcedureInstance jci = (JifProcedureInstance)ci;
            jci.setPCBound(this.substLabel(jci.pcBound()), jci.isDefaultPCBound());
            jci.setReturnLabel(this.substLabel(jci.returnLabel()), jci.isDefaultReturnLabel());
            jci.setConstraints((List)new CachingTransformingList(jci.constraints(), (Transformation)new ConstraintXform()));
            ci = (ConstructorInstance)jci;
        }
        return ci;
    }

    public FieldInstance substField(FieldInstance fi) {
        if ((fi = super.substField(fi)) instanceof JifFieldInstance) {
            JifFieldInstance jfi = (JifFieldInstance)fi;
            jfi.setLabel(this.substLabel(jfi.label()));
            fi = jfi;
        }
        return fi;
    }

    public List substConstraintList(List constraints) {
        return new CachingTransformingList(constraints, (Transformation)new ConstraintXform());
    }

    public List substLabelList(List labels) {
        return new CachingTransformingList(labels, (Transformation)new LabelXform());
    }

    public List substPrincipalList(List principals) {
        return new CachingTransformingList(principals, (Transformation)new PrincipalXform());
    }

    public Assertion substConstraint(Assertion constraint) {
        if (constraint == null) {
            return null;
        }
        if (constraint instanceof ActsForConstraint) {
            ActsForConstraint c = (ActsForConstraint)constraint;
            c = c.actor(this.substPrincipal(c.actor()));
            c = c.granter(this.substPrincipal(c.granter()));
            return c;
        }
        if (constraint instanceof LabelLeAssertion) {
            LabelLeAssertion c = (LabelLeAssertion)constraint;
            c = c.lhs(this.substLabel(c.lhs()));
            c = c.rhs(this.substLabel(c.rhs()));
            return c;
        }
        if (constraint instanceof CallerConstraint) {
            CallerConstraint c = (CallerConstraint)constraint;
            CachingTransformingList l = new CachingTransformingList(c.principals(), (Transformation)new PrincipalXform());
            return c.principals((List)l);
        }
        if (constraint instanceof AuthConstraint) {
            AuthConstraint c = (AuthConstraint)constraint;
            CachingTransformingList l = new CachingTransformingList(c.principals(), (Transformation)new PrincipalXform());
            return c.principals((List)l);
        }
        if (constraint instanceof AutoEndorseConstraint) {
            AutoEndorseConstraint c = (AutoEndorseConstraint)constraint;
            c = c.endorseTo(this.substLabel(c.endorseTo()));
            return c;
        }
        return constraint;
    }

    public Label substLabel(Label label) {
        if (label == null) {
            return null;
        }
        try {
            return label.subst(this.substLabelSubst);
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Unexpected semantic exception", (Throwable)e);
        }
    }

    public Principal substPrincipal(Principal principal) {
        if (principal == null) {
            return null;
        }
        try {
            return principal.subst(this.substLabelSubst);
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Unexpected semantic exception", (Throwable)e);
        }
    }

    protected Label subLabel(Label label, ParamInstance pi) {
        Param sub = (Param)this.subst.get(pi);
        JifTypeSystem ts = (JifTypeSystem)this.typeSystem();
        if (sub instanceof UnknownParam) {
            return ts.unknownLabel(sub.position());
        }
        if (sub instanceof Label) {
            return (Label)sub;
        }
        if (sub == null) {
            return label;
        }
        throw new InternalCompilerError("Cannot substitute " + label + " for " + sub + " with param instance " + pi, label.position());
    }

    protected Principal subPrincipal(Principal principal, ParamInstance pi) {
        Param sub = (Param)this.subst.get(pi);
        JifTypeSystem ts = (JifTypeSystem)this.typeSystem();
        if (sub instanceof UnknownParam) {
            return ts.unknownPrincipal(sub.position());
        }
        if (sub instanceof Principal) {
            return (Principal)sub;
        }
        if (sub == null) {
            return principal;
        }
        throw new InternalCompilerError("Cannot substitute " + principal + " for " + sub + " with param instance " + pi, principal.position());
    }

    protected Object substSubstValue(Object value) {
        if (value instanceof Label) {
            return this.substLabel((Label)value);
        }
        if (value instanceof Principal) {
            return this.substPrincipal((Principal)value);
        }
        return super.substSubstValue(value);
    }

    public class PrincipalXform
    implements Transformation {
        public Object transform(Object o) {
            return JifSubst_c.this.substPrincipal((Principal)o);
        }
    }

    public class LabelXform
    implements Transformation {
        public Object transform(Object o) {
            return JifSubst_c.this.substLabel((Label)o);
        }
    }

    public class ConstraintXform
    implements Transformation {
        public Object transform(Object o) {
            return JifSubst_c.this.substConstraint((Assertion)o);
        }
    }

    protected class SubstLabelSubst
    extends LabelSubstitution
    implements Serializable {
        protected SubstLabelSubst() {
        }

        public Label substLabel(Label L) throws SemanticException {
            if (L instanceof ParamLabel) {
                ParamLabel c = (ParamLabel)L;
                return JifSubst_c.this.subLabel(c, c.paramInstance());
            }
            if (L instanceof CovariantParamLabel) {
                CovariantParamLabel c = (CovariantParamLabel)L;
                return JifSubst_c.this.subLabel(c, c.paramInstance());
            }
            return L;
        }

        public Principal substPrincipal(Principal p) throws SemanticException {
            if (p instanceof ParamPrincipal) {
                ParamPrincipal pp = (ParamPrincipal)p;
                return JifSubst_c.this.subPrincipal(pp, pp.paramInstance());
            }
            return p;
        }
    }
}

