/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jif.types.Assertion;
import jif.types.JifConstructorInstance;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.TypeSubstitutor;
import jif.types.VarMap;
import jif.types.label.ArgLabel;
import jif.types.label.Label;
import polyglot.main.Report;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance_c;
import polyglot.types.Flags;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.util.TypedList;

public class JifConstructorInstance_c
extends ConstructorInstance_c
implements JifConstructorInstance {
    protected Label pcBound;
    protected Label returnLabel;
    protected List constraints;
    protected boolean isDefaultPCBound;
    protected boolean isDefaultReturnLabel;

    public JifConstructorInstance_c(JifTypeSystem ts, Position pos, ClassType container, Flags flags, Label pcBound, boolean isDefaultPCBound, Label returnLabel, boolean isDefaultReturnLabel, List formalTypes, List formalArgLabels, List excTypes, List constraints) {
        super((TypeSystem)ts, pos, container, flags, formalTypes, excTypes);
        this.pcBound = pcBound;
        this.returnLabel = returnLabel;
        this.constraints = TypedList.copyAndCheck((List)constraints, Assertion.class, (boolean)true);
        this.pcBound = pcBound;
        this.isDefaultPCBound = isDefaultPCBound;
        this.returnLabel = returnLabel;
        this.isDefaultReturnLabel = isDefaultReturnLabel;
        this.throwTypes = TypedList.copyAndCheck((List)this.throwTypes, Type.class, (boolean)true);
        this.formalTypes = TypedList.copyAndCheck((List)formalTypes, Type.class, (boolean)true);
    }

    public Label pcBound() {
        return this.pcBound;
    }

    public Label externalPC() {
        return this.pcBound;
    }

    public Label returnLabel() {
        return this.returnLabel;
    }

    public void setReturnLabel(Label returnLabel, boolean isDefault) {
        this.returnLabel = returnLabel;
        this.isDefaultReturnLabel = isDefault;
    }

    public boolean isDefaultReturnLabel() {
        return this.isDefaultReturnLabel;
    }

    public void setPCBound(Label pcBound, boolean isDefault) {
        this.pcBound = pcBound;
        this.isDefaultPCBound = isDefault;
    }

    public boolean isDefaultPCBound() {
        return this.isDefaultPCBound;
    }

    public List constraints() {
        return this.constraints;
    }

    public void setConstraints(List constraints) {
        this.constraints = TypedList.copyAndCheck((List)constraints, Assertion.class, (boolean)true);
    }

    public boolean isCanonical() {
        if (!(super.isCanonical() && this.pcBound.isCanonical() && this.returnLabel.isCanonical() && this.listIsCanonical(this.constraints) && this.formalTypes != null)) {
            return false;
        }
        JifTypeSystem jts = (JifTypeSystem)this.typeSystem();
        for (Type t : this.formalTypes()) {
            if (jts.isLabeled(t) && jts.labelOfType(t) instanceof ArgLabel) continue;
            return false;
        }
        return true;
    }

    public void subst(VarMap bounds) {
        if (this.pcBound != null) {
            this.pcBound = bounds.applyTo(this.pcBound);
        }
        if (this.returnLabel != null) {
            this.returnLabel = bounds.applyTo(this.returnLabel);
        }
        LinkedList<Type> formalTypes = new LinkedList<Type>();
        for (Type t : this.formalTypes()) {
            formalTypes.add(bounds.applyTo(t));
        }
        this.setFormalTypes(formalTypes);
        LinkedList<Type> throwTypes = new LinkedList<Type>();
        for (Type t : this.throwTypes()) {
            throwTypes.add(bounds.applyTo(t));
        }
        this.setThrowTypes(throwTypes);
    }

    public void subst(LabelSubstitution subst) throws SemanticException {
        TypeSubstitutor tsbs = new TypeSubstitutor(subst);
        this.setPCBound(this.pcBound().subst(subst), this.isDefaultPCBound());
        this.setReturnLabel(this.returnLabel().subst(subst), this.isDefaultReturnLabel());
        LinkedList<Type> formalTypes = new LinkedList<Type>();
        for (Type t : this.formalTypes()) {
            formalTypes.add(tsbs.rewriteType(t));
        }
        this.setFormalTypes(formalTypes);
        LinkedList<Type> throwTypes = new LinkedList<Type>();
        for (Type t : this.throwTypes()) {
            throwTypes.add(tsbs.rewriteType(t));
        }
        this.setThrowTypes(throwTypes);
    }

    public String debugString() {
        return this.debugString(true);
    }

    private String debugString(boolean showInstanceKind) {
        String s = "";
        if (showInstanceKind) {
            s = "constructor ";
        }
        s = s + this.flags.translate() + this.container + "(";
        Iterator i = this.formalTypes.iterator();
        while (i.hasNext()) {
            Type t = (Type)i.next();
            s = s + ((JifTypeSystem)this.ts).unlabel(t).toString();
            if (!i.hasNext()) continue;
            s = s + ", ";
        }
        s = s + ")";
        return s;
    }

    public String signature() {
        if (Report.should_report((String)"debug", (int)1)) {
            return this.fullSignature();
        }
        return this.debugString(false);
    }

    public String fullSignature() {
        String s = this.container.toString();
        if (!this.isDefaultPCBound() || Report.should_report((String)"debug", (int)1)) {
            s = s + this.pcBound;
        }
        s = s + "(";
        Iterator i = this.formalTypes.iterator();
        while (i.hasNext()) {
            Type t = (Type)i.next();
            s = s + t.toString();
            if (!i.hasNext()) continue;
            s = s + ",";
        }
        s = s + ")";
        if (!this.isDefaultReturnLabel() || Report.should_report((String)"debug", (int)1)) {
            s = s + ":" + this.returnLabel;
        }
        return s;
    }
}

