/*
 * Decompiled with CFR 0.152.
 */
package jif.translate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jif.ast.Jif;
import jif.ast.JifNodeFactory;
import jif.ast.JifUtil;
import jif.types.JifTypeSystem;
import jif.types.Param;
import jif.types.label.Label;
import jif.types.principal.Principal;
import polyglot.ast.Block;
import polyglot.ast.ClassDecl;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.SourceCollection;
import polyglot.ast.SourceFile;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Job;
import polyglot.frontend.Source;
import polyglot.qq.QQ;
import polyglot.types.ClassType;
import polyglot.types.FieldInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.ErrorQueue;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

public class JifToJavaRewriter
extends ContextVisitor {
    protected ExtensionInfo java_ext;
    private JifTypeSystem jif_ts;
    private JifNodeFactory jif_nf;
    private Job job;
    private QQ qq;
    protected Collection additionalClassDecls;
    protected Collection newSourceFiles;
    protected List initializations;
    protected List staticInitializations;
    private ClassType currentClass;
    private boolean inConstructor;

    public JifToJavaRewriter(Job job, JifTypeSystem jif_ts, JifNodeFactory jif_nf, ExtensionInfo java_ext) {
        super(job, (TypeSystem)jif_ts, java_ext.nodeFactory());
        this.job = job;
        this.jif_ts = jif_ts;
        this.jif_nf = jif_nf;
        this.java_ext = java_ext;
        this.qq = new QQ(java_ext);
        this.additionalClassDecls = new LinkedList();
        this.newSourceFiles = new LinkedList();
        this.initializations = new ArrayList();
        this.staticInitializations = new ArrayList();
    }

    public void finish(Node ast) {
        if (ast instanceof SourceCollection) {
            SourceCollection c = (SourceCollection)ast;
            for (SourceFile sf : c.sources()) {
                this.java_ext.scheduler().addJob(sf.source(), (Node)sf);
            }
        } else {
            this.java_ext.scheduler().addJob(this.job.source(), ast);
        }
        for (SourceFile sf : this.newSourceFiles) {
            this.java_ext.scheduler().addJob(sf.source(), (Node)sf);
        }
        this.newSourceFiles.clear();
    }

    public JifTypeSystem jif_ts() {
        return this.jif_ts;
    }

    public JifNodeFactory jif_nf() {
        return this.jif_nf;
    }

    public TypeSystem java_ts() {
        return this.java_ext.typeSystem();
    }

    public NodeFactory java_nf() {
        return this.java_ext.nodeFactory();
    }

    public ErrorQueue errorQueue() {
        return this.job.compiler().errorQueue();
    }

    public NodeVisitor enterCall(Node n) {
        try {
            Jif ext = JifUtil.jifExt(n);
            return ext.toJava().toJavaEnter(this);
        }
        catch (SemanticException e) {
            Position position = e.position();
            if (position == null) {
                position = n.position();
            }
            this.errorQueue().enqueue(5, e.getMessage(), position);
            return this;
        }
    }

    public Node leaveCall(Node old, Node n, NodeVisitor v) {
        try {
            Jif ext = JifUtil.jifExt(n);
            Node m = ext.toJava().toJava(this);
            if (m.del() instanceof Jif) {
                throw new InternalCompilerError(m + " is still a Jif node.");
            }
            return m;
        }
        catch (SemanticException e) {
            Position position = e.position();
            if (position == null) {
                position = n.position();
            }
            this.errorQueue().enqueue(5, e.getMessage(), position);
            return n;
        }
    }

    public Expr paramToJava(Param param) throws SemanticException {
        if (param instanceof Label) {
            return this.labelToJava((Label)param);
        }
        if (param instanceof Principal) {
            return this.principalToJava((Principal)param);
        }
        throw new InternalCompilerError("Unexpected param " + param);
    }

    public Expr labelToJava(Label label) throws SemanticException {
        return label.toJava(this);
    }

    public Expr principalToJava(Principal principal) throws SemanticException {
        return principal.toJava(this);
    }

    public TypeNode typeToJava(Type t, Position pos) throws SemanticException {
        NodeFactory nf = this.java_nf();
        TypeSystem ts = this.java_ts();
        JifTypeSystem jifts = this.jif_ts();
        if (t.isNull()) {
            return this.canonical(nf, (Type)ts.Null(), pos);
        }
        if (t.isVoid()) {
            return this.canonical(nf, (Type)ts.Void(), pos);
        }
        if (t.isBoolean()) {
            return this.canonical(nf, (Type)ts.Boolean(), pos);
        }
        if (t.isByte()) {
            return this.canonical(nf, (Type)ts.Byte(), pos);
        }
        if (t.isChar()) {
            return this.canonical(nf, (Type)ts.Char(), pos);
        }
        if (t.isShort()) {
            return this.canonical(nf, (Type)ts.Short(), pos);
        }
        if (t.isInt()) {
            return this.canonical(nf, (Type)ts.Int(), pos);
        }
        if (t.isLong()) {
            return this.canonical(nf, (Type)ts.Long(), pos);
        }
        if (t.isFloat()) {
            return this.canonical(nf, (Type)ts.Float(), pos);
        }
        if (t.isDouble()) {
            return this.canonical(nf, (Type)ts.Double(), pos);
        }
        if (jifts.isLabel(t)) {
            return nf.TypeNodeFromQualifiedName(pos, jifts.LabelClassName());
        }
        if (jifts.isPrincipal(t)) {
            return nf.TypeNodeFromQualifiedName(pos, jifts.PrincipalClassName());
        }
        if (t.isArray()) {
            return nf.ArrayTypeNode(pos, this.typeToJava(t.toArray().base(), pos));
        }
        if (t.isClass()) {
            return nf.TypeNodeFromQualifiedName(pos, t.toClass().fullName());
        }
        throw new InternalCompilerError("Cannot translate type " + t + ".");
    }

    protected TypeNode canonical(NodeFactory nf, Type t, Position pos) {
        return nf.CanonicalTypeNode(pos, t);
    }

    public QQ qq() {
        return this.qq;
    }

    public ClassType currentClass() {
        return this.currentClass;
    }

    public void enteringClass(ClassType t) {
        this.currentClass = t;
    }

    public void leavingClass() {
        this.currentClass = null;
    }

    public void addInitializer(Block s) {
        this.initializations.add(s);
    }

    public void addInitializer(FieldInstance fi, Expr init) throws SemanticException {
        Stmt s = this.qq().parseStmt(fi.name() + " = %E;", (Object)init);
        this.initializations.add(s);
    }

    public List getInitializations() {
        return this.initializations;
    }

    public void addStaticInitializer(Block s) {
        this.staticInitializations.add(s);
    }

    public List getStaticInitializations() {
        return this.staticInitializations;
    }

    public void addAdditionalClassDecl(ClassDecl cd) {
        this.additionalClassDecls.add(cd);
    }

    public Node leavingSourceFile(SourceFile n) {
        ArrayList<ClassDecl> l = new ArrayList<ClassDecl>(n.decls().size() + this.additionalClassDecls.size());
        l.addAll(n.decls());
        for (ClassDecl cd : this.additionalClassDecls) {
            if (cd.flags().isPublic()) {
                SourceFile sf = this.java_nf().SourceFile(Position.compilerGenerated(), n.package_(), Collections.EMPTY_LIST, Collections.singletonList(cd));
                String newName = cd.name() + "." + this.job.extensionInfo().defaultFileExtension();
                String newPath = n.source().path().substring(0, n.source().path().length() - n.source().name().length()) + newName;
                Source s = new Source(newName, newPath, n.source().lastModified());
                sf = sf.source(s);
                this.newSourceFiles.add(sf);
                continue;
            }
            l.add(cd);
        }
        this.additionalClassDecls.clear();
        return n.decls(l);
    }

    public boolean inConstructor() {
        return this.inConstructor;
    }

    public void inConstructor(boolean flag) {
        this.inConstructor = flag;
    }

    public String runtimeLabelUtil() {
        return this.jif_ts().LabelUtilClassName() + ".singleton()";
    }
}

