/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.LinkedList;
import jif.extension.JifStmtExt_c;
import jif.translate.ToJavaExt;
import jif.types.ConstraintMessage;
import jif.types.ExceptionPath;
import jif.types.JifContext;
import jif.types.JifLocalInstance;
import jif.types.JifTypeSystem;
import jif.types.LabelConstraint;
import jif.types.NamedLabel;
import jif.types.Path;
import jif.types.PathMap;
import jif.types.label.Label;
import jif.visit.LabelChecker;
import polyglot.ast.Block;
import polyglot.ast.Catch;
import polyglot.ast.Formal;
import polyglot.ast.Node;
import polyglot.ast.Try;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeObject;

public class JifTryExt
extends JifStmtExt_c {
    public JifTryExt(ToJavaExt toJava) {
        super(toJava);
    }

    public Node labelCheckStmt(LabelChecker lc) throws SemanticException {
        PathMap X;
        Formal f;
        Try trs = (Try)this.node();
        JifTypeSystem ts = lc.jifTypeSystem();
        JifContext A = lc.jifContext();
        A = (JifContext)trs.del().enterScope((Context)A);
        Block t = (Block)lc.context(A).labelCheck((Node)trs.tryBlock());
        PathMap Xs = JifTryExt.getPathMap((Node)t);
        PathMap Xall = ts.pathMap();
        LinkedList<Node> catches = new LinkedList<Node>();
        for (Catch cb : trs.catchBlocks()) {
            f = cb.formal();
            final JifLocalInstance vi = (JifLocalInstance)f.localInstance();
            Label Li = vi.label();
            A = (JifContext)A.pushBlock();
            A.setPc(Li, lc);
            f = (Formal)lc.context(A).labelCheck((Node)cb.formal());
            if (ts.isLabeled(f.type().type())) {
                Label declaredLabel = ts.labelOfType(f.type().type());
                lc.constrain(new NamedLabel("local_label", "inferred label of " + f.name(), Li), LabelConstraint.EQUAL, new NamedLabel("declared label of " + f.name(), declaredLabel), A.labelEnv(), f.position(), false, new ConstraintMessage(){

                    public String msg() {
                        return "Declared label of catch block variable " + vi.name() + " is incompatible with label constraints.";
                    }
                });
            }
            Label pc_i = this.excLabel(Xs, cb.catchType(), lc, ts);
            final String catchTypeName = ts.unlabel(cb.catchType()).toClass().name();
            lc.constrain(new NamedLabel("join(pc|where exc_i could be thrown)", "the information that could be revealed by the exception " + catchTypeName + " " + "being thrown", pc_i), LabelConstraint.LEQ, new NamedLabel("label_exc_i", "label of variable " + vi.name(), Li), A.labelEnv(), f.position(), false, new ConstraintMessage(){

                public String msg() {
                    return "Label of thrown exceptions of type " + catchTypeName + " not less restrictive than the label of " + vi.name();
                }

                public String detailMsg() {
                    return "More information may be revealed by an exception of type " + catchTypeName + " being thrown than is " + "allowed to flow to " + vi.name() + ".";
                }
            });
            Block si = (Block)lc.context(A).labelCheck((Node)cb.body());
            PathMap Xi = JifTryExt.getPathMap((Node)si);
            Xall = Xall.join(Xi);
            A = (JifContext)A.pop();
            catches.add(JifTryExt.updatePathMap((Node)cb.formal(f).body(si), Xi));
        }
        PathMap Xunc = this.uncaught(Xs, trs, ts);
        Xall = Xall.join(Xunc);
        f = trs.finallyBlock();
        if (f != null) {
            f = (Block)lc.context(A).labelCheck((Node)f);
            PathMap X2 = JifTryExt.getPathMap((Node)f);
            Label finalPath = ts.bottomLabel();
            for (Path p : X2.paths()) {
                finalPath = lc.upperBound(finalPath, X2.get(p));
            }
            for (Path p : Xall.paths()) {
                if (!(p instanceof ExceptionPath)) continue;
                Xall = Xall.set(p, lc.upperBound(Xall.get(p), finalPath));
            }
            X = Xall.join(X2);
        } else {
            X = Xall;
        }
        trs = trs.tryBlock(t).catchBlocks(catches).finallyBlock((Block)f);
        return JifTryExt.updatePathMap((Node)trs, X);
    }

    private PathMap uncaught(PathMap X, Try trs, JifTypeSystem ts) throws SemanticException {
        PathMap Xp = X;
        for (Path p : X.paths()) {
            if (!(p instanceof ExceptionPath)) continue;
            ExceptionPath jep = (ExceptionPath)p;
            boolean sat = false;
            for (Catch cb : trs.catchBlocks()) {
                if (!ts.isImplicitCastValid(jep.exception(), cb.catchType()) && !ts.equals((TypeObject)jep.exception(), (TypeObject)cb.catchType())) continue;
                sat = true;
                break;
            }
            if (!sat) continue;
            Xp = Xp.set(jep, ts.notTaken());
        }
        return Xp;
    }

    private Label excLabel(PathMap X, Type ct, LabelChecker lc, JifTypeSystem ts) throws SemanticException {
        Label L = ts.bottomLabel(ct.position());
        for (Path p : X.paths()) {
            ExceptionPath ep;
            if (!(p instanceof ExceptionPath) || !ts.isSubtype(ct, (ep = (ExceptionPath)p).exception()) && !ts.isSubtype(ep.exception(), ct)) continue;
            L = lc.upperBound(L, X.get(ep));
        }
        return L;
    }
}

