/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.List;
import jif.ast.JifProcedureDecl;
import jif.extension.JifJL_c;
import jif.types.ActsForConstraint;
import jif.types.Assertion;
import jif.types.AuthConstraint;
import jif.types.CallerConstraint;
import jif.types.JifProcedureInstance;
import jif.types.principal.Principal;
import polyglot.ast.Formal;
import polyglot.ast.Node;
import polyglot.ast.ProcedureDecl;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.VarInstance;
import polyglot.util.Position;
import polyglot.visit.TypeChecker;

public class JifProcedureDeclDel
extends JifJL_c {
    public Context enterScope(Context c) {
        c = super.enterScope(c);
        this.addFormalsToScope(c);
        return c;
    }

    protected void addFormalsToScope(Context c) {
        ProcedureDecl pd = (ProcedureDecl)this.node();
        for (Formal f : pd.formals()) {
            c.addVariable((VarInstance)f.localInstance());
        }
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        JifProcedureDecl pd = (JifProcedureDecl)super.typeCheck(tc);
        JifProcedureInstance jpi = (JifProcedureInstance)pd.procedureInstance();
        for (Assertion a : jpi.constraints()) {
            if (a instanceof AuthConstraint) {
                AuthConstraint ac = (AuthConstraint)a;
                this.ensureNotTopPrincipal(ac.principals(), a.position());
                continue;
            }
            if (a instanceof CallerConstraint) {
                CallerConstraint cc = (CallerConstraint)a;
                this.ensureNotTopPrincipal(cc.principals(), a.position());
                continue;
            }
            if (!(a instanceof ActsForConstraint)) continue;
            ActsForConstraint afc = (ActsForConstraint)a;
            this.ensureNotTopPrincipal(afc.actor(), a.position());
            this.ensureNotTopPrincipal(afc.granter(), a.position());
        }
        return pd;
    }

    protected void ensureNotTopPrincipal(List principals, Position pos) throws SemanticException {
        for (Principal p : principals) {
            this.ensureNotTopPrincipal(p, pos);
        }
    }

    protected void ensureNotTopPrincipal(Principal p, Position pos) throws SemanticException {
        if (p.isTopPrincipal()) {
            throw new SemanticException("The top principal " + p + " cannot appear in a constraint.", pos);
        }
    }
}

