/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.Iterator;
import java.util.List;
import jif.ast.JifMethodDecl;
import jif.ast.JifMethodDecl_c;
import jif.extension.JifProcedureDeclExt_c;
import jif.translate.ToJavaExt;
import jif.types.Assertion;
import jif.types.JifContext;
import jif.types.JifMethodInstance;
import jif.types.JifTypeSystem;
import jif.types.LabelLeAssertion;
import jif.types.LabelSubstitution;
import jif.types.PathMap;
import jif.types.SemanticDetailedException;
import jif.types.label.ArgLabel;
import jif.types.label.Label;
import jif.types.label.ThisLabel;
import jif.visit.LabelChecker;
import polyglot.ast.Block;
import polyglot.ast.Formal;
import polyglot.ast.Node;
import polyglot.ast.ProcedureDecl;
import polyglot.main.Report;
import polyglot.types.Context;
import polyglot.types.MemberInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.Position;

public class JifMethodDeclExt
extends JifProcedureDeclExt_c {
    public JifMethodDeclExt(ToJavaExt toJava) {
        super(toJava);
    }

    public Node labelCheck(LabelChecker lc) throws SemanticException {
        PathMap X;
        JifMethodDecl mn = (JifMethodDecl)this.node();
        JifMethodInstance renamedMI = (JifMethodInstance)mn.methodInstance();
        JifMethodInstance mi = JifMethodDecl_c.unrenameArgs(renamedMI);
        this.checkCovariance(mi, lc);
        this.overrideMethodLabelCheck(lc, renamedMI);
        JifTypeSystem ts = lc.jifTypeSystem();
        JifContext A = lc.jifContext();
        A = (JifContext)mn.del().enterScope((Context)A);
        lc = lc.context(A);
        lc.enteringMethod(mi);
        Label Li = this.checkEnforceSignature(mi, lc);
        List formals = this.checkFormals(mn.formals(), mi, lc);
        Block body = null;
        if (!mi.flags().isAbstract() && !mi.flags().isNative()) {
            body = (Block)lc.context(A).labelCheck((Node)mn.body());
            X = JifMethodDeclExt.getPathMap((Node)body);
            if (Report.should_report((String)jif_verbose, (int)3)) {
                Report.report((int)3, (String)("Body path labels = " + X));
            }
            this.addReturnConstraints(Li, X, mi, lc, mi.returnType());
        } else {
            X = ts.pathMap();
            X = X.N(A.currentCodePCBound());
        }
        mn = (JifMethodDecl)JifMethodDeclExt.updatePathMap((Node)mn.formals(formals).body(body), X);
        mn = lc.leavingMethod(mn);
        return mn;
    }

    protected void checkCovariance(JifMethodInstance mi, LabelChecker lc) throws SemanticDetailedException {
        if (mi.flags().isStatic()) {
            return;
        }
        ProcedureDecl mn = (ProcedureDecl)this.node();
        Position declPosition = mn.position();
        Label Li = mi.pcBound();
        if (Li.isCovariant()) {
            throw new SemanticDetailedException("The pc bound of a method can not be the covariant label " + Li + ".", "The pc bound of a method can not be the covariant label " + Li + ". " + "Otherwise, information may be leaked by casting the " + "low-parameter class to a high-parameter class, and masking " + "the low side-effects that invoking the method may cause.", declPosition);
        }
        JifTypeSystem ts = lc.jifTypeSystem();
        Iterator types = mi.formalTypes().iterator();
        int index = 0;
        while (types.hasNext()) {
            Type tj = (Type)types.next();
            Label argBj = ((ArgLabel)ts.labelOfType(tj)).upperBound();
            if (argBj.isCovariant()) {
                String name = ((Formal)mn.formals().get(index)).name();
                throw new SemanticDetailedException("The method argument " + name + " can not be labeled with the covariant label " + argBj + ".", "The method argument " + name + " can not be labeled with the covariant label " + argBj + ". " + "Otherwise, information may be leaked by casting the " + "low-parameter class to a high-parameter class, and calling " + "the method with a high security parameter, which the " + "method regards as low security information.", argBj.position());
            }
            ++index;
        }
        for (Assertion a : mi.constraints()) {
            if (!(a instanceof LabelLeAssertion)) continue;
            LabelLeAssertion lla = (LabelLeAssertion)a;
            CovariantLabelChecker clc = new CovariantLabelChecker(a.position());
        }
    }

    protected void overrideMethodLabelCheck(LabelChecker lc, JifMethodInstance mi) throws SemanticException {
        JifTypeSystem ts = lc.jifTypeSystem();
        for (JifMethodInstance mj : mi.implemented()) {
            if (!ts.isAccessible((MemberInstance)mj, lc.context())) continue;
            lc.createOverrideHelper(mj, mi).checkOverride(lc);
        }
    }

    protected static class CovariantLabelChecker
    extends LabelSubstitution {
        private final Position errPosition;

        CovariantLabelChecker(Position errPosition) {
            this.errPosition = errPosition;
        }

        public Label substLabel(Label L) throws SemanticException {
            if (!(L instanceof ThisLabel) && L.isCovariant()) {
                throw new SemanticDetailedException("Covariant labels can not occur on the right hand side of a label constraint.", "Covariant labels can not occur on the right hand side of a label constraint, since subclasses may not satisfy the constraint.", this.errPosition);
            }
            return L;
        }

        public boolean recurseIntoLabelOf() {
            return false;
        }
    }
}

