/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import jif.ast.JifConstructorDecl;
import jif.ast.JifUtil;
import jif.extension.JifProcedureDeclExt_c;
import jif.translate.ToJavaExt;
import jif.types.JifConstructorInstance;
import jif.types.JifContext;
import jif.types.JifFieldInstance;
import jif.types.JifTypeSystem;
import jif.types.PathMap;
import jif.types.SemanticDetailedException;
import jif.types.label.Label;
import jif.visit.LabelChecker;
import polyglot.ast.Assign;
import polyglot.ast.Block;
import polyglot.ast.Call;
import polyglot.ast.ConstructorCall;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldAssign;
import polyglot.ast.Node;
import polyglot.ast.Special;
import polyglot.ast.Stmt;
import polyglot.main.Report;
import polyglot.types.Context;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.visit.NodeVisitor;

public class JifConstructorDeclExt
extends JifProcedureDeclExt_c {
    public JifConstructorDeclExt(ToJavaExt toJava) {
        super(toJava);
    }

    public Node labelCheck(LabelChecker lc) throws SemanticException {
        JifConstructorDecl mn = (JifConstructorDecl)this.node();
        JifTypeSystem ts = lc.jifTypeSystem();
        JifContext A = lc.jifContext();
        A = (JifContext)mn.del().enterScope((Context)A);
        JifConstructorInstance ci = (JifConstructorInstance)mn.constructorInstance();
        lc = lc.context(A);
        List formals = this.checkFormals(mn.formals(), ci, lc);
        Label Li = this.checkEnforceSignature(ci, lc);
        Block body = null;
        body = this.checkInitsAndBody(Li, ci, mn.body(), lc);
        PathMap X = JifConstructorDeclExt.getPathMap((Node)body);
        if (Report.should_report((String)jif_verbose, (int)3)) {
            Report.report((int)3, (String)("Body path labels = " + X));
        }
        this.addReturnConstraints(Li, X, ci, lc, (Type)ts.Void());
        mn = (JifConstructorDecl)JifConstructorDeclExt.updatePathMap((Node)mn.formals(formals).body(body), X);
        return mn;
    }

    protected static Set uninitFinalFields(ReferenceType type) {
        LinkedHashSet<JifFieldInstance> s = new LinkedHashSet<JifFieldInstance>();
        for (JifFieldInstance fi : type.fields()) {
            if (!fi.flags().isFinal() || fi.hasInitializer()) continue;
            s.add(fi);
        }
        return s;
    }

    protected Block checkInitsAndBody(Label Li, JifConstructorInstance ci, Block body, LabelChecker lc) throws SemanticException {
        JifContext A = lc.jifContext();
        JifTypeSystem ts = lc.jifTypeSystem();
        A = (JifContext)A.pushBlock();
        lc = lc.context(A);
        PathMap X = ts.pathMap();
        X = X.N(A.pc());
        Set uninitFinalVars = JifConstructorDeclExt.uninitFinalFields(ci.container());
        A.setCheckingInits(true);
        Label Lr = ci.returnLabel();
        if (Lr == null) {
            Lr = ts.bottomLabel(ci.position());
        }
        A.setPc(ts.bottomLabel(), lc);
        A.setConstructorReturnLabel(Lr);
        LinkedList<Stmt> stmts = new LinkedList<Stmt>();
        boolean preDangerousSuperCall = true;
        boolean seenSuperCall = false;
        for (Stmt s : body.statements()) {
            if (seenSuperCall && uninitFinalVars.isEmpty() && A.checkingInits() && this.isEscapingThis(s)) {
                this.setEndOfInitChecking(lc, ci);
            }
            if ((A = (JifContext)A.pushBlock()).checkingInits()) {
                A.addAssertionLE(ts.callSitePCLabel(ci), A.pc());
            }
            s = (Stmt)lc.context(A).labelCheck((Node)s);
            stmts.add(s);
            A = (JifContext)A.pop();
            PathMap Xs = JifConstructorDeclExt.getPathMap((Node)s);
            if (preDangerousSuperCall) {
                this.checkFinalFieldAssignment(s, uninitFinalVars, A);
                if (s instanceof ConstructorCall) {
                    ConstructorCall ccs = (ConstructorCall)s;
                    boolean wasDangerousSuperCall = this.processConstructorCall(ccs, lc, ci, uninitFinalVars);
                    if (wasDangerousSuperCall) {
                        preDangerousSuperCall = false;
                    }
                    if (ccs.kind() == ConstructorCall.SUPER) {
                        seenSuperCall = true;
                    }
                }
            }
            A.setPc(Xs.N(), lc);
            X = X.N(ts.notTaken()).join(Xs);
        }
        this.setEndOfInitChecking(lc, ci);
        A = (JifContext)A.pop();
        return (Block)JifConstructorDeclExt.updatePathMap((Node)body.statements(stmts), X);
    }

    private boolean isEscapingThis(Stmt s) {
        final boolean[] result = new boolean[]{false};
        s.visit(new NodeVisitor(){

            public Node leave(Node old, Node n, NodeVisitor v) {
                if (n instanceof Call) {
                    Call c = (Call)n;
                    if (c.target() instanceof Expr && JifUtil.effectiveExpr((Expr)c.target()) instanceof Special) {
                        result[0] = true;
                    }
                    for (Expr arg : c.arguments()) {
                        if (!(JifUtil.effectiveExpr(arg) instanceof Special)) continue;
                        result[0] = true;
                    }
                } else if (n instanceof Assign && JifUtil.effectiveExpr(((Assign)n).right()) instanceof Special) {
                    result[0] = true;
                }
                return n;
            }
        });
        return result[0];
    }

    private boolean processConstructorCall(ConstructorCall ccs, LabelChecker lc, JifConstructorInstance ci, Set uninitFinalVars) throws SemanticException {
        JifTypeSystem ts = lc.jifTypeSystem();
        boolean wasDangerousSuperCall = false;
        if (ccs.kind() == ConstructorCall.THIS) {
            this.setEndOfInitChecking(lc, ci);
        } else if (ccs.kind() == ConstructorCall.SUPER && ts.isJifClass((Type)ci.container()) && (!ts.isJifClass((Type)ci.container()) || ts.isJifClass(ci.container().superType()) || ts.hasUntrustedAncestor((Type)ci.container()) != null)) {
            wasDangerousSuperCall = true;
            this.setEndOfInitChecking(lc, ci);
            Iterator i = uninitFinalVars.iterator();
            if (i.hasNext()) {
                JifFieldInstance fi = (JifFieldInstance)i.next();
                throw new SemanticDetailedException("Final field \"" + fi.name() + "\" must be initialized before " + "calling the superclass constructor.", "All final fields of a class must be initialized before the superclass constructor is called, to prevent ancestor classes from reading uninitialized final fields. The final field \"" + fi.name() + "\" needs to " + "be initialized before the superclass " + "constructor call.", ccs.position());
            }
        }
        return wasDangerousSuperCall;
    }

    private void setEndOfInitChecking(LabelChecker lc, JifConstructorInstance ci) {
        JifContext A = lc.context();
        A.setCheckingInits(false);
        A.setConstructorReturnLabel(null);
        A.setPc(lc.upperBound(A.pc(), lc.typeSystem().callSitePCLabel(ci)), lc);
    }

    protected void checkFinalFieldAssignment(Stmt s_, Set uninitFinalVars, JifContext A) throws SemanticException {
        ArrayList<Stmt> initializers = new ArrayList<Stmt>();
        if (s_ instanceof Block) {
            Block b = (Block)s_;
            List stmts = b.statements();
            initializers.addAll(stmts);
        } else {
            initializers.add(s_);
        }
        for (Stmt s : initializers) {
            if (!(s instanceof Eval) || !(((Eval)s).expr() instanceof FieldAssign)) {
                return;
            }
            FieldAssign ass = (FieldAssign)((Eval)s).expr();
            Field f = (Field)ass.left();
            JifFieldInstance assFi = (JifFieldInstance)f.fieldInstance();
            if (ass.operator() != Assign.ASSIGN || !(f.target() instanceof Special) || ((Special)f.target()).kind() != Special.THIS || !assFi.flags().isFinal()) {
                return;
            }
            uninitFinalVars.remove(assFi);
        }
    }
}

