/*
 * Decompiled with CFR 0.152.
 */
package jif.ast;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import jif.ast.AmbLabelNode_c;
import jif.ast.JifNodeFactory;
import jif.ast.LabelNode;
import jif.ast.MeetLabelNode;
import jif.ast.PolicyNode;
import jif.types.JifTypeSystem;
import jif.types.label.ConfPolicy;
import jif.types.label.Label;
import jif.types.label.Policy;
import polyglot.ast.Node;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class MeetLabelNode_c
extends AmbLabelNode_c
implements MeetLabelNode {
    protected List components;

    public MeetLabelNode_c(Position pos, List components) {
        super(pos);
        this.components = TypedList.copyAndCheck((List)components, Node.class, (boolean)true);
    }

    public List components() {
        return this.components;
    }

    public MeetLabelNode components(List components) {
        MeetLabelNode_c n = (MeetLabelNode_c)this.copy();
        n.components = TypedList.copyAndCheck((List)components, Node.class, (boolean)true);
        return n;
    }

    protected MeetLabelNode_c reconstruct(List components) {
        if (!CollectionUtil.equals((Collection)components, (Collection)this.components)) {
            MeetLabelNode_c n = (MeetLabelNode_c)this.copy();
            n.components = TypedList.copyAndCheck((List)components, Node.class, (boolean)true);
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        List components = this.visitList(this.components, v);
        return this.reconstruct(components);
    }

    public Node disambiguate(AmbiguityRemover sc) throws SemanticException {
        JifTypeSystem ts = (JifTypeSystem)sc.typeSystem();
        JifNodeFactory nf = (JifNodeFactory)sc.nodeFactory();
        LinkedHashSet<Label> labels = new LinkedHashSet<Label>();
        LinkedHashSet<Policy> policies = new LinkedHashSet<Policy>();
        boolean policyTypeIsConf = false;
        for (Node n : this.components) {
            if (!n.isDisambiguated()) {
                sc.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
                return this;
            }
            if (n instanceof PolicyNode) {
                Policy pol = ((PolicyNode)n).policy();
                if (policies.isEmpty()) {
                    policyTypeIsConf = pol instanceof ConfPolicy;
                } else if (policyTypeIsConf != pol instanceof ConfPolicy) {
                    throw new SemanticException("Incompatible kinds of policies for the meet expression.", this.position);
                }
                policies.add(pol);
                continue;
            }
            if (n instanceof LabelNode) {
                labels.add(((LabelNode)n).label());
                continue;
            }
            throw new InternalCompilerError("Unexpected node " + n);
        }
        if (!labels.isEmpty() && !policies.isEmpty()) {
            throw new SemanticException("Cannot take the meet of labels and policies.", this.position);
        }
        if (!policies.isEmpty()) {
            Policy mp = policyTypeIsConf ? ts.meetConfPolicy(this.position, policies) : ts.meetIntegPolicy(this.position, policies);
            return nf.PolicyNode(this.position, mp);
        }
        return nf.CanonicalLabelNode(this.position(), ts.meetLabel(this.position(), labels));
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        Iterator i = this.components.iterator();
        while (i.hasNext()) {
            LabelNode n = (LabelNode)i.next();
            this.print(n, w, tr);
            if (!i.hasNext()) continue;
            w.write(";");
            w.allowBreak(0, " ");
        }
    }
}

