/*
 * Decompiled with CFR 0.152.
 */
package jif.ast;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import jif.ast.AmbLabelNode_c;
import jif.ast.JifNodeFactory;
import jif.ast.JoinLabelNode;
import jif.ast.LabelNode;
import jif.ast.PolicyNode;
import jif.types.JifTypeSystem;
import jif.types.label.ConfPolicy;
import jif.types.label.IntegPolicy;
import jif.types.label.Label;
import jif.types.label.PairLabel;
import jif.types.label.Policy;
import polyglot.ast.Node;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class JoinLabelNode_c
extends AmbLabelNode_c
implements JoinLabelNode {
    protected List components;

    public JoinLabelNode_c(Position pos, List components) {
        super(pos);
        this.components = TypedList.copyAndCheck((List)components, Node.class, (boolean)true);
    }

    public List components() {
        return this.components;
    }

    public JoinLabelNode components(List components) {
        JoinLabelNode_c n = (JoinLabelNode_c)this.copy();
        n.components = TypedList.copyAndCheck((List)components, Node.class, (boolean)true);
        return n;
    }

    protected JoinLabelNode_c reconstruct(List components) {
        if (!CollectionUtil.equals((Collection)components, (Collection)this.components)) {
            JoinLabelNode_c n = (JoinLabelNode_c)this.copy();
            n.components = TypedList.copyAndCheck((List)components, Node.class, (boolean)true);
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        List components = this.visitList(this.components, v);
        return this.reconstruct(components);
    }

    public Node disambiguate(AmbiguityRemover sc) throws SemanticException {
        JifTypeSystem ts = (JifTypeSystem)sc.typeSystem();
        JifNodeFactory nf = (JifNodeFactory)sc.nodeFactory();
        LinkedHashSet<Label> s = new LinkedHashSet<Label>();
        LinkedHashSet<Policy> confPolicies = new LinkedHashSet<Policy>();
        LinkedHashSet<Policy> integPolicies = new LinkedHashSet<Policy>();
        for (Node n : this.components) {
            if (!n.isDisambiguated()) {
                sc.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
                return this;
            }
            if (n instanceof PolicyNode) {
                Policy pol = ((PolicyNode)n).policy();
                if (pol instanceof ConfPolicy) {
                    confPolicies.add(pol);
                    continue;
                }
                integPolicies.add(pol);
                continue;
            }
            if (n instanceof LabelNode) {
                s.add(((LabelNode)n).label());
                continue;
            }
            throw new InternalCompilerError("Unexpected node: " + n);
        }
        if (!confPolicies.isEmpty() || !integPolicies.isEmpty()) {
            ConfPolicy cp = ts.bottomConfPolicy(this.position());
            IntegPolicy ip = ts.topIntegPolicy(this.position());
            if (!confPolicies.isEmpty()) {
                cp = ts.joinConfPolicy(this.position(), confPolicies);
            }
            if (!integPolicies.isEmpty()) {
                ip = ts.joinIntegPolicy(this.position(), integPolicies);
            }
            PairLabel pl = ts.pairLabel(this.position(), cp, ip);
            s.add(pl);
        }
        return nf.CanonicalLabelNode(this.position(), ts.joinLabel(this.position(), s));
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        Iterator i = this.components.iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            this.print(n, w, tr);
            if (!i.hasNext()) continue;
            w.write(";");
            w.allowBreak(0, " ");
        }
    }
}

