/*
 * Decompiled with CFR 0.152.
 */
package jif.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import jif.ast.ConstraintNode;
import jif.ast.JifMethodDecl;
import jif.ast.LabelNode;
import jif.types.Assertion;
import jif.types.DefaultSignature;
import jif.types.JifMethodInstance;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.TypeSubstitutor;
import jif.types.label.AccessPath;
import jif.types.label.AccessPathLocal;
import jif.types.label.AccessPathRoot;
import jif.types.label.ArgLabel;
import jif.types.label.Label;
import polyglot.ast.Block;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.MethodDecl_c;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.types.Flags;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;

public class JifMethodDecl_c
extends MethodDecl_c
implements JifMethodDecl {
    protected LabelNode startLabel;
    protected LabelNode returnLabel;
    protected List constraints;

    public JifMethodDecl_c(Position pos, Flags flags, TypeNode returnType, Id name, LabelNode startLabel, List formals, LabelNode returnLabel, List throwTypes, List constraints, Block body) {
        super(pos, flags, returnType, name, formals, throwTypes, body);
        this.startLabel = startLabel;
        this.returnLabel = returnLabel;
        this.constraints = TypedList.copyAndCheck((List)constraints, ConstraintNode.class, (boolean)true);
    }

    public LabelNode startLabel() {
        return this.startLabel;
    }

    public JifMethodDecl startLabel(LabelNode startLabel) {
        JifMethodDecl_c n = (JifMethodDecl_c)this.copy();
        n.startLabel = startLabel;
        return n;
    }

    public LabelNode returnLabel() {
        return this.returnLabel;
    }

    public JifMethodDecl returnLabel(LabelNode returnLabel) {
        JifMethodDecl_c n = (JifMethodDecl_c)this.copy();
        n.returnLabel = returnLabel;
        return n;
    }

    public List constraints() {
        return this.constraints;
    }

    public JifMethodDecl constraints(List constraints) {
        JifMethodDecl_c n = (JifMethodDecl_c)this.copy();
        n.constraints = TypedList.copyAndCheck((List)constraints, ConstraintNode.class, (boolean)true);
        return n;
    }

    public Node visitChildren(NodeVisitor v) {
        Id name = (Id)this.visitChild((Node)this.name, v);
        TypeNode returnType = (TypeNode)this.visitChild((Node)this.returnType, v);
        LabelNode startLabel = (LabelNode)this.visitChild(this.startLabel, v);
        List formals = this.visitList(this.formals, v);
        LabelNode returnLabel = (LabelNode)this.visitChild(this.returnLabel, v);
        List throwTypes = this.visitList(this.throwTypes, v);
        List constraints = this.visitList(this.constraints, v);
        Block body = (Block)this.visitChild((Node)this.body, v);
        return this.reconstruct(name, returnType, startLabel, formals, returnLabel, throwTypes, constraints, body);
    }

    protected JifMethodDecl_c reconstruct(Id name, TypeNode returnType, LabelNode startLabel, List formals, LabelNode returnLabel, List throwTypes, List constraints, Block body) {
        if (startLabel != this.startLabel || returnLabel != this.returnLabel || !CollectionUtil.equals((Collection)constraints, (Collection)this.constraints)) {
            JifMethodDecl_c n = (JifMethodDecl_c)this.copy();
            n.startLabel = startLabel;
            n.returnLabel = returnLabel;
            n.constraints = TypedList.copyAndCheck((List)constraints, ConstraintNode.class, (boolean)true);
            return (JifMethodDecl_c)n.reconstruct(returnType, name, formals, throwTypes, body);
        }
        return (JifMethodDecl_c)super.reconstruct(returnType, name, formals, throwTypes, body);
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        Label Lr;
        Label Li;
        JifMethodDecl n = (JifMethodDecl)super.disambiguate(ar);
        JifMethodInstance jmi = (JifMethodInstance)n.methodInstance();
        JifTypeSystem jts = (JifTypeSystem)ar.typeSystem();
        ArrayList<Type> formalTypes = new ArrayList<Type>(n.formals().size());
        for (Formal f : n.formals()) {
            if (!f.isDisambiguated()) {
                ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
                return this;
            }
            formalTypes.add(f.declType());
        }
        jmi.setFormalTypes(formalTypes);
        if (!n.returnType().isDisambiguated()) {
            ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
            return this;
        }
        DefaultSignature ds = jts.defaultSignature();
        if (n.startLabel() != null && !n.startLabel().isDisambiguated()) {
            ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
            return this;
        }
        Type declrt = n.returnType().type();
        if (!declrt.isVoid() && !jts.isLabeled(declrt)) {
            declrt = jts.labeledType(declrt.position(), declrt, ds.defaultReturnValueLabel(n));
            n = (JifMethodDecl)n.returnType(n.returnType().type(declrt));
        }
        jmi.setReturnType(declrt);
        if (n.returnLabel() != null && !n.returnLabel().isDisambiguated()) {
            ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
            return this;
        }
        boolean isDefaultPCBound = false;
        if (n.startLabel() == null) {
            Li = ds.defaultPCBound(n.position(), n.name());
            isDefaultPCBound = true;
        } else {
            Li = n.startLabel().label();
        }
        jmi.setPCBound(Li, isDefaultPCBound);
        boolean isDefaultReturnLabel = false;
        if (n.returnLabel() == null) {
            Lr = ds.defaultReturnLabel(n);
            isDefaultReturnLabel = true;
        } else {
            Lr = n.returnLabel().label();
        }
        jmi.setReturnLabel(Lr, isDefaultReturnLabel);
        LinkedList<Type> throwTypes = new LinkedList<Type>();
        for (TypeNode tn : n.throwTypes()) {
            if (!tn.isDisambiguated()) {
                ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
                return this;
            }
            Type xt = tn.type();
            if (!jts.isLabeled(xt)) {
                xt = jts.labeledType(xt.position(), xt, Lr);
            }
            throwTypes.add(xt);
        }
        jmi.setThrowTypes(throwTypes);
        ArrayList constraints = new ArrayList(n.constraints().size());
        for (ConstraintNode cn : n.constraints()) {
            if (!cn.isDisambiguated()) {
                ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
                return this;
            }
            constraints.addAll(cn.constraints());
        }
        jmi.setConstraints(constraints);
        JifMethodDecl_c.renameArgs(jmi, new TypeSubstitutor(new ArgRenamer(false)));
        return n.methodInstance(jmi);
    }

    public static JifMethodInstance unrenameArgs(JifMethodInstance jmi) {
        jmi = (JifMethodInstance)jmi.copy();
        try {
            JifMethodDecl_c.renameArgs(jmi, new TypeSubstitutor(new ArgRenamer(true)));
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Unexpected semantic", (Throwable)e);
        }
        return jmi;
    }

    private static void renameArgs(JifMethodInstance jmi, TypeSubstitutor tsub) throws SemanticException {
        ArrayList<Type> formalTypes = new ArrayList<Type>(jmi.formalTypes().size());
        for (Type t : jmi.formalTypes()) {
            formalTypes.add(tsub.rewriteType(t));
        }
        jmi.setFormalTypes(formalTypes);
        jmi.setReturnType(tsub.rewriteType(jmi.returnType()));
        jmi.setPCBound(tsub.rewriteLabel(jmi.pcBound()), jmi.isDefaultPCBound());
        jmi.setReturnLabel(tsub.rewriteLabel(jmi.returnLabel()), jmi.isDefaultReturnLabel());
        ArrayList<Type> throwTypes = new ArrayList<Type>(jmi.throwTypes().size());
        for (Type t : jmi.throwTypes()) {
            throwTypes.add(tsub.rewriteType(t));
        }
        jmi.setThrowTypes(throwTypes);
        ArrayList<Assertion> constraints = new ArrayList<Assertion>(jmi.constraints().size());
        for (Assertion c : jmi.constraints()) {
            constraints.add(tsub.rewriteAssertion(c));
        }
        jmi.setConstraints(constraints);
    }

    private static class ArgRenamer
    extends LabelSubstitution {
        boolean revertToOriginal;

        ArgRenamer(boolean revertToOriginal) {
            this.revertToOriginal = revertToOriginal;
        }

        public Label substLabel(Label L) {
            if (L instanceof ArgLabel) {
                ArgLabel al = (ArgLabel)L;
                if (!this.revertToOriginal && !al.name().endsWith("'")) {
                    al = (ArgLabel)al.copy();
                    al.setName(al.name() + "'");
                    return al;
                }
                if (this.revertToOriginal && al.name().endsWith("'")) {
                    al = (ArgLabel)al.copy();
                    al.setName(al.name().substring(0, al.name().length() - 1));
                    return al;
                }
            }
            return L;
        }

        public AccessPath substAccessPath(AccessPath ap) {
            AccessPathRoot r = ap.root();
            if (r instanceof AccessPathLocal) {
                AccessPathLocal apl = (AccessPathLocal)r;
                if (!this.revertToOriginal && !apl.name().endsWith("'")) {
                    apl = apl.name(apl.name() + "'");
                    AccessPath newPath = ap.subst(r, apl);
                    return newPath;
                }
                if (this.revertToOriginal && apl.name().endsWith("'")) {
                    apl = apl.name(apl.name().substring(0, apl.name().length() - 1));
                    AccessPath newPath = ap.subst(r, apl);
                    return newPath;
                }
            }
            return ap;
        }
    }
}

