/*
 * Decompiled with CFR 0.152.
 */
package jif.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jif.ast.JifUtil;
import jif.types.JifContext;
import jif.types.JifPolyType;
import jif.types.JifSubst;
import jif.types.JifSubstType;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.Param;
import jif.types.ParamInstance;
import jif.types.label.AccessPath;
import jif.types.label.AccessPathRoot;
import jif.types.label.AccessPathThis;
import jif.types.label.AccessPathUninterpreted;
import jif.types.label.ArgLabel;
import jif.types.label.Label;
import jif.types.label.ThisLabel;
import jif.types.label.UnknownLabel;
import jif.types.principal.Principal;
import polyglot.ast.Expr;
import polyglot.types.ArrayType;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class JifInstantiator {
    private final JifTypeSystem ts;
    private final ReferenceType receiverType;
    private final Label receiverLbl;
    private final AccessPath receiverPath;
    private final List formalArgLabels;
    private final List formalArgTypes;
    private final List actualArgLabels;
    private final List actualArgExprs;
    private final List actualParamLabels;
    private final JifContext callerContext;
    private final List formalTempLabels;
    private final List formalTempAccessPathRoots;
    private final AccessPathRoot tempThisRoot;
    private final Label tempThisLbl;

    private JifInstantiator(ReferenceType receiverType, Label receiverLbl, AccessPath receiverPath, List formalArgLabels, List formalArgTypes, List actualArgLabels, List actualArgExprs, List actualParamLabels, JifContext callerContext) {
        this.callerContext = callerContext;
        this.receiverType = receiverType;
        this.receiverLbl = receiverLbl;
        this.receiverPath = receiverPath;
        this.formalArgLabels = formalArgLabels;
        this.formalArgTypes = formalArgTypes;
        this.actualArgLabels = actualArgLabels;
        this.actualArgExprs = actualArgExprs;
        this.actualParamLabels = actualParamLabels;
        this.ts = (JifTypeSystem)callerContext.typeSystem();
        if (formalArgLabels != null) {
            this.formalTempAccessPathRoots = new ArrayList(formalArgLabels.size());
            this.formalTempLabels = new ArrayList(formalArgLabels.size());
            for (int i = 0; i < formalArgLabels.size(); ++i) {
                UnknownLabel t = this.ts.unknownLabel(Position.compilerGenerated());
                t.setDescription("temp formal arg " + i);
                this.formalTempLabels.add(t);
                this.formalTempAccessPathRoots.add(new AccessPathUninterpreted("temp arg path", Position.compilerGenerated(), true));
            }
        } else {
            this.formalTempAccessPathRoots = null;
            this.formalTempLabels = null;
        }
        this.tempThisLbl = this.ts.unknownLabel(Position.compilerGenerated());
        this.tempThisLbl.setDescription("temp this");
        this.tempThisRoot = new AccessPathUninterpreted("temp this", Position.compilerGenerated(), true);
    }

    private Object substTempsForFormals(Object L, Position pos) {
        int i;
        if (L == null) {
            return null;
        }
        for (i = 0; this.formalArgLabels != null && i < this.formalArgLabels.size(); ++i) {
            Label temp = (Label)this.formalTempLabels.get(i);
            ArgLabel formalArgLbl = (ArgLabel)this.formalArgLabels.get(i);
            try {
                L = this.substImpl(L, new LabelInstantiator(formalArgLbl, temp, false));
                continue;
            }
            catch (SemanticException e) {
                throw new InternalCompilerError("Unexpected SemanticException during label substitution: " + e.getMessage(), pos);
            }
        }
        try {
            L = this.substImpl(L, new ThisLabelInstantiator(this.tempThisLbl));
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Unexpected SemanticException during label substitution: " + e.getMessage(), pos);
        }
        for (i = 0; this.formalArgLabels != null && i < this.formalArgLabels.size(); ++i) {
            try {
                ArgLabel formalArgLbl = (ArgLabel)this.formalArgLabels.get(i);
                if (!formalArgLbl.formalInstance().flags().isFinal()) continue;
                AccessPathRoot formalRoot = (AccessPathRoot)JifUtil.varInstanceToAccessPath(formalArgLbl.formalInstance(), formalArgLbl.name(), formalArgLbl.position());
                AccessPathRoot tempRoot = (AccessPathRoot)this.formalTempAccessPathRoots.get(i);
                L = this.substImpl(L, new AccessPathInstantiator(formalRoot, tempRoot));
                continue;
            }
            catch (SemanticException e) {
                throw new InternalCompilerError("Unexpected SemanticException " + e.getMessage(), pos);
            }
        }
        if (this.receiverType != null && this.receiverType.isClass()) {
            AccessPathThis formalThisRoot = new AccessPathThis(this.receiverType.toClass(), this.receiverType.position());
            try {
                L = this.substImpl(L, new AccessPathInstantiator(formalThisRoot, this.tempThisRoot));
            }
            catch (SemanticException e) {
                throw new InternalCompilerError("Unexpected SemanticException " + e.getMessage(), pos);
            }
        }
        return L;
    }

    private Object instantiateImpl(Object L, Position pos) {
        if (L == null) {
            return L;
        }
        ThisLabelAndParamInstantiator labelInstantiator = new ThisLabelAndParamInstantiator();
        try {
            L = this.substImpl(L, labelInstantiator);
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Unexpected SemanticException during label substitution: " + e.getMessage(), pos);
        }
        try {
            L = this.substImpl(L, new AccessPathInstantiator(this.tempThisRoot, this.receiverPath));
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Unexpected SemanticException during label substitution: " + e.getMessage(), pos);
        }
        for (int i = 0; this.formalTempLabels != null && i < this.formalTempLabels.size(); ++i) {
            Label formalArgTempLbl = (Label)this.formalTempLabels.get(i);
            if (this.actualArgLabels != null) {
                Label actualArgLbl = (Label)this.actualArgLabels.get(i);
                try {
                    L = this.substImpl(L, new ExactLabelInstantiator(formalArgTempLbl, actualArgLbl));
                }
                catch (SemanticException e) {
                    throw new InternalCompilerError("Unexpected SemanticException during label substitution: " + e.getMessage(), pos);
                }
            }
            if (this.actualArgExprs == null) continue;
            try {
                Expr actualExpr = (Expr)this.actualArgExprs.get(i);
                Type formalArgType = (Type)this.formalArgTypes.get(i);
                AccessPath target = JifUtil.isFinalAccessExprOrConst(this.ts, actualExpr, formalArgType) ? JifUtil.exprToAccessPath(actualExpr, formalArgType, this.callerContext) : new AccessPathUninterpreted(actualExpr, actualExpr.position());
                AccessPathRoot formalTempRoot = (AccessPathRoot)this.formalTempAccessPathRoots.get(i);
                L = this.substImpl(L, new AccessPathInstantiator(formalTempRoot, target));
                continue;
            }
            catch (SemanticException e) {
                throw new InternalCompilerError("Unexpected SemanticException during label substitution: " + e.getMessage(), pos);
            }
        }
        if (this.actualParamLabels != null && !this.actualParamLabels.isEmpty() && this.receiverType != null) {
            JifSubstType jst = (JifSubstType)this.receiverType;
            JifPolyType jpt = (JifPolyType)jst.base();
            Iterator iFormalParams = jpt.params().iterator();
            Iterator iActualParamLabels = this.actualParamLabels.iterator();
            if (jpt.params().size() != this.actualParamLabels.size()) {
                throw new InternalCompilerError("Inconsistent sizes for params. Error, please contact a Jif developer");
            }
            while (iActualParamLabels.hasNext()) {
                Label actualParamLabel = (Label)iActualParamLabels.next();
                ParamInstance pi = (ParamInstance)iFormalParams.next();
                ArgLabel paramArgLabel = this.ts.argLabel(pi.position(), pi);
                paramArgLabel.setUpperBound(this.ts.topLabel());
                try {
                    L = this.substImpl(L, new LabelInstantiator(paramArgLabel, actualParamLabel));
                }
                catch (SemanticException e) {
                    throw new InternalCompilerError("Unexpected SemanticException during label substitution: " + e.getMessage(), pos);
                }
            }
            if (iActualParamLabels.hasNext() || iFormalParams.hasNext()) {
                throw new InternalCompilerError("Inconsistent param lists");
            }
        }
        try {
            this.substImpl(L, new CheckLeftOvers());
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Unexpected SemanticException during label substitution: " + e.getMessage(), pos);
        }
        return L;
    }

    private Object substImpl(Object o, LabelSubstitution lblsubst) throws SemanticException {
        if (o instanceof Principal) {
            return ((Principal)o).subst(lblsubst);
        }
        return ((Label)o).subst(lblsubst);
    }

    public Principal instantiate(Principal p) {
        p = (Principal)this.substTempsForFormals(p, p.position());
        return (Principal)this.instantiateImpl(p, p.position());
    }

    public Label instantiate(Label L) {
        L = (Label)this.substTempsForFormals(L, L.position());
        return (Label)this.instantiateImpl(L, L.position());
    }

    public Type instantiate(Type t) {
        if (t instanceof ArrayType) {
            ArrayType at = (ArrayType)t;
            Type baseType = at.base();
            t = at.base(this.instantiate(baseType));
        }
        if (this.ts.isLabeled(t)) {
            Label newL = this.instantiate(this.ts.labelOfType(t));
            Type newT = this.instantiate(this.ts.unlabel(t));
            return this.ts.labeledType(t.position(), newT, newL);
        }
        if (t instanceof JifSubstType) {
            JifSubstType jit = (JifSubstType)t;
            HashMap newMap = new HashMap();
            boolean diff = false;
            Iterator i = jit.entries();
            while (i.hasNext()) {
                Param p;
                Map.Entry e = (Map.Entry)i.next();
                Object arg = e.getValue();
                if (arg instanceof Label) {
                    p = this.instantiate((Label)arg);
                } else if (arg instanceof Principal) {
                    p = this.instantiate((Principal)arg);
                } else {
                    throw new InternalCompilerError("Unexpected type for entry: " + arg.getClass().getName());
                }
                newMap.put(e.getKey(), (Label)p);
                if (p == arg) continue;
                diff = true;
            }
            if (diff) {
                t = this.ts.subst(jit.base(), newMap);
            }
        }
        return t;
    }

    public static Label instantiate(Label L, JifContext callerContext, Expr receiverExpr, ReferenceType receiverType, Label receiverLabel, List formalArgLabels, List formalArgTypes, List actualArgLabels, List actualArgExprs, List actualParamLabels) throws SemanticException {
        JifTypeSystem ts = (JifTypeSystem)callerContext.typeSystem();
        AccessPath receiverPath = JifUtil.isFinalAccessExprOrConst(ts, receiverExpr, (Type)receiverType) ? JifUtil.exprToAccessPath(receiverExpr, (Type)receiverType, callerContext) : new AccessPathUninterpreted(receiverExpr, L.position());
        JifInstantiator inst = new JifInstantiator(receiverType, receiverLabel, receiverPath, formalArgLabels, formalArgTypes, actualArgLabels, actualArgExprs, actualParamLabels, callerContext);
        return inst.instantiate(L);
    }

    public static Label instantiate(Label L, JifContext callerContext, Expr receiverExpr, ReferenceType receiverType, Label receiverLbl) throws SemanticException {
        JifTypeSystem ts = (JifTypeSystem)callerContext.typeSystem();
        AccessPath receiverPath = JifUtil.isFinalAccessExprOrConst(ts, receiverExpr, (Type)receiverType) ? JifUtil.exprToAccessPath(receiverExpr, (Type)receiverType, callerContext) : new AccessPathUninterpreted(receiverExpr, L.position());
        return JifInstantiator.instantiate(L, callerContext, receiverPath, receiverType, receiverLbl);
    }

    public static Label instantiate(Label L, JifContext callerContext, AccessPath receiverPath, ReferenceType receiverType, Label receiverLbl) {
        JifInstantiator inst = new JifInstantiator(receiverType, receiverLbl, receiverPath, null, null, null, null, null, callerContext);
        return inst.instantiate(L);
    }

    public static Type instantiate(Type t, JifContext callerContext, AccessPath receiverPath, ReferenceType receiverType, Label receiverLbl) {
        JifInstantiator inst = new JifInstantiator(receiverType, receiverLbl, receiverPath, null, null, null, null, null, callerContext);
        return inst.instantiate(t);
    }

    public static Principal instantiate(Principal p, JifContext callerContext, Expr receiverExpr, ReferenceType receiverType, Label receiverLabel, List formalArgLabels, List formalArgTypes, List actualArgExprs, List actualParamLabels) throws SemanticException {
        JifTypeSystem ts = (JifTypeSystem)callerContext.typeSystem();
        AccessPath receiverPath = JifUtil.isFinalAccessExprOrConst(ts, receiverExpr, (Type)receiverType) ? JifUtil.exprToAccessPath(receiverExpr, (Type)receiverType, callerContext) : new AccessPathUninterpreted(receiverExpr, p.position());
        JifInstantiator inst = new JifInstantiator(receiverType, receiverLabel, receiverPath, formalArgLabels, formalArgTypes, null, actualArgExprs, actualParamLabels, callerContext);
        return inst.instantiate(p);
    }

    public static Type instantiate(Type t, JifContext callerContext, Expr receiverExpr, ReferenceType receiverType, Label receiverLabel, List formalArgLabels, List formalArgTypes, List actualArgLabels, List actualArgExprs, List actualParamLabels) throws SemanticException {
        JifTypeSystem ts = (JifTypeSystem)callerContext.typeSystem();
        AccessPath receiverPath = JifUtil.isFinalAccessExprOrConst(ts, receiverExpr, (Type)receiverType) ? JifUtil.exprToAccessPath(receiverExpr, (Type)receiverType, callerContext) : new AccessPathUninterpreted(receiverExpr, t.position());
        JifInstantiator inst = new JifInstantiator(receiverType, receiverLabel, receiverPath, formalArgLabels, formalArgTypes, actualArgLabels, actualArgExprs, actualParamLabels, callerContext);
        return inst.instantiate(t);
    }

    public static Type instantiate(Type t, JifContext callerContext, Expr receiverExpr, ReferenceType receiverType, Label receiverLbl) throws SemanticException {
        JifTypeSystem ts = (JifTypeSystem)callerContext.typeSystem();
        AccessPath receiverPath = JifUtil.isFinalAccessExprOrConst(ts, receiverExpr, (Type)receiverType) ? JifUtil.exprToAccessPath(receiverExpr, (Type)receiverType, callerContext) : new AccessPathUninterpreted(receiverExpr, t.position());
        JifInstantiator inst = new JifInstantiator(receiverType, receiverLbl, receiverPath, null, null, null, null, null, callerContext);
        return inst.instantiate(t);
    }

    private static class AccessPathInstantiator
    extends LabelSubstitution {
        private AccessPathRoot srcRoot;
        private AccessPath trgPath;

        protected AccessPathInstantiator(AccessPathRoot srcRoot, AccessPath trgPath) {
            this.srcRoot = srcRoot;
            this.trgPath = trgPath;
        }

        public AccessPath substAccessPath(AccessPath ap) {
            if (ap.root().equals(this.srcRoot)) {
                return ap.subst(this.srcRoot, this.trgPath);
            }
            return ap;
        }
    }

    private static class ThisLabelInstantiator
    extends LabelSubstitution {
        private Label trgLabel;

        protected ThisLabelInstantiator(Label trgLabel) {
            this.trgLabel = trgLabel;
        }

        public Label substLabel(Label L) {
            if (L instanceof ThisLabel) {
                return this.trgLabel;
            }
            return L;
        }
    }

    private static class ExactLabelInstantiator
    extends LabelSubstitution {
        private Label srcLabel;
        private Label trgLabel;

        protected ExactLabelInstantiator(Label srcLabel, Label trgLabel) {
            this.srcLabel = srcLabel;
            this.trgLabel = trgLabel;
        }

        public Label substLabel(Label L) {
            if (this.srcLabel == L) {
                return this.trgLabel;
            }
            return L;
        }
    }

    private static class LabelInstantiator
    extends LabelSubstitution {
        private Label srcLabel;
        private Label trgLabel;
        private boolean recurseArgLabelBounds;

        protected LabelInstantiator(Label srcLabel, Label trgLabel) {
            this(srcLabel, trgLabel, true);
        }

        protected LabelInstantiator(Label srcLabel, Label trgLabel, boolean recurseArgLabelBounds) {
            this.srcLabel = srcLabel;
            this.trgLabel = trgLabel;
            this.recurseArgLabelBounds = recurseArgLabelBounds;
        }

        public Label substLabel(Label L) {
            if (this.srcLabel.equals(L)) {
                return this.trgLabel;
            }
            return L;
        }

        public boolean recurseIntoChildren(Label L) {
            return this.recurseArgLabelBounds || !(L instanceof ArgLabel);
        }
    }

    private class CheckLeftOvers
    extends LabelSubstitution {
        Set thisClasses = new HashSet();

        private CheckLeftOvers() {
        }

        public Label substLabel(Label L) {
            if (L instanceof ThisLabel) {
                ThisLabel tl = (ThisLabel)L;
                if (!this.thisClasses.contains(tl.classType()) && !this.thisClasses.isEmpty()) {
                    throw new InternalCompilerError("multiple this classes: " + L);
                }
                this.thisClasses.add(tl.classType());
            }
            if (JifInstantiator.this.formalTempLabels != null && JifInstantiator.this.formalTempLabels.contains(L)) {
                throw new InternalCompilerError("Left over: " + L);
            }
            return L;
        }

        public AccessPath substAccessPath(AccessPath ap) {
            AccessPathRoot root = ap.root();
            if (JifInstantiator.this.tempThisRoot == root) {
                throw new InternalCompilerError("Left over: " + ap);
            }
            if (JifInstantiator.this.formalTempAccessPathRoots != null && JifInstantiator.this.formalTempAccessPathRoots.contains(root)) {
                throw new InternalCompilerError("Left over: " + ap);
            }
            return ap;
        }
    }

    private class ThisLabelAndParamInstantiator
    extends LabelSubstitution {
        private ThisLabelAndParamInstantiator() {
        }

        public Label substLabel(Label L) {
            Label result = L;
            if (JifInstantiator.this.receiverLbl != null && result == JifInstantiator.this.tempThisLbl) {
                result = JifInstantiator.this.receiverLbl;
            }
            if (JifInstantiator.this.receiverType instanceof JifSubstType) {
                JifSubstType t = (JifSubstType)JifInstantiator.this.receiverType;
                result = ((JifSubst)t.subst()).substLabel(result);
            }
            return result;
        }

        public Principal substPrincipal(Principal p) {
            if (JifInstantiator.this.receiverType instanceof JifSubstType) {
                JifSubst subst = (JifSubst)((JifSubstType)JifInstantiator.this.receiverType).subst();
                return subst.substPrincipal(p);
            }
            return p;
        }
    }
}

