/*
 * Decompiled with CFR 0.152.
 */
package jif.ast;

import java.util.List;
import jif.ast.DowngradeStmt;
import jif.ast.LabelNode;
import polyglot.ast.Node;
import polyglot.ast.Stmt;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;

public abstract class DowngradeStmt_c
extends Stmt_c
implements DowngradeStmt {
    private LabelNode bound;
    private LabelNode label;
    private Stmt body;

    public DowngradeStmt_c(Position pos, LabelNode bound, LabelNode label, Stmt body) {
        super(pos);
        this.bound = bound;
        this.label = label;
        this.body = body;
    }

    public LabelNode label() {
        return this.label;
    }

    public DowngradeStmt label(LabelNode label) {
        DowngradeStmt_c n = (DowngradeStmt_c)this.copy();
        n.label = label;
        return n;
    }

    public LabelNode bound() {
        return this.bound;
    }

    public DowngradeStmt bound(LabelNode b) {
        DowngradeStmt_c n = (DowngradeStmt_c)this.copy();
        n.bound = b;
        return n;
    }

    public Stmt body() {
        return this.body;
    }

    public DowngradeStmt body(Stmt body) {
        DowngradeStmt_c n = (DowngradeStmt_c)this.copy();
        n.body = body;
        return n;
    }

    protected DowngradeStmt_c reconstruct(LabelNode bound, LabelNode label, Stmt body) {
        if (this.bound != bound || this.label != label || this.body != body) {
            DowngradeStmt_c n = (DowngradeStmt_c)this.copy();
            n.bound = bound;
            n.label = label;
            n.body = body;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        LabelNode bound = this.bound == null ? null : (LabelNode)this.visitChild(this.bound, v);
        LabelNode label = (LabelNode)this.visitChild(this.label, v);
        Stmt body = (Stmt)this.visitChild((Node)this.body, v);
        return this.reconstruct(bound, label, body);
    }

    public Term firstChild() {
        return this.body;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.visitCFG((Term)this.body, (Term)this, 0);
        return succs;
    }

    public String toString() {
        if (this.bound == null) {
            return this.downgradeKind() + "(" + this.label + ") " + this.body;
        }
        return this.downgradeKind() + "(" + this.bound + " to " + this.label + ") " + this.body;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write(this.downgradeKind());
        w.write("(");
        if (this.bound != null) {
            this.print(this.bound, w, tr);
            w.write(" to ");
        }
        this.print(this.label, w, tr);
        w.write(") ");
        this.printSubStmt(this.body, w, tr);
    }

    public abstract String downgradeKind();

    public void translate(CodeWriter w, Translator tr) {
        throw new InternalCompilerError("cannot translate " + this);
    }
}

