/*
 * Decompiled with CFR 0.152.
 */
package jif.ast;

import java.util.List;
import jif.ast.DowngradeExpr;
import jif.ast.LabelNode;
import jif.types.JifTypeSystem;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Node;
import polyglot.ast.Precedence;
import polyglot.ast.Term;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;
import polyglot.visit.TypeChecker;

public abstract class DowngradeExpr_c
extends Expr_c
implements DowngradeExpr {
    private LabelNode label;
    private LabelNode bound;
    private Expr expr;

    public DowngradeExpr_c(Position pos, Expr expr, LabelNode bound, LabelNode label) {
        super(pos);
        this.expr = expr;
        this.bound = bound;
        this.label = label;
    }

    public Expr expr() {
        return this.expr;
    }

    public DowngradeExpr expr(Expr expr) {
        DowngradeExpr_c n = (DowngradeExpr_c)this.copy();
        n.expr = expr;
        return n;
    }

    public LabelNode label() {
        return this.label;
    }

    public DowngradeExpr label(LabelNode label) {
        DowngradeExpr_c n = (DowngradeExpr_c)this.copy();
        n.label = label;
        return n;
    }

    public LabelNode bound() {
        return this.bound;
    }

    public DowngradeExpr bound(LabelNode b) {
        DowngradeExpr_c n = (DowngradeExpr_c)this.copy();
        n.bound = b;
        return n;
    }

    protected DowngradeExpr_c reconstruct(Expr expr, LabelNode bound, LabelNode label) {
        if (this.expr != expr || this.bound != bound || this.label != label) {
            DowngradeExpr_c n = (DowngradeExpr_c)this.copy();
            n.expr = expr;
            n.bound = bound;
            n.label = label;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Expr expr = (Expr)this.visitChild((Node)this.expr, v);
        LabelNode bound = this.bound == null ? null : (LabelNode)this.visitChild(this.bound, v);
        LabelNode label = (LabelNode)this.visitChild(this.label, v);
        return this.reconstruct(expr, bound, label);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        return this.type(this.expr.type());
    }

    public Term firstChild() {
        return this.expr;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        JifTypeSystem ts = (JifTypeSystem)v.typeSystem();
        if (ts.Boolean().equals(ts.unlabel(this.expr.type()))) {
            v.visitCFG((Term)this.expr, FlowGraph.EDGE_KEY_TRUE, (Term)this, 0, FlowGraph.EDGE_KEY_FALSE, (Term)this, 0);
        } else {
            v.visitCFG((Term)this.expr, (Term)this, 0);
        }
        return succs;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write(this.downgradeKind());
        w.write("(");
        this.print((Node)this.expr, w, tr);
        w.write(",");
        w.allowBreak(0, " ");
        this.print(this.label, w, tr);
        w.write(")");
    }

    public void translate(CodeWriter w, Translator tr) {
        throw new InternalCompilerError("cannot translate " + this);
    }

    public String toString() {
        return this.downgradeKind() + "(" + this.expr + ", " + this.label + ")";
    }

    public Precedence precedence() {
        return this.expr.precedence();
    }
}

