/*
 * Decompiled with CFR 0.152.
 */
package jif.ast;

import jif.ast.AmbDynamicLabelNode;
import jif.ast.AmbLabelNode_c;
import jif.ast.JifNodeFactory;
import jif.ast.JifUtil;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.SemanticDetailedException;
import jif.types.label.AccessPath;
import jif.types.label.Label;
import jif.visit.JifTypeChecker;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Node;
import polyglot.frontend.MissingDependencyException;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.Goal;
import polyglot.types.Context;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class AmbDynamicLabelNode_c
extends AmbLabelNode_c
implements AmbDynamicLabelNode {
    protected Expr expr;

    public AmbDynamicLabelNode_c(Position pos, Expr expr) {
        super(pos);
        this.expr = expr;
    }

    public String toString() {
        return "*" + this.expr + "{amb}";
    }

    public Node disambiguate(AmbiguityRemover sc) throws SemanticException {
        Context c = sc.context();
        JifTypeSystem ts = (JifTypeSystem)sc.typeSystem();
        JifNodeFactory nf = (JifNodeFactory)sc.nodeFactory();
        if (!sc.isASTDisambiguated((Node)this.expr)) {
            sc.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
            return this;
        }
        JifTypeChecker tc = new JifTypeChecker(sc.job(), (TypeSystem)ts, nf, true);
        tc.setCheckConstants(false);
        tc = (TypeChecker)tc.context(sc.context());
        this.expr = (Expr)this.expr.visit((NodeVisitor)tc);
        if (this.expr.type() == null || !this.expr.type().isCanonical()) {
            Field f;
            if (this.expr instanceof Field && ts.unlabel((f = (Field)this.expr).target().type()) instanceof ParsedClassType) {
                ParsedClassType pct = (ParsedClassType)ts.unlabel(f.target().type());
                Scheduler sched = sc.job().extensionInfo().scheduler();
                Goal g = sched.Disambiguated(pct.job());
                throw new MissingDependencyException(g);
            }
            sc.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
            return this;
        }
        if (this.expr.type() != null && this.expr.type().isCanonical() && !JifUtil.isFinalAccessExprOrConst(ts, this.expr, (Type)ts.Label())) {
            AccessPath ap = JifUtil.exprToAccessPath(this.expr, (Type)ts.Label(), (JifContext)c);
            ap.verify((JifContext)c);
            throw new SemanticDetailedException("Illegal dynamic label.", "Only final access paths or label expressions can be used as a dynamic label. A final access path is an expression starting with either \"this\" or a final local variable \"v\", followed by zero or more final field accesses. That is, a final access path is either this.f1.f2....fn, or v.f1.f2.....fn, where v is a final local variables, and each field f1 to fn is a final field. A label expression is either a label parameter, or a \"new label {...}\" expression.", this.position());
        }
        Label L = JifUtil.exprToLabel(ts, this.expr, (JifContext)c);
        return nf.CanonicalLabelNode(this.position(), L);
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("*");
        this.expr.del().prettyPrint(w, tr);
    }

    public Node visitChildren(NodeVisitor v) {
        Expr expr = (Expr)this.visitChild((Node)this.expr, v);
        return this.reconstruct(expr);
    }

    protected AmbDynamicLabelNode_c reconstruct(Expr expr) {
        if (this.expr != expr) {
            AmbDynamicLabelNode_c n = (AmbDynamicLabelNode_c)this.copy();
            n.expr = expr;
            return n;
        }
        return this;
    }
}

